/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactComponentUtil {
    public static final Set<String> REACT_COMPONENT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Component", "PureComponent", "NativeComponent"});
    public static final Set<String> REACT_SINGLE_VARIANT_COMPONENT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"StatelessComponent", "ComponentType", "ComponentClass", "FunctionComponent", "SFC", "RefForwardingComponent", "FC"});
    private static final JSType STRING_TYPE = new JSStringType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);
    private static final JSType BOOLEAN_TYPE = new JSBooleanType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);

    @Nullable
    public static JSTypeSubstitutor getGenericSubstitutorForTag(@Nullable PsiElement resolve, @NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(0);
        }
        if (!(resolve instanceof TypeScriptTypeParameterListOwner) || !(tag instanceof JSXmlLiteralExpression)) {
            return null;
        }
        TypeScriptTypeArgumentList typeArgumentList = (TypeScriptTypeArgumentList)PsiTreeUtil.findChildOfType((PsiElement)tag, TypeScriptTypeArgumentList.class);
        if (typeArgumentList == null) {
            return null;
        }
        ArrayList<JSType> typeArguments = new ArrayList<JSType>();
        for (JSTypeDeclaration typeArgument : typeArgumentList.getTypeArguments()) {
            typeArguments.add(typeArgument.getJSType());
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)resolve, typeArguments);
    }

    @Nullable
    private static JSType getAttributeValueType(@Nullable XmlAttributeValue element, @NotNull PsiElement initialElement) {
        JSExpression expression;
        if (initialElement == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(1);
        }
        if (element == null) {
            return BOOLEAN_TYPE;
        }
        if (StringUtil.isQuotedString((String)element.getText())) {
            return STRING_TYPE;
        }
        PsiElement child = element.getFirstChild();
        if (child instanceof JSEmbeddedContent && (expression = (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)child, JSExpression.class)) != null) {
            return JSResolveUtil.getExpressionJSType(expression);
        }
        return JSAnyType.get(initialElement, true);
    }

    @NotNull
    private static List<JSSpreadExpression> getSpreadAttributes(@NotNull XmlTag tag) {
        JSEmbeddedContent[] possibleSpread;
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(2);
        }
        if ((possibleSpread = (JSEmbeddedContent[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JSEmbeddedContent.class)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptReactComponentUtil.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<JSSpreadExpression> result2 = new ArrayList<JSSpreadExpression>(possibleSpread.length);
        for (JSEmbeddedContent content : possibleSpread) {
            JSSpreadExpression spreadExpression;
            JSEmbeddedContent inner = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)content, JSEmbeddedContent.class);
            if (inner == null || (spreadExpression = (JSSpreadExpression)PsiTreeUtil.getChildOfType((PsiElement)inner, JSSpreadExpression.class)) == null) continue;
            result2.add(spreadExpression);
        }
        ArrayList<JSSpreadExpression> arrayList = result2;
        if (arrayList == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static JSRecordTypeImpl createRecordTypeFromTag(@NotNull XmlTag tag, @NotNull PsiElement initialElement) {
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(5);
        }
        if (initialElement == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(6);
        }
        XmlAttribute[] attributes = tag.getAttributes();
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> props = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
        for (XmlAttribute attribute : attributes) {
            props.add(new JSRecordTypeImpl.PropertySignatureImpl(attribute.getName(), TypeScriptReactComponentUtil.getAttributeValueType(attribute.getValueElement(), initialElement), false, false));
        }
        for (JSSpreadExpression spreadExpression : TypeScriptReactComponentUtil.getSpreadAttributes(tag)) {
            JSType type;
            JSExpression expression = spreadExpression.getExpression();
            if (expression == null || (type = JSResolveUtil.getExpressionJSType(expression)) == null) continue;
            for (JSRecordType.TypeMember member : type.asRecordType().getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                props.add((JSRecordTypeImpl.PropertySignatureImpl)member);
            }
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)tag, true), props);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpreadAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutorForTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValueType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpreadAttributes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRecordTypeFromTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

