/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LANGUAGE_ID", "", "SAVE_DELAY", "", "canonicalizePath", "uri", "getPositionByOffset", "Lorg/eclipse/lsp4j/Position;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "toPath", "toURI", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.impl"})
public final class FlowJSLspServiceKt {
    private static final int SAVE_DELAY = JSUtils.getSystemPropertySafely("idea.js.flow.save.delay", 2000);
    @NotNull
    public static final String LANGUAGE_ID = "javascript";

    @NotNull
    public static final Position getPositionByOffset(@NotNull Document document2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)document2, (String)"document");
        int lineNumber = document2.getLineNumber(offset);
        return new Position(lineNumber, offset - document2.getLineStartOffset(lineNumber));
    }

    @NotNull
    public static final String toURI(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        String path = FlowJSLspServiceKt.canonicalizePath(string);
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            path = '/' + path;
        }
        return "file://" + path;
    }

    @NotNull
    public static final String canonicalizePath(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return StringsKt.replace$default((String)uri, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toPath(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = FilesKt.normalize((File)new File(new URI(uri))).getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(URI(uri)).normalize().path");
        return string;
    }

    public static final /* synthetic */ int access$getSAVE_DELAY$p() {
        return SAVE_DELAY;
    }
}

