/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeWithSignature {
    @Nullable
    private final JSFunctionItem myFunction;
    @NotNull
    private final JSType myType;

    public JSTypeWithSignature(@NotNull JSType type) {
        if (type == null) {
            JSTypeWithSignature.$$$reportNull$$$0(0);
        }
        this(type, null);
    }

    public JSTypeWithSignature(@NotNull JSType jsType, @Nullable JSFunctionItem matchedFunction) {
        if (jsType == null) {
            JSTypeWithSignature.$$$reportNull$$$0(1);
        }
        this.myFunction = matchedFunction;
        this.myType = jsType;
    }

    @Nullable
    public JSFunctionItem getFunction() {
        return this.myFunction;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSTypeWithSignature.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    @NotNull
    public JSType evaluateGenerics(@Nullable JSCallItem callItem, int index, JSExpectedTypeKind inferCallGenerics) {
        if (callItem == null) {
            JSType jSType = this.myType;
            if (jSType == null) {
                JSTypeWithSignature.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        JSGenericTypesEvaluator.GenericEvaluationContext context = new JSGenericTypesEvaluator.GenericEvaluationContext(null, index, inferCallGenerics);
        JSType jSType = JSDialectSpecificHandlersFactory.forElement(callItem.getPsiContext()).getTypeEvaluationHelper().getGenericTypeEvaluator().evaluateGenerics(this.myType, callItem, (PsiElement)this.myFunction, context);
        if (jSType == null) {
            JSTypeWithSignature.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    public int resolvedHashCode() {
        return Objects.hash(this.myFunction, this.myType.resolvedHashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/types/JSTypeWithSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/types/JSTypeWithSignature";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenerics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

