/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionSignatureStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptPsiTypeParser<P extends ES6Parser>
extends JSPsiTypeParser<P> {
    private static final TokenSet NON_REFERENCE_PRIMITIVE_TYPES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VOID_KEYWORD, JSTokenTypes.ANY_KEYWORD, JSTokenTypes.SYMBOL_KEYWORD, JSTokenTypes.NEVER_KEYWORD, JSTokenTypes.UNKNOWN_KEYWORD, JSTokenTypes.OBJECT_TYPE_KEYWORD, JSTokenTypes.MIXED_KEYWORD, JSTokenTypes.NULL_KEYWORD});
    protected static final Predicate<PsiBuilder> AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE = builder -> {
        IElementType type = builder.getTokenType();
        if (type == null || type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON || type == JSTokenTypes.QUEST || type == JSTokenTypes.COLON || type == JSTokenTypes.LPAR) {
            return false;
        }
        return !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(builder);
    };
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.READONLY_KEYWORD);

    protected TypeScriptPsiTypeParser(P parser) {
        super(parser);
    }

    @Override
    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            return this.parseType();
        }
        return false;
    }

    @Override
    public boolean parseType() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (!this.parseInUnionOrIntersectionType(true, true, true)) {
            mark.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD && !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
            boolean result2 = this.parseConditionalType();
            mark.done((IElementType)TypeScriptElementTypes.CONDITIONAL_TYPE);
            return result2;
        }
        mark.drop();
        return true;
    }

    private boolean parseConditionalType() {
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.QUEST) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.question", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean parseInUnionOrIntersectionType(boolean expectedUnion, boolean isTopLevel, boolean functionTypeAllowedByContext) {
        boolean result2;
        int typeCounter = 0;
        PsiBuilder.Marker unionTypeMarker = this.builder.mark();
        do {
            if (this.builder.getTokenType() == JSTokenTypes.OR || this.builder.getTokenType() == JSTokenTypes.AND) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionType(false, isTopLevel && typeCounter == 1, functionTypeAllowedByContext) : (result2 = this.parseUnionOrIntersectionComponent(this.isFunctionTypeAllowed(isTopLevel && ++typeCounter == 1, functionTypeAllowedByContext)));
        } while (result2 && this.builder.getTokenType() == (expectedUnion ? JSTokenTypes.OR : JSTokenTypes.AND));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done((IElementType)TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result2;
    }

    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return isFirstComponent && allowedByContext;
    }

    protected boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.KEYOF_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType((IElementType)TypeScriptElementTypes.TYPE_OPERATOR_TYPE);
        }
        if (type == JSTokenTypes.AWAITED_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType((IElementType)TypeScriptElementTypes.AWAITED_TYPE);
        }
        if (type == JSTokenTypes.INFER_KEYWORD && this.parseInferType()) {
            return true;
        }
        return this.parseDistinctType(functionTypeAllowed, true);
    }

    private boolean parseInferType() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        IElementType type = this.builder.getTokenType();
        if (this.isIdentifierToken(type)) {
            this.builder.advanceLexer();
            marker.done((IElementType)TypeScriptElementTypes.INFER_TYPE);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    protected boolean advanceTypeKeywordAndNestedType(IElementType type) {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = this.parseUnionOrIntersectionComponent(true);
        marker.done(type);
        return result2;
    }

    protected boolean parseDistinctType(boolean functionTypeAllowed, boolean readonlyTypeAllowed) {
        boolean result2;
        IElementType type = this.builder.getTokenType();
        PsiBuilder.Marker typeMarker = this.builder.mark();
        PsiBuilder.Marker attListMarker = null;
        if (type == JSTokenTypes.LPAR) {
            boolean isFunctionType;
            boolean bl = isFunctionType = functionTypeAllowed && this.isFunctionTypeExpected();
            if (isFunctionType) {
                result2 = this.parseFunctionType();
            } else {
                PsiBuilder.Marker parenthesized = this.builder.mark();
                this.builder.advanceLexer();
                result2 = this.parseType();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                    this.builder.advanceLexer();
                } else {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                    result2 = false;
                }
                parenthesized.done(TypeScriptElementTypes.PARENTHESIZED_TYPE);
            }
        } else if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.LT) {
            result2 = this.parseFunctionType();
        } else if (type == JSTokenTypes.LBRACE) {
            result2 = this.isStartOfMappedType() ? this.parseMappedType() : this.parseObjectType();
        } else if (type == JSTokenTypes.LBRACKET) {
            result2 = this.parseTupleType();
        } else if (type == JSTokenTypes.IMPORT_KEYWORD) {
            result2 = true;
            PsiBuilder.Marker marker = this.builder.mark();
            this.parseImportTypeInner();
            marker.done((IElementType)TypeScriptElementTypes.SINGLE_TYPE);
        } else if (type == JSTokenTypes.TYPEOF_KEYWORD) {
            if (this.builder.lookAhead(1) == JSTokenTypes.IMPORT_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.parseImportTypeInner();
                marker.done((IElementType)TypeScriptElementTypes.SINGLE_TYPE);
            } else {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.parseTypeOfInnerExpression();
                marker.done((IElementType)TypeScriptElementTypes.TYPEOF_TYPE);
            }
            result2 = true;
        } else if (type == JSTokenTypes.THIS_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done((IElementType)TypeScriptElementTypes.THIS_TYPE);
            result2 = true;
        } else if (type == JSTokenTypes.READONLY_KEYWORD) {
            if (readonlyTypeAllowed) {
                boolean parsed = false;
                boolean canHaveArrayPostfix = true;
                attListMarker = this.builder.mark();
                this.builder.advanceLexer();
                attListMarker.done((IElementType)JSElementTypes.ATTRIBUTE_LIST);
                PsiBuilder.Marker extMarker = this.builder.mark();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                    PsiBuilder.Marker mark = this.builder.mark();
                    boolean tupleParsed = this.doParseTupleType();
                    if (tupleParsed) {
                        if (!this.areArrayBracketsFollowing()) {
                            mark.drop();
                            attListMarker.precede().done((IElementType)TypeScriptElementTypes.TUPLE_TYPE);
                            canHaveArrayPostfix = false;
                            attListMarker = null;
                        } else {
                            mark.done((IElementType)TypeScriptElementTypes.TUPLE_TYPE);
                        }
                        parsed = true;
                    } else {
                        mark.drop();
                    }
                } else {
                    boolean parsedType = this.parseDistinctType(false, false);
                    if (parsedType && this.validateReadonlyTail()) {
                        parsed = true;
                    }
                }
                if (!parsed) {
                    extMarker.drop();
                    attListMarker.rollbackTo();
                    attListMarker = null;
                    result2 = this.parseNamedOrThisType();
                } else {
                    if (canHaveArrayPostfix) {
                        typeMarker.drop();
                        typeMarker = extMarker;
                    } else {
                        extMarker.drop();
                    }
                    result2 = true;
                }
            } else {
                result2 = this.parseNamedOrThisType();
            }
        } else if (type == JSTokenTypes.THIS_KEYWORD || type == JSTokenTypes.ASSERTS_KEYWORD || NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || this.isIdentifierToken(type)) {
            result2 = this.parseNamedOrThisType();
        } else if (JSTokenTypes.STRING_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(TypeScriptStubElementTypes.STRING_LITERAL_TYPE);
            result2 = true;
        } else if (type == JSTokenTypes.BACKQUOTE && this.builder.lookAhead(1) == JSTokenTypes.STRING_TEMPLATE_PART && this.builder.lookAhead(2) == JSTokenTypes.BACKQUOTE && this.allowSingleTemplateLiteralInType()) {
            this.parseStringTemplateAsTypeLiteral();
            result2 = true;
        } else if (type == JSTokenTypes.NUMERIC_LITERAL || type == JSTokenTypes.MINUS && this.builder.lookAhead(1) == JSTokenTypes.NUMERIC_LITERAL) {
            PsiBuilder.Marker literalTypeMark = this.builder.mark();
            PsiBuilder.Marker prefixMark = null;
            if (type == JSTokenTypes.MINUS) {
                prefixMark = this.builder.mark();
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker expressionMarker = this.builder.mark();
            this.builder.advanceLexer();
            expressionMarker.done(JSStubElementTypes.LITERAL_EXPRESSION);
            if (prefixMark != null) {
                prefixMark.done(JSElementTypes.PREFIX_EXPRESSION);
            }
            literalTypeMark.done((IElementType)TypeScriptElementTypes.NUMBER_LITERAL_TYPE);
            result2 = true;
        } else if (JSTokenTypes.BOOLEAN_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(TypeScriptElementTypes.BOOLEAN_LITERAL_TYPE);
            result2 = true;
        } else {
            this.builder.error(this.getTypeNameExpectedMessage());
            result2 = false;
        }
        if (readonlyTypeAllowed) {
            result2 &= this.parseArrayTypeSuffix(typeMarker, attListMarker);
        } else {
            typeMarker.drop();
        }
        return result2;
    }

    private boolean validateReadonlyTail() {
        PsiBuilder.Marker indexerTailMarker = null;
        boolean parsedIndexerTail = true;
        boolean lastIsIndexer = false;
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            if (indexerTailMarker == null) {
                indexerTailMarker = this.builder.mark();
            }
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) {
                this.builder.advanceLexer();
                lastIsIndexer = true;
                continue;
            }
            lastIsIndexer = false;
            parsedIndexerTail = this.parseType();
            if (!parsedIndexerTail) break;
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                parsedIndexerTail = false;
                break;
            }
            this.builder.advanceLexer();
        }
        if (indexerTailMarker != null) {
            indexerTailMarker.rollbackTo();
        }
        return parsedIndexerTail && lastIsIndexer;
    }

    private void parseStringTemplateAsTypeLiteral() {
        PsiBuilder.Marker mMarker = this.builder.mark();
        PsiBuilder.Marker expressionMarker = this.builder.mark();
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        expressionMarker.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
        mMarker.done(TypeScriptStubElementTypes.STRING_LITERAL_TYPE);
    }

    protected boolean allowSingleTemplateLiteralInType() {
        return true;
    }

    private boolean areArrayBracketsFollowing() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && this.builder.lookAhead(1) == JSTokenTypes.RBRACKET;
    }

    private boolean parseNamedOrThisType() {
        boolean result2;
        boolean isAssert = this.builder.getTokenType() == JSTokenTypes.ASSERTS_KEYWORD;
        IElementType lookAhead = this.builder.lookAhead(isAssert ? 2 : 1);
        if (lookAhead == JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            if (isAssert) {
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker innerMarker = this.builder.mark();
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            if (!TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
                result2 = this.parseTypePredicate(marker);
            } else {
                marker.rollbackTo();
                result2 = this.parseSingleOrPrimitiveType();
            }
        } else if (isAssert) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            PsiBuilder.Marker innerMarker = this.builder.mark();
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            marker.done((IElementType)TypeScriptElementTypes.TYPE_PREDICATE);
            result2 = true;
        } else {
            boolean isUniqueSymbol = false;
            if (this.isIdentifierToken(lookAhead) && "unique".equals(this.builder.getTokenText())) {
                PsiBuilder.Marker mark = this.builder.mark();
                this.builder.advanceLexer();
                if (!"symbol".equals(this.builder.getTokenText())) {
                    mark.rollbackTo();
                } else {
                    this.builder.advanceLexer();
                    mark.done((IElementType)TypeScriptElementTypes.SINGLE_TYPE);
                    isUniqueSymbol = true;
                }
            }
            result2 = isUniqueSymbol || this.parseSingleOrPrimitiveType();
        }
        return result2;
    }

    protected boolean parseTypeOfInnerExpression() {
        if (!((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void parseImportTypeInner() {
        PsiBuilder.Marker expr = this.builder.mark();
        PsiBuilder.Marker call = this.builder.mark();
        ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseImportCall(call);
        if (!((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeNameRest(false, expr)) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
    }

    protected boolean parseArrayTypeSuffix(@NotNull PsiBuilder.Marker typeMarker) {
        if (typeMarker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(0);
        }
        return this.parseArrayTypeSuffix(typeMarker, null);
    }

    protected boolean parseArrayTypeSuffix(@NotNull PsiBuilder.Marker typeMarker, @Nullable PsiBuilder.Marker attributeListMarker) {
        if (typeMarker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(1);
        }
        boolean result2 = true;
        while (this.canContinueParsingArray()) {
            this.builder.advanceLexer();
            if (this.isStartOfType()) {
                this.parseType();
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                    result2 = false;
                    break;
                }
                this.builder.advanceLexer();
                typeMarker.done((IElementType)TypeScriptElementTypes.INDEXED_ACCESS_TYPE);
                typeMarker = typeMarker.precede();
                continue;
            }
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                result2 = false;
                break;
            }
            this.builder.advanceLexer();
            if (attributeListMarker != null && !this.canContinueParsingArray()) {
                typeMarker.drop();
                attributeListMarker.precede().done((IElementType)TypeScriptElementTypes.ARRAY_TYPE);
                return true;
            }
            typeMarker.done((IElementType)TypeScriptElementTypes.ARRAY_TYPE);
            typeMarker = typeMarker.precede();
        }
        typeMarker.drop();
        return result2;
    }

    private boolean canContinueParsingArray() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder);
    }

    private void parseSingleTokenLiteralType(@NotNull JSStubElementType literalType) {
        if (literalType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(2);
        }
        PsiBuilder.Marker typeMarker = this.builder.mark();
        PsiBuilder.Marker expressionMarker = this.builder.mark();
        this.builder.advanceLexer();
        expressionMarker.done(JSStubElementTypes.LITERAL_EXPRESSION);
        typeMarker.done((IElementType)literalType);
    }

    private boolean parseSingleOrPrimitiveType() {
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done((IElementType)TypeScriptElementTypes.SINGLE_TYPE);
            return true;
        }
        return this.parserSingleType();
    }

    protected boolean parserSingleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
        marker.done((IElementType)TypeScriptElementTypes.SINGLE_TYPE);
        return result2;
    }

    private boolean parseTypePredicate(PsiBuilder.Marker marker) {
        this.builder.advanceLexer();
        boolean result2 = this.parseType();
        marker.done((IElementType)TypeScriptElementTypes.TYPE_PREDICATE);
        return result2;
    }

    protected boolean isFunctionTypeExpected() {
        return this.isFunctionTypeExpected(0);
    }

    private boolean isFunctionTypeExpected(int startIndex) {
        IElementType elementTypeAfterRPar;
        IElementType elementTypeAfterLPar = this.builder.lookAhead(startIndex + 1);
        if (elementTypeAfterLPar == null || elementTypeAfterLPar == JSTokenTypes.RPAR) {
            return true;
        }
        if (elementTypeAfterLPar == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        if (FunctionParser.willParseDestructuringAssignment(elementTypeAfterLPar) && JSArrowFunctionDetector.INSTANCE.isArrowFunctionType(this.builder, (FunctionParser<?>)((ES6Parser)this.myJavaScriptParser).getFunctionParser())) {
            return true;
        }
        if (elementTypeAfterLPar != JSTokenTypes.THIS_KEYWORD && !this.isIdentifierToken(elementTypeAfterLPar)) {
            return false;
        }
        IElementType elementTypeAfterIdentifier = this.builder.lookAhead(startIndex + 2);
        if (elementTypeAfterIdentifier == JSTokenTypes.COMMA || elementTypeAfterIdentifier == JSTokenTypes.COLON || elementTypeAfterIdentifier == JSTokenTypes.QUEST) {
            return true;
        }
        return elementTypeAfterIdentifier == JSTokenTypes.RPAR && (elementTypeAfterRPar = this.builder.lookAhead(startIndex + 3)) == JSTokenTypes.EQGT;
    }

    private boolean parseFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean result2 = this.parseFunctionParameterList();
        result2 = this.parseFunctionReturnType(marker, result2);
        return result2;
    }

    protected boolean parseFunctionReturnType(PsiBuilder.Marker marker, boolean result2) {
        result2 &= TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        marker.done((IElementType)TypeScriptElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseType();
    }

    private boolean parseTupleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = this.doParseTupleType();
        marker.done((IElementType)TypeScriptElementTypes.TUPLE_TYPE);
        return result2;
    }

    private boolean doParseTupleType() {
        boolean result2 = true;
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.tuple.comma.or.rbracket")) {
                result2 = false;
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(this.getTypeNameExpectedMessage());
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) break;
            PsiBuilder.Marker mark = null;
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                mark = this.builder.mark();
                this.builder.advanceLexer();
            }
            if (!this.parseType()) {
                result2 = false;
                if (mark == null) break;
                mark.drop();
                break;
            }
            if (mark != null) {
                mark.done((IElementType)TypeScriptElementTypes.SPREAD_TYPE);
            } else if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
            commaExpected = true;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            result2 = false;
        }
        return result2;
    }

    public boolean parseObjectType() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            return false;
        }
        return this.parseObjectType(JSTokenTypes.RBRACE, "javascript.parser.message.missing.rbrace");
    }

    public boolean parseMappedType() {
        PsiBuilder.Marker mark = this.builder.mark();
        boolean result2 = this.parseMappedTypeNoMarker();
        mark.done((IElementType)TypeScriptElementTypes.MAPPED_TYPE);
        return result2;
    }

    protected boolean isStartOfMappedType() {
        IElementType nextToken;
        int startCheckIndex = 1;
        IElementType type = this.builder.lookAhead(1);
        if (type == JSTokenTypes.PLUS || type == JSTokenTypes.MINUS) {
            type = this.builder.lookAhead(2);
            ++startCheckIndex;
        }
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            ++startCheckIndex;
        }
        if ((nextToken = this.builder.lookAhead(startCheckIndex)) == null) {
            return false;
        }
        if (nextToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType afterNext = this.builder.lookAhead(startCheckIndex + 1);
        if (!this.isIdentifierToken(afterNext)) {
            return false;
        }
        return this.builder.lookAhead(startCheckIndex + 2) == JSTokenTypes.IN_KEYWORD;
    }

    protected boolean parseMappedTypeNoMarker() {
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        boolean mustHaveReadonly = false;
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveReadonly = true;
        }
        if (!mustHaveReadonly && this.builder.getTokenType() == JSTokenTypes.READONLY_KEYWORD) {
            this.builder.advanceLexer();
        }
        if (mustHaveReadonly && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.READONLY_KEYWORD, "javascript.parser.message.expected.readonly")) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACKET, "javascript.parser.message.expected.lbracket")) {
            return false;
        }
        if (!this.parseMappedTypeParameter()) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            return false;
        }
        boolean mustHaveQuestion = false;
        tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveQuestion = true;
        }
        if (!mustHaveQuestion && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (mustHaveQuestion && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.QUEST, "javascript.parser.message.expected.question")) {
            return false;
        }
        this.tryParseType();
        ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).forceCheckForSemicolon();
        return TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
    }

    protected boolean parseMappedTypeParameter() {
        PsiBuilder.Marker parameter = this.builder.mark();
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            parameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.IN_KEYWORD, "javascript.parser.message.expected.in")) {
            parameter.drop();
            return false;
        }
        boolean result2 = this.parseType();
        parameter.done((IElementType)TypeScriptElementTypes.MAPPED_TYPE_PARAMETER);
        return result2;
    }

    protected final boolean parseObjectType(@NotNull IElementType rBraceType, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String missingRBraceMessageKey) {
        if (rBraceType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = true;
        while (this.builder.getTokenType() != rBraceType) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptBundle.message((String)missingRBraceMessageKey, (Object[])new Object[0]));
                marker.done((IElementType)TypeScriptElementTypes.OBJECT_TYPE);
                return false;
            }
            result2 &= this.parseTypeMember();
        }
        this.builder.advanceLexer();
        marker.done((IElementType)TypeScriptElementTypes.OBJECT_TYPE);
        return result2;
    }

    protected boolean parseTypeMember() {
        PsiBuilder.Marker typeMember = this.builder.mark();
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return this.parseTypeMember(typeMember);
    }

    protected final boolean parseTypeMember(@NotNull PsiBuilder.Marker typeMember) {
        boolean result2;
        IElementType firstToken;
        if (typeMember == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(4);
        }
        if (this.isFunctionHeaderStart(firstToken = this.builder.getTokenType()) || firstToken == JSTokenTypes.NEW_KEYWORD && this.isFunctionHeaderStart(this.builder.lookAhead(1))) {
            result2 = this.parseFunctionHeaderNoMarker(typeMember, (IElementType)JSStubElementTypes.CALL_SIGNATURE);
        } else if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).advancePropertyName(firstToken);
            result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            if (this.isIndexSignatureProperty()) {
                result2 = this.parseIndexSignatureNoMarker(typeMember, false);
            } else {
                ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
                result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
            }
        } else {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type.member", (Object[])new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result2 = false;
        }
        this.forceCheckForSemicolonOrComma();
        return result2;
    }

    protected boolean isFunctionHeaderStart(IElementType token) {
        return token == JSTokenTypes.LPAR || token == JSTokenTypes.LT;
    }

    protected void forceCheckForSemicolonOrComma() {
        boolean checkForComma;
        boolean checkForSemicolon = ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        if (!(checkForSemicolon || (checkForComma = this.checkForComma()) || TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder))) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]));
        }
    }

    private boolean checkForComma() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public boolean parseInterfaceSimplePropertyOrFunction(PsiBuilder.Marker typeMember) {
        if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (this.isFunctionHeaderStart(this.builder.getTokenType())) {
            this.parseFunctionHeaderNoMarker(typeMember, this.getFunctionSignatureElementType());
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.tryParseType();
            }
            typeMember.done((IElementType)TypeScriptElementTypes.PROPERTY_SIGNATURE);
            typeMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        return true;
    }

    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        JSStubElementType<TypeScriptFunctionSignatureStub, TypeScriptFunctionSignature> jSStubElementType = JSStubElementTypes.FUNCTION_SIGNATURE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(5);
        }
        return jSStubElementType;
    }

    public boolean isIndexSignatureProperty() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType secondToken = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(secondToken)) {
            return false;
        }
        IElementType thirdToken = this.builder.lookAhead(2);
        return thirdToken == JSTokenTypes.COLON;
    }

    private boolean parseFunctionHeaderNoMarker(PsiBuilder.Marker marker, IElementType elementType) {
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        assert (this.isFunctionHeaderStart(this.builder.getTokenType()));
        boolean result2 = this.parseFunctionParameterList();
        boolean bl = this.builder.getTokenType() != JSTokenTypes.COLON || this.tryParseType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2 &= bl;
    }

    protected boolean parseFunctionParameterList() {
        return !((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList((boolean)false).hasErrors;
    }

    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, PsiBuilder builder, ES6Parser parser, boolean checkSemicolon, boolean requireVarName) {
        boolean result2;
        boolean hasColon;
        assert (builder.getTokenType() == JSTokenTypes.LBRACKET);
        builder.advanceLexer();
        boolean bl = hasColon = builder.lookAhead(1) == JSTokenTypes.COLON;
        if (hasColon && requireVarName && !parser.isIdentifierToken(builder.getTokenType())) {
            builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            marker.drop();
            return false;
        }
        String data = (String)builder.getUserData(FunctionParser.methodsEmptinessKey);
        try {
            builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)(hasColon ? "p" : "a"));
            result2 = ((FunctionParser)parser.getFunctionParser()).parseSingleParameter(builder.mark());
        }
        finally {
            builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)data);
        }
        if (builder.getTokenType() != JSTokenTypes.RBRACKET) {
            builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
            marker.done((IElementType)TypeScriptElementTypes.INDEX_SIGNATURE);
            marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return result2;
        }
        builder.advanceLexer();
        result2 &= builder.getTokenType() != JSTokenTypes.COLON || ((JSPsiTypeParser)parser.getTypeParser()).tryParseType();
        if (checkSemicolon) {
            ((StatementParser)parser.getStatementParser()).forceCheckForSemicolon();
        }
        marker.done((IElementType)TypeScriptElementTypes.INDEX_SIGNATURE);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2;
    }

    protected boolean isStartOfType() {
        return this.isStartOfType(this.builder.getTokenType(), 0);
    }

    protected boolean isStartOfType(IElementType type, int startIndex) {
        if (type == null) {
            return false;
        }
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || JSKeywordSets.PRIMITIVE_TYPES.contains(type) || JSTokenTypes.THIS_KEYWORD == type || JSTokenTypes.TYPEOF_KEYWORD == type || JSTokenTypes.NEW_KEYWORD == type || JSTokenTypes.STRING_LITERAL == type || JSTokenTypes.NUMERIC_LITERAL == type || JSTokenTypes.TRUE_KEYWORD == type || JSTokenTypes.FALSE_KEYWORD == type || JSTokenTypes.LBRACE == type || JSTokenTypes.LBRACKET == type || JSTokenTypes.LT == type) {
            return true;
        }
        if (JSTokenTypes.MINUS == type && this.builder.lookAhead(startIndex + 1) == JSTokenTypes.NUMERIC_LITERAL) {
            return true;
        }
        if (type == JSTokenTypes.LPAR) {
            if (this.isFunctionTypeExpected(startIndex)) {
                return true;
            }
            IElementType lookAheadElement = this.builder.lookAhead(startIndex + 1);
            if (lookAheadElement == JSTokenTypes.RPAR) {
                return true;
            }
            return this.isStartOfType(lookAheadElement, startIndex + 1);
        }
        return this.isIdentifierToken(type);
    }

    @Override
    public boolean tryParseTypeParameterList() {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            PsiBuilder.Marker typeParameterList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                    typeParameterList.drop();
                    return false;
                }
                if (!first && this.builder.getTokenType() == JSTokenTypes.GT) break;
                boolean typeParameterParsed = this.parseTypeParameter();
                result2 &= typeParameterParsed;
                if (!typeParameterParsed) {
                    this.builder.advanceLexer();
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeParameterList.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    protected boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            return false;
        }
        PsiBuilder.Marker typeParameter = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.builder.advanceLexer();
            PsiBuilder.Marker constraint = this.builder.mark();
            this.parseType();
            constraint.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            PsiBuilder.Marker defaultType = this.builder.mark();
            this.parseType();
            defaultType.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_DEFAULT);
        }
        typeParameter.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    public boolean parseOptionalTypeArgumentList() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            IElementType tokenType;
            PsiBuilder.Marker marker = this.builder.mark();
            if (((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(true) && this.isAcceptableTokenTypeAfterTypeArguments(tokenType = this.builder.getTokenType())) {
                marker.drop();
                return true;
            }
            marker.rollbackTo();
        }
        return false;
    }

    protected boolean isAcceptableTokenTypeAfterTypeArguments(IElementType tokenType) {
        return tokenType == null || tokenType == JSTokenTypes.LPAR || tokenType == JSTokenTypes.BACKQUOTE || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.COLON || tokenType == JSTokenTypes.QUEST || tokenType == JSTokenTypes.EQEQ || tokenType == JSTokenTypes.EQEQEQ || tokenType == JSTokenTypes.NE || tokenType == JSTokenTypes.NEQEQ || tokenType == JSTokenTypes.ANDAND || tokenType == JSTokenTypes.AND || tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.OROR || tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.XOR || tokenType == JSTokenTypes.RBRACE;
    }

    @Override
    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine) {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT && (allowNewLine || !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder))) {
            PsiBuilder.Marker typeArgumentList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first) {
                    if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                        if (revert) {
                            typeArgumentList.rollbackTo();
                        } else {
                            typeArgumentList.drop();
                        }
                        return false;
                    }
                    if (this.builder.getTokenType() == JSTokenTypes.GT) {
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type", (Object[])new Object[0]));
                        break;
                    }
                }
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    if (first) {
                        first = false;
                    }
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.type", (Object[])new Object[0]));
                    continue;
                }
                if (!(result2 &= this.parseTypeInGenericArgument()) && revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                first = false;
            }
            if (this.builder.getTokenType() != JSTokenTypes.GT) {
                if (revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.gt", (Object[])new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
            typeArgumentList.done((IElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
        }
        return result2;
    }

    public boolean parseTypeInGenericArgument() {
        PsiBuilder.Marker outer = null;
        if (this.isIdentifierToken(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.EQ) {
            outer = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
        }
        boolean result2 = ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).parseType();
        if (outer != null) {
            outer.done(TypeScriptElementTypes.NAMED_GENERIC_ARGUMENT_TYPE);
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.equal", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JavaScriptBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMarker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureElementType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayTypeSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleTokenLiteralType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseObjectType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeMember";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

