/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptQuickNavigateBuilder
extends JSQuickNavigateBuilder {
    @Override
    @Nullable
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (element instanceof TypeScriptModule) {
            String prefix = ((TypeScriptModule)element).isInternal() ? "namespace " : "module ";
            return this.createQuickNavigateForJSElement((JSElement)((TypeScriptModule)element), originalElement, prefix, JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION, jsDoc);
        }
        if (element instanceof ES6ImportExportDeclarationPart) {
            ES6ImportExportDeclarationPart part = (ES6ImportExportDeclarationPart)element;
            JSQuickNavigateBuilder.ObjectKind kind = this.getKindForImport(part);
            return this.createQuickNavigateForJSElement((JSElement)part, originalElement, jsDoc ? kind.toJSDocPrefix() : "", kind, jsDoc);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement, jsDoc);
    }

    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getKindForImport(@NotNull ES6ImportExportDeclarationPart part) {
        if (part == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (part instanceof ES6ImportSpecifier) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.IMPORT_SPECIFIER;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
            }
            return objectKind;
        }
        if (part instanceof ES6ImportedBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = ((ES6ImportedBinding)part).isNamespaceImport() ? JSQuickNavigateBuilder.ObjectKind.IMPORT_ALL : JSQuickNavigateBuilder.ObjectKind.IMPORT_DEFAULT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        if (part instanceof ES6ExportSpecifier || part instanceof ES6ExportedDefaultBinding) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.EXPORT;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Override
    @Nullable
    protected String getPresentableTypeText(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor, boolean jsDoc, @Nullable PsiElement context) {
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSArrayType.GenericArrayBuilder.asArrayIfGenericType(JSCompositeTypeImpl.optimizeTypeIfComposite(el))));
        return super.getPresentableTypeText(rawType, substitutor, jsDoc, context);
    }

    @Override
    @NotNull
    protected JSQuickNavigateBuilder.ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (variableOrField instanceof JSField || variableOrField instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)variableOrField)) {
            JSQuickNavigateBuilder.ObjectKind objectKind = JSQuickNavigateBuilder.ObjectKind.PROPERTY;
            if (objectKind == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
            }
            return objectKind;
        }
        JSQuickNavigateBuilder.ObjectKind objectKind = super.getFieldOrVariableKind(variableOrField);
        if (objectKind == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        return objectKind;
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement candidate, @NotNull PsiElement originalElement) {
        if (candidate == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement);
        boolean isSourceElement = JavaScriptQuickNavigateBuilder.isElementFromTSSources(candidate, originalElement);
        JSElement typeSubstitutorTarget = candidate;
        if (isSourceElement) {
            typeSubstitutorTarget = JavaScriptQuickNavigateBuilder.getOriginalResolvedElement(candidate, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor substitutorForMember = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(typeSubstitutorTarget, originalElement);
        Object object = isSourceElement ? new JSTypeSubstitutor.StringTypeSubstitutor(substitutorForMember) : substitutorForMember;
        if (object == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        return object;
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        ResolveResult[] results;
        List<PsiElement> resolvedElements;
        if (member == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if ((resolvedElements = JSResolveResult.toElements(results = originalElement.multiResolve(false))).size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        return jSElement;
    }

    @Nullable
    protected static String getGenerics(@NotNull JSElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return null;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)element;
        TypeScriptTypeParameterList list2 = owner.getTypeParameterList();
        if (list2 == null) {
            return null;
        }
        Object[] parameters = list2.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            JSTypeSubstitutor.JSTypeGenericId id;
            JSType type;
            String name = el.getName();
            if (name == null) {
                name = "?";
            }
            return (type = substitutor.get(id = el.getGenericId())) == null ? name : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return newBuilder.toString();
    }

    @Override
    protected void appendClassAttributes(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        boolean isAlias = jsClass instanceof TypeScriptTypeAlias;
        boolean isEnum = jsClass instanceof TypeScriptEnum;
        if (isAlias || isEnum) {
            this.appendAttrList((JSAttributeListOwner)jsClass, result2);
            result2.append(isAlias ? "type " : "enum ");
        } else {
            super.appendClassAttributes(jsClass, originalElement, packageOrModule, result2);
        }
    }

    private void appendGenerics(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @NotNull StringBuilder result2) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = JavaScriptQuickNavigateBuilder.getGenerics((JSElement)jsClass, substitutor = this.getTypeSubstitutor((JSElement)jsClass, originalElement))) != null) {
            result2.append(generics);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        if (packageNameOrEmptyString == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (result2 == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        this.appendGenerics(jsClass, originalElement, result2);
        super.appendClassExtendsAndImplements(jsClass, originalElement, packageNameOrEmptyString, result2);
    }

    @Override
    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        if (variable == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (variable instanceof JSField || variable instanceof JSParameter) {
            return "";
        }
        String string = super.getVarPrefix(variable);
        if (string == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (element == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            parent = JSUtils.getMemberContainingClass((PsiElement)element);
        }
        if (parent instanceof TypeScriptInterfaceClass && (generics = JavaScriptQuickNavigateBuilder.getGenerics((JSElement)((TypeScriptTypeParameterListOwner)parent), substitutor)) != null) {
            String className2 = StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
            return className2 + StringUtil.escapeXmlEntities((String)generics);
        }
        if (parent instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            return ((TypeScriptModule)parent).getQualifiedName();
        }
        return super.getParentInfo(parent, element, substitutor);
    }

    @Override
    @Nullable
    protected String formatVisibility(@NotNull JSAttributeListOwner owner, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.AccessType type) {
        if (owner == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (attributeList == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if (type == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if (type == JSAttributeList.AccessType.PUBLIC && attributeList.getExplicitAccessType() == null) {
            return null;
        }
        if (type == JSAttributeList.AccessType.PRIVATE && attributeList.hasPrivateSharp()) {
            return null;
        }
        return super.formatVisibility(owner, attributeList, type);
    }

    @Override
    @Nullable
    protected JSType getNarrowedType(@NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        JSType narrowType;
        if (originalElement == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        if (substitutor == null) {
            JavaScriptQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if ((originalElement = JavaScriptQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement)) instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference((JSExpression)originalElement) && (narrowType = JSResolveUtil.getExpressionJSType((JSExpression)originalElement)) != null && (narrowType.isTypeScript() || !(narrowType instanceof JSRecordType))) {
            return this.getTypeWithAppliedSubstitutor(narrowType, substitutor);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 17: 
            case 23: 
            case 26: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 7: 
            case 21: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JavaScriptQuickNavigateBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindForImport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalResolvedElement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKindForImport";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 33: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromTSSources";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalResolvedElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getGenerics";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributes";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendGenerics";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

