/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.markdown4j.Markdown4jProcessor;

public class JSMarkdownUtil {
    private static final Logger LOG = Logger.getInstance(JSMarkdownUtil.class);
    private static final Pattern TAG_START_OR_CLOSE_PATTERN = Pattern.compile("(<)/?(\\w+)[> ]");
    private static final Pattern SPLIT_BY_LINE_PATTERN = Pattern.compile("\n|\r|\r\n");
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS = new HashMap<String, String>();
    public static final String BR_TAG_AFTER_MARKDOWN_PROCESSING = "<br  />";
    private static final Set<String> ACCEPTABLE_TAGS;

    private JSMarkdownUtil() {
    }

    @Nullable
    public static String toHtml(@NotNull String markdownText) {
        if (markdownText == null) {
            JSMarkdownUtil.$$$reportNull$$$0(0);
        }
        return JSMarkdownUtil.toHtml(markdownText, true);
    }

    @NotNull
    private static String getBorder() {
        String string = "margin: 0; border: 1px solid; border-color: #" + ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor()) + "; border-spacing: 0; border-collapse: collapse;vertical-align: baseline;";
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String toHtml(@NotNull String markdownText, boolean convertTagCodeBlocks) {
        if (markdownText == null) {
            JSMarkdownUtil.$$$reportNull$$$0(2);
        }
        String[] lines = SPLIT_BY_LINE_PATTERN.split(markdownText);
        ArrayList<String> processedLines = new ArrayList<String>(lines.length);
        boolean isInCode = false;
        boolean isInTable = false;
        List<String> tableFormats = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String processedLine = StringUtil.trimTrailing((String)line);
            int count = StringUtil.getOccurrenceCount((String)(processedLine = StringUtil.trimStart((String)processedLine, (String)" ")), (String)FENCED_CODE_BLOCK);
            if (count > 0) {
                isInCode = count % 2 == 0 ? isInCode : !isInCode;
            } else if (convertTagCodeBlocks) {
                if (isInCode) {
                    if (processedLine.startsWith(HTML_CODE_END)) {
                        processedLines.add(FENCED_CODE_BLOCK);
                        processedLine = StringUtil.trimStart((String)processedLine, (String)HTML_CODE_END);
                        isInCode = false;
                    }
                } else {
                    boolean codeStart = false;
                    if (processedLine.endsWith(HTML_CODE_START)) {
                        codeStart = true;
                        processedLine = StringUtil.trimEnd((String)processedLine, (String)HTML_CODE_START);
                    }
                    processedLine = processedLine.replace("<pre>", FENCED_CODE_BLOCK).replace("</pre>", FENCED_CODE_BLOCK).replace(HTML_CODE_START, INLINE_CODE_BLOCK).replace(HTML_CODE_END, INLINE_CODE_BLOCK);
                    if (codeStart) {
                        processedLines.add(processedLine);
                        processedLine = FENCED_CODE_BLOCK;
                        isInCode = true;
                    }
                }
            } else {
                int tableDelimiterIndex = processedLine.indexOf(124);
                if (tableDelimiterIndex != -1) {
                    if (!isInTable && i + 1 < lines.length) {
                        tableFormats = JSMarkdownUtil.parseTableFormats(JSMarkdownUtil.splitTableCols(lines[i + 1]));
                    }
                    if (!ContainerUtil.isEmpty(tableFormats)) {
                        List<String> parts = JSMarkdownUtil.splitTableCols(processedLine);
                        if (JSMarkdownUtil.isTableHeaderSeparator(parts)) continue;
                        processedLine = JSMarkdownUtil.getProcessedRow(isInTable, parts, tableFormats);
                        if (!isInTable) {
                            processedLine = "<table style=\"border: 0px;\" cellspacing=\"0\">" + processedLine;
                        }
                        isInTable = true;
                    }
                } else {
                    if (isInTable) {
                        processedLine = processedLine + "</table>";
                    }
                    isInTable = false;
                    tableFormats = null;
                }
                List<TextRange> ranges = JSMarkdownUtil.getInlineCodeBlocks(processedLine);
                processedLine = isInCode ? processedLine : JSMarkdownUtil.replaceProhibitedTags(StringUtil.trimLeading((String)processedLine), ranges);
            }
            processedLines.add(processedLine);
        }
        String normalizedMarkdown = StringUtil.join(processedLines, (String)"\n");
        if (isInTable) {
            normalizedMarkdown = normalizedMarkdown + "</table>";
        }
        String html = JSMarkdownUtil.convert(normalizedMarkdown);
        return JSMarkdownUtil.adjustHtml(html);
    }

    @Nullable
    private static List<String> parseTableFormats(@NotNull List<String> cols) {
        if (cols == null) {
            JSMarkdownUtil.$$$reportNull$$$0(3);
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String col : cols) {
            if (!JSMarkdownUtil.isHeaderSeparator(col)) {
                return null;
            }
            formats.add(JSMarkdownUtil.parseFormat(col.trim()));
        }
        return formats;
    }

    private static boolean isTableHeaderSeparator(@NotNull List<String> parts) {
        if (parts == null) {
            JSMarkdownUtil.$$$reportNull$$$0(4);
        }
        return parts.stream().allMatch(JSMarkdownUtil::isHeaderSeparator);
    }

    private static boolean isHeaderSeparator(@NotNull String s) {
        if (s == null) {
            JSMarkdownUtil.$$$reportNull$$$0(5);
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)s.trim(), (String)":"), (String)":").chars().allMatch(sx -> sx == 45);
    }

    @NotNull
    private static List<String> splitTableCols(@NotNull String processedLine) {
        ArrayList<String> parts;
        if (processedLine == null) {
            JSMarkdownUtil.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)((String)(parts = new ArrayList<String>(StringUtil.split((String)processedLine, (String)"|"))).get(0)))) {
            parts.remove(0);
        }
        if (!parts.isEmpty() && StringUtil.isEmptyOrSpaces((String)((String)parts.get(parts.size() - 1)))) {
            parts.remove(parts.size() - 1);
        }
        ArrayList<String> arrayList = parts;
        if (arrayList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static String getProcessedRow(boolean isInTable, @NotNull List<String> parts, @Nullable List<String> tableFormats) {
        if (parts == null) {
            JSMarkdownUtil.$$$reportNull$$$0(8);
        }
        String openingTagStart = isInTable ? "<td style=\"" + JSMarkdownUtil.getBorder() + "\" " : "<th style=\"" + JSMarkdownUtil.getBorder() + "\" ";
        String closingTag = isInTable ? "</td>" : "</th>";
        StringBuilder resultBuilder = new StringBuilder("<tr style=\"" + JSMarkdownUtil.getBorder() + "\">" + openingTagStart);
        resultBuilder.append("align=\"").append(JSMarkdownUtil.getAlign(0, tableFormats)).append("\">");
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                resultBuilder.append(closingTag).append(openingTagStart).append("align=\"").append(JSMarkdownUtil.getAlign(i, tableFormats)).append("\">");
            }
            resultBuilder.append(JSMarkdownUtil.convert(parts.get(i).trim()));
        }
        resultBuilder.append(closingTag).append("</tr>");
        String string = resultBuilder.toString();
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getAlign(int index, @Nullable List<String> formats) {
        String string = formats == null || index >= formats.size() ? "left" : formats.get(index);
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String parseFormat(@NotNull String format) {
        if (format == null) {
            JSMarkdownUtil.$$$reportNull$$$0(11);
        }
        if (format.length() <= 1) {
            return "left";
        }
        char c0 = format.charAt(0);
        char cE = format.charAt(format.length() - 1);
        return c0 == ':' && cE == ':' ? "center" : (cE == ':' ? "right" : "left");
    }

    @NotNull
    private static List<TextRange> getInlineCodeBlocks(@NotNull String processingLine) {
        int startQuote;
        if (processingLine == null) {
            JSMarkdownUtil.$$$reportNull$$$0(12);
        }
        int next = 0;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int length = processingLine.length();
        while (next >= 0 && next < length && (startQuote = processingLine.indexOf(96, next)) >= 0 && length > startQuote + 1) {
            int endQuote;
            int offset;
            char nextChar = processingLine.charAt(startQuote + 1);
            int n = offset = nextChar == '`' ? 2 : 1;
            if (length <= startQuote + offset || (endQuote = processingLine.indexOf(96, startQuote + offset)) <= 0) break;
            ranges.add(new TextRange(startQuote, endQuote));
            next = endQuote + offset;
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static String convert(@NotNull String text) {
        if (text == null) {
            JSMarkdownUtil.$$$reportNull$$$0(14);
        }
        try {
            return new Markdown4jProcessor().process(text);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String replaceProhibitedTags(@NotNull String line) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(15);
        }
        return JSMarkdownUtil.replaceProhibitedTags(line, ContainerUtil.emptyList());
    }

    @NotNull
    private static String replaceProhibitedTags(@NotNull String line, @NotNull List<TextRange> skipRanges) {
        TIntArrayList list2;
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(16);
        }
        if (skipRanges == null) {
            JSMarkdownUtil.$$$reportNull$$$0(17);
        }
        if ((list2 = JSMarkdownUtil.collectProhibitedTagOffsets(line, skipRanges)).isEmpty()) {
            String string = line;
            if (string == null) {
                JSMarkdownUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        return JSMarkdownUtil.escapeTagsStart(line, list2);
    }

    @NotNull
    private static String escapeTagsStart(@NotNull String line, @NotNull TIntArrayList orderedOffsetList) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(19);
        }
        if (orderedOffsetList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(20);
        }
        StringBuilder builder = new StringBuilder(line);
        orderedOffsetList.forEachDescending(el -> {
            builder.replace(el, el + 1, "&lt;");
            return true;
        });
        String string = builder.toString();
        if (string == null) {
            JSMarkdownUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static TIntArrayList collectProhibitedTagOffsets(@NotNull String line, @NotNull List<TextRange> skipRanges) {
        if (line == null) {
            JSMarkdownUtil.$$$reportNull$$$0(22);
        }
        if (skipRanges == null) {
            JSMarkdownUtil.$$$reportNull$$$0(23);
        }
        Matcher matcher = TAG_START_OR_CLOSE_PATTERN.matcher(line);
        TIntArrayList list2 = new TIntArrayList();
        block0: while (matcher.find()) {
            String tagName = matcher.group(2);
            if (ACCEPTABLE_TAGS.contains(StringUtil.toLowerCase((String)tagName))) continue;
            int startOfTag = matcher.start(2);
            for (TextRange range : skipRanges) {
                if (!range.contains(startOfTag)) continue;
                continue block0;
            }
            list2.add(matcher.start(1));
        }
        TIntArrayList tIntArrayList = list2;
        if (tIntArrayList == null) {
            JSMarkdownUtil.$$$reportNull$$$0(24);
        }
        return tIntArrayList;
    }

    @Nullable
    public static String adjustHtml(@Nullable String html) {
        if (html == null) {
            return null;
        }
        String str = html;
        for (Map.Entry<String, String> entry : HTML_DOC_SUBSTITUTIONS.entrySet()) {
            str = str.replace(entry.getKey(), entry.getValue());
        }
        str = str.replace(BR_TAG_AFTER_MARKDOWN_PROCESSING, "");
        return str.trim();
    }

    static {
        HTML_DOC_SUBSTITUTIONS.put("<pre><code>", "<pre>");
        HTML_DOC_SUBSTITUTIONS.put("</code></pre>", "</pre>");
        HTML_DOC_SUBSTITUTIONS.put("<em>", "<i>");
        HTML_DOC_SUBSTITUTIONS.put("</em>", "</i>");
        HTML_DOC_SUBSTITUTIONS.put("<strong>", "<b>");
        HTML_DOC_SUBSTITUTIONS.put("</strong>", "</b>");
        HTML_DOC_SUBSTITUTIONS.put(": //", "://");
        ACCEPTABLE_TAGS = ContainerUtil.immutableSet((Object[])new String[]{"p", "i", "code", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "li", "blockquote", "ol", "b", "a", "tt", "tt", "pre", "tr", "th", "td", "table", "strong", "em", "u", "dl", "dd", "dt"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownText";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSMarkdownUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cols";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipRanges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedOffsetList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSMarkdownUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTableCols";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedRow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlign";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineCodeBlocks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceProhibitedTags";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTagsStart";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProhibitedTagOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTableFormats";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTableHeaderSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitTableCols";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedRow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseFormat";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInlineCodeBlocks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceProhibitedTags";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "escapeTagsStart";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectProhibitedTagOffsets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

