/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocBuilderMethodInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSExampleDocBuilderInfo;
import com.intellij.lang.javascript.documentation.JSPreDocBuilderInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationBuilder
implements JSDocumentationProcessor {
    private static final Map<JSDocumentationProcessor.MetaDocType, String> SIMPLE_TAGS = new EnumMap<JSDocumentationProcessor.MetaDocType, String>(JSDocumentationProcessor.MetaDocType.class);
    @NotNull
    private final JSDocBuilderSymbolInfo myTargetInfo;
    @Nullable
    private final JSFunctionItem function;
    @Nullable
    private final JSPsiElementBase namedItem;
    @NotNull
    private final PsiElement myElement;
    private JSDocBuilderParameterInfo currentParameterInfo;
    @NotNull
    private JSDocBuilderSimpleInfo myInfoForNewLines;
    private int myNewLinesPendingCount;
    @Nullable
    private JSPreDocBuilderInfo myPreInfo;
    private String seenPre;
    private boolean seenInheritDoc;
    private final JSDocumentationProvider myProvider;
    private boolean myPropertyMatched;
    private static final Pattern ourBrTagPattern;
    private final JSDocBuilderParameterInfo NULL_PARAMETER_INFO;

    protected JSDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, JSDocumentationProvider provider) {
        if (element == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(0);
        }
        this(element, _contextElement, null, provider);
    }

    protected JSDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, @Nullable PsiComment comment, JSDocumentationProvider provider) {
        JSExpression initializer;
        if (element == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(1);
        }
        this.myNewLinesPendingCount = 0;
        this.NULL_PARAMETER_INFO = new JSDocBuilderParameterInfo((PsiElement)null);
        this.myElement = element;
        this.myProvider = provider;
        if (element instanceof JSVariable && (initializer = JSPsiImplUtils.getAssignedExpression(element)) instanceof JSFunctionExpression) {
            element = initializer;
        }
        this.function = JSDocumentationBuilder.findFunction(element, _contextElement, comment);
        this.namedItem = this.function == null && element instanceof JSPsiElementBase ? (JSPsiElementBase)element : null;
        this.myTargetInfo = this.function != null ? new JSDocBuilderMethodInfo(this.function, this.myElement, _contextElement) : new JSDocBuilderSymbolInfo(element, _contextElement, true);
        this.myInfoForNewLines = this.myTargetInfo;
    }

    @Override
    public boolean needsPlainCommentData() {
        return true;
    }

    @Override
    public boolean onCommentLine(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(2);
        }
        String trimmedLine = line.trim();
        boolean parametersStarted = false;
        boolean parametersEnded = false;
        if (this.myTargetInfo instanceof JSDocBuilderMethodInfo) {
            JSDocBuilderMethodInfo methodInfo = (JSDocBuilderMethodInfo)this.myTargetInfo;
            parametersEnded = methodInfo.parameterCount == methodInfo.parameterInfoMap.size() && (this.currentParameterInfo == null || trimmedLine.length() == 0);
            boolean bl = parametersStarted = methodInfo.parameterCount > 0;
            if (parametersEnded) {
                this.currentParameterInfo = null;
            }
        }
        if (trimmedLine.length() == 0 && !(this.myInfoForNewLines instanceof JSExampleDocBuilderInfo)) {
            int maxSubsequentBr;
            if (!this.myInfoForNewLines.hasDescription()) {
                return true;
            }
            int n = maxSubsequentBr = parametersStarted && !parametersEnded ? 0 : 2;
            if (this.myNewLinesPendingCount < maxSubsequentBr) {
                ++this.myNewLinesPendingCount;
            }
            if (parametersEnded && ((JSDocBuilderMethodInfo)this.myTargetInfo).returnInfo != this.myInfoForNewLines) {
                this.updateInfoForNewLines(this.myTargetInfo);
                this.myNewLinesPendingCount = 1;
            }
            return true;
        }
        this.appendPreOrInfoLine(line);
        this.myNewLinesPendingCount = parametersStarted && !parametersEnded ? 0 : 1;
        return true;
    }

    @Nullable
    private static JSFunctionItem findFunction(PsiElement element, PsiElement _contextElement, PsiComment comment) {
        JSFunctionItem result2 = TypeScriptSignatureChooser.resolveAnyFunction(element, _contextElement);
        if (result2 == null && comment instanceof JSDocCommentImpl) {
            JSImplicitElement implicitElement;
            String name = ((JSDocCommentImpl)comment).getExplicitName();
            if (name == null) {
                name = "";
            }
            if ((implicitElement = ((JSDocCommentImpl)comment).buildImplicitElement(name)) instanceof JSFunctionItem) {
                result2 = (JSFunctionItem)implicitElement;
            }
        }
        return result2;
    }

    private void appendPreOrInfoLine(@NotNull String line) {
        int preClose;
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(3);
        }
        int preStart = line.indexOf("<pre>");
        int prePrefix = "<pre>".length();
        int preSuffix = "</pre>".length();
        if (this.seenPre == null && preStart < 0) {
            preStart = line.indexOf("```");
            preSuffix = 3;
            prePrefix = 3;
        }
        if ("```".equals(this.seenPre) || prePrefix == 3) {
            preClose = line.indexOf("```", preStart > 0 ? preStart + 3 : 0);
            preSuffix = 3;
            prePrefix = 3;
        } else {
            preClose = line.lastIndexOf("</pre>");
        }
        if (preStart > 0 && preClose > preStart) {
            preClose = -1;
        }
        boolean needNewLines = true;
        if (preStart >= 0) {
            this.seenPre = line.substring(preStart);
            if (preStart > 0) {
                String infoBeforeLine = JSPreDocBuilderInfo.getTextBeforePre(line, preStart);
                this.myInfoForNewLines.appendNewLines(this.myNewLinesPendingCount);
                this.replaceTagsAndAppendInfoLine(infoBeforeLine);
                needNewLines = false;
            }
            this.myPreInfo = this.myTargetInfo.startPre();
        }
        if (this.seenPre != null) {
            String preBody = JSPreDocBuilderInfo.getPreBody(line, preStart, prePrefix, preClose);
            String string = preBody = "<pre>".equals(this.seenPre) ? preBody.replace("```", "!!!CODE_FENCE!!!") : preBody;
            if (needNewLines) {
                assert (this.myPreInfo != null);
                this.myPreInfo.appendNewLines(this.myNewLinesPendingCount);
            }
            this.replaceNewLinesAndAppendPreLine(preBody);
            if (preClose >= 0) {
                String afterText = JSPreDocBuilderInfo.getTextAfterPre(line, preClose, preSuffix);
                if (!StringUtil.isEmpty((String)afterText)) {
                    this.replaceTagsAndAppendInfoLine(afterText);
                }
                this.seenPre = null;
            }
        } else {
            this.myInfoForNewLines.appendNewLines(this.myNewLinesPendingCount);
            this.replaceTagsAndAppendInfoLine(line);
        }
    }

    public void replaceNewLinesAndAppendPreLine(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(4);
        }
        assert (this.myPreInfo != null);
        this.myPreInfo.appendDescription(line);
    }

    public void replaceTagsAndAppendInfoLine(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(5);
        }
        if (line.indexOf(60) != -1) {
            line = JSDocumentationBuilder.replaceBrTagsWithNewLines(line);
        }
        this.myInfoForNewLines.appendDescription(line);
    }

    @NotNull
    private static String replaceBrTagsWithNewLines(@NotNull String line) {
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(6);
        }
        String string = ourBrTagPattern.matcher(line).replaceAll("\n\n");
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void updateInfoForNewLines(@NotNull JSDocBuilderSimpleInfo info) {
        if (info == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(8);
        }
        this.myInfoForNewLines = info;
        this.myNewLinesPendingCount = 0;
    }

    @Override
    public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType metaDocType, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
        Object qualifiedName;
        if (metaDocType == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(9);
        }
        if (line == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(10);
        }
        if (patternMatched == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(11);
        }
        if (!this.isNestedDocType(metaDocType, patternMatched)) {
            if (this.myTargetInfo != this.myInfoForNewLines) {
                this.updateInfoForNewLines(this.myTargetInfo);
            }
            this.currentParameterInfo = null;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEFAULT && remainingLineContent != null) {
            boolean color = remainingLineContent.startsWith("0x") && remainingLineContent.length() == 8;
            String content = remainingLineContent.substring(color ? 2 : 0);
            JSDocBuilderParameterInfo parameterInfo = this.getFieldInfo(matchName);
            if (parameterInfo != null) {
                parameterInfo.initialValue = content;
            } else if (this.currentParameterInfo != null) {
                this.currentParameterInfo.defaultValue = content;
            } else {
                this.myTargetInfo.setDefaultValue(content, color, remainingLineContent);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.SEE) {
            this.myTargetInfo.addSeeAlsoText(remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EVENT) {
            this.myTargetInfo.addEventTag(matchName, remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.EXAMPLE) {
            JSExampleDocBuilderInfo exampleInfo = this.myTargetInfo.startExample(remainingLineContent, this.myElement);
            this.updateInfoForNewLines(exampleInfo);
            return true;
        }
        if (SIMPLE_TAGS.containsKey((Object)metaDocType)) {
            this.myTargetInfo.addSimpleTag(SIMPLE_TAGS.get((Object)metaDocType), remainingLineContent);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS) {
            JSDocBuilderParameterInfo parameterInfo = null;
            if (this.myTargetInfo.myProperties != null && matchName != null) {
                parameterInfo = this.myTargetInfo.myProperties.get(JSQualifiedNameImpl.fromQualifiedName(matchName));
            }
            if (parameterInfo == null) {
                parameterInfo = this.getFieldInfo(matchName);
            }
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            if (parameterInfo != null) {
                parameterInfo.optional = true;
                return true;
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
            this.myTargetInfo.deprecated = true;
            if (remainingLineContent != null) {
                this.onCommentLine(remainingLineContent);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.DESCRIPTION) {
            this.myTargetInfo.appendBlockDescription(remainingLineContent);
            return true;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this.myElement, true);
        if (metaDocType == JSDocumentationProcessor.MetaDocType.PRIVATE || metaDocType == JSDocumentationProcessor.MetaDocType.PUBLIC || metaDocType == JSDocumentationProcessor.MetaDocType.PROTECTED || metaDocType == JSDocumentationProcessor.MetaDocType.STATIC) {
            String s = StringUtil.toLowerCase((String)metaDocType.name());
            this.myTargetInfo.modifiers = this.myTargetInfo.modifiers == null ? s : this.myTargetInfo.modifiers + ", " + s;
            if (matchName != null) {
                this.myTargetInfo.type = JSTypeUtils.createTypeFromJSDoc(matchName, typeSource);
            }
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPE) {
            this.myTargetInfo.type = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FINAL) {
            this.myTargetInfo.finalAccess = "final";
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.REQUIRES) {
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.NAMESPACE) {
            this.myTargetInfo.namespace = matchName;
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.INHERIT_DOC) {
            this.seenInheritDoc = true;
            return true;
        }
        if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD && this.namedItem != null) {
            qualifiedName = this.namedItem.getQualifiedName();
            if (qualifiedName != null && matchName != null && matchName.endsWith((String)qualifiedName) && !StringUtil.isEmpty((String)remainingLineContent)) {
                this.myTargetInfo.appendBlockDescription(remainingLineContent);
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PROPERTY) {
            if (matchName != null) {
                qualifiedName = JSQualifiedNameImpl.fromQualifiedName(matchName);
                if (this.namedItem instanceof JSImplicitElement && StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    this.myTargetInfo.resetDescription();
                    this.myTargetInfo.appendDescription(remainingLineContent);
                    this.myTargetInfo.type = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
                    this.myPropertyMatched = true;
                    this.myTargetInfo.myProperties = null;
                } else if (!this.myPropertyMatched && this.namedItem != null && !StringUtil.equals((CharSequence)this.namedItem.getName(), (CharSequence)((JSQualifiedNameImpl)qualifiedName).getName())) {
                    if (this.myTargetInfo.myProperties == null) {
                        this.myTargetInfo.myProperties = new LinkedHashMap<JSQualifiedName, JSDocBuilderParameterInfo>();
                    }
                    JSDocBuilderParameterInfo property = new JSDocBuilderParameterInfo(this.myElement);
                    if (matchValue != null) {
                        property.type = JSTypeUtils.createTypeFromJSDoc(matchValue, JSTypeSource.EXPLICITLY_DECLARED);
                    }
                    if (((JSQualifiedNameImpl)qualifiedName).getParent() != null) {
                        property.namespace = ((JSQualifiedNameImpl)qualifiedName).getParent().getQualifiedName();
                    }
                    property.appendDescription(remainingLineContent);
                    this.myTargetInfo.myProperties.put((JSQualifiedName)qualifiedName, property);
                    this.updateInfoForNewLines(property);
                }
            }
        } else if (metaDocType == JSDocumentationProcessor.MetaDocType.TYPEDEF) {
            this.myTargetInfo.type = JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource);
        }
        if (this.function != null) {
            JSDocBuilderMethodInfo methodGenerationInfo = (JSDocBuilderMethodInfo)this.myTargetInfo;
            if (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS || metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                String typeString;
                JSDocBuilderSimpleInfo firesOrThrowsInfo = new JSDocBuilderSimpleInfo();
                String string = typeString = metaDocType == JSDocumentationProcessor.MetaDocType.THROWS ? matchValue : matchName;
                if (typeString != null) {
                    if (metaDocType == JSDocumentationProcessor.MetaDocType.FIRES) {
                        firesOrThrowsInfo.hasFiredEvents = true;
                    }
                    firesOrThrowsInfo.type = JSTypeUtils.createTypeFromJSDoc(typeString, typeSource);
                }
                if (remainingLineContent != null) {
                    firesOrThrowsInfo.appendDescription(remainingLineContent);
                }
                (metaDocType == JSDocumentationProcessor.MetaDocType.THROWS ? methodGenerationInfo.throwsInfos : methodGenerationInfo.firesInfos).add(firesOrThrowsInfo);
                this.myInfoForNewLines = firesOrThrowsInfo;
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR || metaDocType == JSDocumentationProcessor.MetaDocType.METHOD) {
                methodGenerationInfo.methodType = StringUtil.toLowerCase((String)metaDocType.name());
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.FIELD) {
                String parameterName;
                JSDocBuilderParameterInfo info;
                if (matchName != null && matchName.indexOf(46) > 0 && (info = methodGenerationInfo.getInfoForParameterName(parameterName = matchName.substring(0, matchName.indexOf(".")), this.function)) != null) {
                    this.currentParameterInfo = info;
                }
                if (this.currentParameterInfo != null) {
                    String fieldName;
                    if (this.currentParameterInfo.optionsMap == null) {
                        this.currentParameterInfo.optionsMap = new LinkedHashMap<String, JSDocBuilderParameterInfo>();
                    }
                    if ((fieldName = JSDocumentationBuilder.getFieldName(matchName)) != null) {
                        JSParameterTypeDecorator parameterType = JSTypeUtils.createParameterType(matchValue, typeSource);
                        JSDocBuilderParameterInfo parameterInfo = new JSDocBuilderParameterInfo((JSParameterItem)parameterType);
                        parameterInfo.appendDescription(remainingLineContent);
                        this.currentParameterInfo.optionsMap.put(fieldName, parameterInfo);
                        this.updateInfoForNewLines(parameterInfo);
                    }
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                JSDocBuilderParameterInfo info = methodGenerationInfo.getInfoForParameterName(matchName, this.function);
                if (info != null) {
                    int index = 0;
                    for (JSDocBuilderParameterInfo _info : methodGenerationInfo.parameterInfoMap.values()) {
                        if (info == _info) break;
                        ++index;
                    }
                    methodGenerationInfo.parameterCount = index + 1;
                } else if (patternMatched.indexOf(64) != -1) {
                    ++methodGenerationInfo.parameterCount;
                    int index = 0;
                    for (JSDocBuilderParameterInfo _info : methodGenerationInfo.parameterInfoMap.values()) {
                        if (index + 1 == methodGenerationInfo.parameterCount) {
                            info = _info;
                            break;
                        }
                        ++index;
                    }
                }
                if (info != null) {
                    info.docName = matchName;
                    info.appendDescription(remainingLineContent);
                    this.currentParameterInfo = info;
                    this.updateInfoForNewLines(info);
                } else {
                    if (this.function.isGetProperty()) {
                        return true;
                    }
                    this.onCommentLine(line);
                }
            } else if (metaDocType == JSDocumentationProcessor.MetaDocType.RETURN) {
                JSType typeFromCommentsFunction;
                DialectOptionHolder holder;
                JSDocBuilderSimpleInfo returnInfo = methodGenerationInfo.returnInfo;
                boolean addReturnTypeInfoFromComments = true;
                if (this.function instanceof JSFunction && (holder = DialectDetector.dialectOfElement((PsiElement)this.function)) != null && (holder.isTypeScript || holder.isECMA4) && (typeFromCommentsFunction = JSPsiImplUtils.getTypeFromDeclaration((JSElement)this.function)) != null && !typeFromCommentsFunction.getTypeText().equals(matchValue)) {
                    addReturnTypeInfoFromComments = false;
                }
                if (matchValue != null) {
                    if (addReturnTypeInfoFromComments) {
                        methodGenerationInfo.setReturnType(JSTypeUtils.createTypeFromJSDoc(matchValue, typeSource));
                    } else {
                        returnInfo.appendDescription(matchValue + " ");
                    }
                }
                if (remainingLineContent != null) {
                    returnInfo.appendDescription(remainingLineContent);
                }
                this.myInfoForNewLines = returnInfo;
            }
        } else if (!(metaDocType != JSDocumentationProcessor.MetaDocType.PARAMETER || this.myElement instanceof JSImplicitElement && ((JSImplicitElement)this.myElement).getType() == JSImplicitElement.Type.Property)) {
            this.onCommentLine(line);
        }
        return true;
    }

    public boolean isNestedDocType(@NotNull JSDocumentationProcessor.MetaDocType metaDocType, @NotNull String patternMatched) {
        if (metaDocType == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(12);
        }
        if (patternMatched == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(13);
        }
        return metaDocType == JSDocumentationProcessor.MetaDocType.PARAMETER && patternMatched.indexOf(64) >= 0 || metaDocType == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS || metaDocType == JSDocumentationProcessor.MetaDocType.FIELD || metaDocType == JSDocumentationProcessor.MetaDocType.DEFAULT;
    }

    @Override
    public void postProcess() {
        if (this.seenInheritDoc) {
            this.processOverriddenMembers();
        }
    }

    public void processOverriddenMembers() {
        if (this.myTargetInfo instanceof JSDocBuilderMethodInfo) {
            JSDocBuilderMethodInfo methodInfo = (JSDocBuilderMethodInfo)this.myTargetInfo;
            AtomicReference<Processor> processorRef = new AtomicReference<Processor>();
            HashSet hashSet = new HashSet();
            Processor processor = function2 -> {
                PsiComment e;
                if (!visited.add(function2)) {
                    return true;
                }
                if (function2 != this.myElement && (e = JSDocumentationUtils.findDocComment(function2.getNavigationElement())) != null) {
                    JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)function2, (PsiElement)function2, e, this.myProvider);
                    JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                    JSDocBuilderMethodInfo superMethodInfo = (JSDocBuilderMethodInfo)builder.myTargetInfo;
                    methodInfo.mergeDescriptionWith(superMethodInfo);
                    methodInfo.mergeSignatureWith(superMethodInfo);
                    return false;
                }
                for (JSFunction f : JSInheritanceUtil.findImplementedMethods(function2)) {
                    if (((Processor)processorRef.get()).process((Object)f)) continue;
                    return false;
                }
                for (JSPsiElementBase m : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)function2, true)) {
                    JSFunctionItem f = JSPsiImplUtils.calculatePossibleFunction((PsiElement)m, null, true);
                    if (!(f instanceof JSFunction) || ((Processor)processorRef.get()).process((Object)((JSFunction)f))) continue;
                    return false;
                }
                return true;
            };
            processorRef.set(processor);
            processor.process((Object)((JSFunction)this.myElement));
        } else if (this.namedItem != null) {
            Collection<Object> members = this.myElement instanceof JSClass ? ContainerUtil.newArrayList((Object[])((JSClass)this.myElement).getSuperClasses()) : JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)this.myElement, false);
            for (JSPsiElementBase jSPsiElementBase : members) {
                PsiComment e = JSDocumentationUtils.findDocComment((PsiElement)jSPsiElementBase);
                if (e == null) continue;
                JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)jSPsiElementBase, (PsiElement)jSPsiElementBase, e, this.myProvider);
                JSDocumentationUtils.processDocumentationTextFromComment(e.getNode(), builder);
                this.myTargetInfo.mergeDescriptionWith(builder.myTargetInfo);
            }
        }
    }

    private static String getFieldName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    @Nullable
    private JSDocBuilderParameterInfo getFieldInfo(String name) {
        Map<String, JSDocBuilderParameterInfo> map;
        String fieldName = JSDocumentationBuilder.getFieldName(name);
        if (fieldName == null) {
            return null;
        }
        Map<String, JSDocBuilderParameterInfo> map2 = map = this.currentParameterInfo != null ? this.currentParameterInfo.optionsMap : null;
        if (map == null) {
            return this.NULL_PARAMETER_INFO;
        }
        JSDocBuilderParameterInfo parameterInfo = map.get(fieldName);
        return parameterInfo != null ? parameterInfo : this.NULL_PARAMETER_INFO;
    }

    @Nullable
    final String getDoc() {
        StringBuilder newResult = new StringBuilder();
        this.myTargetInfo.appendDoc(newResult, this.myProvider);
        StringUtil.trimEnd((StringBuilder)newResult, (CharSequence)"<table class='sections'></table>");
        return newResult.length() > 0 ? newResult.toString() : null;
    }

    static String getNameForDocumentation(JSPsiNamedElementBase element) {
        String name = element.getName();
        if (name != null) {
            return name;
        }
        if (element instanceof JSComputedPropertyNameOwner) {
            String expressionAsReferenceName;
            ES6ComputedName computedName = ((JSComputedPropertyNameOwner)element).getComputedPropertyName();
            String string = expressionAsReferenceName = computedName == null ? null : computedName.getExpressionAsReferenceName();
            if (expressionAsReferenceName != null) {
                return "[" + expressionAsReferenceName + "]";
            }
            return "[<computed>]";
        }
        return "<unknown>";
    }

    @Nullable
    public String getParameterDoc(@NotNull JSParameter parameter, @Nullable PsiElement docComment, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (parameter == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(15);
        }
        if (this.function == null) {
            return null;
        }
        String name = parameter.getName();
        JSDocBuilderMethodInfo methodInfo = (JSDocBuilderMethodInfo)this.myTargetInfo;
        JSDocBuilderParameterInfo parameterInfo = methodInfo.parameterInfoMap.get(parameter);
        if (parameterInfo == null && docComment instanceof JSDocComment && this.function instanceof JSFunction && JSDestructuringUtil.isDestructuring(parameter.getParent())) {
            JSEvaluateContext context = new JSEvaluateContext(null);
            JSDestructuringParameter destructuringParameter = (JSDestructuringParameter)JSDestructuringUtil.findDestructuringParent((JSElement)parameter.getParent(), context, JSDestructuringParameter.class::isInstance);
            if (destructuringParameter != null) {
                String fieldName = context.getJSElementsToApply().stream().reduce("", (s, element) -> {
                    if (s == null) {
                        return null;
                    }
                    if (element instanceof JSApplyPropertyElement) {
                        return (s.isEmpty() ? "" : s + ".") + ((JSApplyPropertyElement)element).getName();
                    }
                    return null;
                }, String::concat);
                JSDocBuilderParameterInfo containerInfo = methodInfo.parameterInfoMap.get(destructuringParameter);
                if (containerInfo != null && containerInfo.hasSomeInfo() && fieldName != null) {
                    JSDocBuilderParameterInfo fieldInfo = containerInfo.optionsMap != null ? containerInfo.optionsMap.get(fieldName) : null;
                    return this.buildParameterInfo(name, fieldInfo != null ? fieldInfo : containerInfo, provider, place);
                }
            }
        }
        if (parameterInfo == null) {
            parameterInfo = new JSDocBuilderParameterInfo((JSParameterItem)parameter);
        }
        return this.buildParameterInfo(name, parameterInfo, provider, place);
    }

    @NotNull
    private String buildParameterInfo(@Nullable String name, @NotNull JSDocBuilderParameterInfo parameterInfo, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (parameterInfo == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(16);
        }
        if (provider == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(17);
        }
        StringBuilder newResult = new StringBuilder();
        parameterInfo.appendDoc(name, this.myTargetInfo, newResult, provider, place);
        String string = newResult.toString();
        if (string == null) {
            JSDocumentationBuilder.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean fillEvaluatedType() {
        if (this.myElement instanceof JSClass) {
            return true;
        }
        if (this.myTargetInfo.type == null) {
            this.myTargetInfo.type = this.calculateEvaluatedType();
        }
        return !DialectDetector.isActionScript(this.myElement) || this.myTargetInfo.type != null;
    }

    @Nullable
    private JSType calculateEvaluatedType() {
        JSType type;
        JSType typeForDoc;
        PsiElement parent;
        PsiElement contextElement = this.myTargetInfo.contextElement;
        if (contextElement != null && (parent = contextElement.getParent()) instanceof JSReferenceExpression && (typeForDoc = JSShowTypeInfoAction.getTypeForDocumentation(parent)) != null && !JSTypeUtils.isAnyType(typeForDoc)) {
            return typeForDoc;
        }
        JSType declaredType = JSTypeUtils.getTypeOfElement(this.myElement);
        if (declaredType != null && !JSTypeUtils.hasTypes(declaredType, JSEvaluableOnlyType.class) && !JSTypeUtils.hasTypes(declaredType, JSGenericParameterType.class)) {
            return declaredType;
        }
        JSExpression expressionForTypeEvaluation = JSPsiImplUtils.getAssignedExpression(this.myElement);
        if (expressionForTypeEvaluation != null && !(expressionForTypeEvaluation instanceof JSFunctionExpression) && (type = JSResolveUtil.getExpressionJSType(expressionForTypeEvaluation)) != null && !(type instanceof JSAnyType)) {
            if (type.getSource().isStrict()) {
                type = JSTypeUtils.copyWithStrictRecursive(type, false);
            }
            return type;
        }
        if (expressionForTypeEvaluation == null) {
            return JSShowTypeInfoAction.getTypeForDocumentation(this.myElement);
        }
        return null;
    }

    static {
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.NOTE, "Note:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.AUTHOR, "Author:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.FILE_OVERVIEW, "File overview:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.SINCE, "Since:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.VERSION, "Version:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.SUMMARY, "Summary:");
        SIMPLE_TAGS.put(JSDocumentationProcessor.MetaDocType.TODO, "To do:");
        ourBrTagPattern = Pattern.compile("<br\\s?/?>", 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaDocType";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMatched";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceBrTagsWithNewLines";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCommentLine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendPreOrInfoLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceNewLinesAndAppendPreLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceTagsAndAppendInfoLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceBrTagsWithNewLines";
                break;
            }
            case 7: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateInfoForNewLines";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onPatternMatch";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNestedDocType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDoc";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

