/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.GwtLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GwtSyntaxHighlighterFactory
extends SingleLazyInstanceSyntaxHighlighterFactory {
    @NotNull
    protected SyntaxHighlighter createHighlighter() {
        return new GwtSyntaxHighlighter();
    }

    private static class GwtSyntaxHighlighter
    extends JSHighlighter {
        private final Map<IElementType, TextAttributesKey> myKeysMap = new THashMap();

        GwtSyntaxHighlighter() {
            super(GwtLanguageDialect.DIALECT_OPTION_HOLDER, false);
            this.myKeysMap.put(JSTokenTypes.COLON_COLON, JS_OPERATION_SIGN);
            this.myKeysMap.put(JSTokenTypes.GWT_FIELD_OR_METHOD, DefaultLanguageHighlighterColors.FUNCTION_CALL);
            this.myKeysMap.put(JSTokenTypes.AT, JS_OPERATION_SIGN);
            this.myKeysMap.put(JSTokenTypes.IDENTIFIER, DefaultLanguageHighlighterColors.CLASS_NAME);
        }

        @Override
        public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
            if (this.myKeysMap.containsKey(tokenType)) {
                TextAttributesKey[] textAttributesKeyArray = GwtSyntaxHighlighter.pack((TextAttributesKey)this.myKeysMap.get(tokenType));
                if (textAttributesKeyArray == null) {
                    GwtSyntaxHighlighter.$$$reportNull$$$0(0);
                }
                return textAttributesKeyArray;
            }
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                GwtSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/GwtSyntaxHighlighterFactory$GwtSyntaxHighlighter", "getTokenHighlights"));
        }
    }
}

