/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexFlagsCompletionContributor
extends CompletionContributor {
    private static final char[] flags = new char[]{'g', 'i', 'm', 's', 'u', 'y'};
    private static final String[] descs = new String[]{"global match - return all matches", "ignore case - case-insensitive match", "multiline - per line match for ^ and $", "dotAll - . matches newlines", "unicode - full Unicode support", "sticky - search at the exact position"};
    private static final String rulezz = "IntellijIdeaRulezzz";

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement position;
        String s;
        if (parameters == null) {
            JSRegexFlagsCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSRegexFlagsCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((s = JSRegexFlagsCompletionContributor.checkAvailable(position = parameters.getPosition())) == null) {
            return;
        }
        int rulezzIndex = s.indexOf(rulezz);
        String noRulezz = s.replace(rulezz, "").trim();
        for (int i = 0; i < flags.length; ++i) {
            char flag = flags[i];
            if (noRulezz.indexOf(flag) >= 0) continue;
            LookupElementBuilder element = LookupElementBuilder.create((String)(rulezzIndex >= 0 ? s.substring(0, rulezzIndex) + flag : String.valueOf(flag))).withPresentableText(String.valueOf(flag)).withTypeText(descs[i]);
            result2.addElement((LookupElement)element);
        }
        result2.stopHere();
    }

    private static String checkAvailable(@Nullable PsiElement position) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)position);
        if (elementType == JSTokenTypes.IDENTIFIER) {
            String leafText;
            PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)position);
            if (leaf instanceof PsiErrorElement) {
                leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
            }
            if (PsiUtilCore.getElementType((PsiElement)leaf) != JSTokenTypes.REGEXP_LITERAL) {
                return null;
            }
            String text = leaf.getText();
            int i = text.lastIndexOf(47);
            if (i < 0) {
                return null;
            }
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)position);
            if (nextLeaf instanceof PsiErrorElement) {
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            if (nextLeaf instanceof PsiWhiteSpace && !nextLeaf.getText().contains("\n")) {
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            String postfix = "";
            if (nextLeaf != null && PsiUtilCore.getElementType((PsiElement)nextLeaf) == JSTokenTypes.IDENTIFIER && JSRegexFlagsCompletionContributor.hasOnlyRegexFlags(leafText = nextLeaf.getText())) {
                postfix = leafText;
            }
            return text.substring(i + 1) + postfix;
        }
        if (elementType == JSTokenTypes.STRING_LITERAL) {
            PsiFile file2;
            PsiElement parent = position.getParent();
            if (!(parent instanceof JSLiteralExpression) || !((JSLiteralExpression)parent).isQuotedLiteral()) {
                return null;
            }
            PsiElement grand = parent.getParent();
            if (!(grand instanceof JSArgumentList)) {
                return null;
            }
            PsiElement grandParent = grand.getParent();
            if (!(grandParent instanceof JSNewExpression)) {
                return null;
            }
            JSExpression expression = ((JSNewExpression)grandParent).getMethodExpression();
            if (!(expression instanceof JSReferenceExpression) || !"RegExp".equals(((JSReferenceExpression)expression).getReferenceName())) {
                return null;
            }
            PsiElement resolve = ((JSReferenceExpression)expression).resolve();
            PsiFile psiFile = file2 = resolve == null ? null : resolve.getContainingFile();
            if (!(file2 instanceof JSFile)) {
                return null;
            }
            String name = file2.getName();
            if (!name.startsWith("lib.") || !name.endsWith(".d.ts")) {
                return null;
            }
            return ((JSLiteralExpression)parent).getStringValue();
        }
        return null;
    }

    private static boolean hasOnlyRegexFlags(String text) {
        for (char c : text.toCharArray()) {
            boolean found = false;
            for (char flag : flags) {
                if (c != flag) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSRegexFlagsCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

