/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementInteractivity;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlerBase;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final String[] TYPE_LITERAL_VALUES = new String[]{"true", "false", "null"};
    private static final String[] KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE = new String[]{"true", "false", "null", "debugger"};
    private static final String[] DEFAULT_KEYWORDS_WITH_WHITESPACE = new String[]{"const", "delete", "new", "throw", "typeof", "var", "void"};

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiFile containingFile;
        if (parameters == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(2);
        }
        List<Object> variants = (containingFile = parameters.getPosition().getContainingFile().getOriginalFile()) instanceof JSExpressionCodeFragment ? ((JSExpressionCodeFragment)containingFile).getTopLevelVariants(parameters.getPosition()) : Arrays.asList(JSKeywordsCompletionProvider.getDefaultKeywordVariants(parameters.getPosition()));
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>(variants.size());
        for (Object variant : variants) {
            lookupElements.add(JSLookupUtilImpl.toBoldLookupElement(variant));
        }
        result2.addAllElements(lookupElements);
    }

    public static LookupElement @NotNull [] getDefaultKeywordVariants(@NotNull PsiElement context) {
        KeywordCompletionConsumer consumer;
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(3);
        }
        ArrayList<Trinity<String, JSLookupPriority, Boolean>> keywords = new ArrayList<Trinity<String, JSLookupPriority, Boolean>>();
        JSCompletionKeywordsContributor contributor = JSHandlersFactory.forElement(context).newCompletionKeywordsContributor();
        if (!contributor.process(consumer = JSKeywordsCompletionProvider.createKeywordConsumer(keywords), context)) {
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(4);
            }
            return lookupElementArray;
        }
        PsiElement parent = context.getParent();
        if (JSKeywordsCompletionProvider.isNoKeywordsContext(context, parent)) {
            if (LookupElement.EMPTY_ARRAY == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(5);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (JSKeywordsCompletionProvider.isCaseClauseContext(context, parent)) {
            JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(6);
            }
            return lookupElementArray;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(context);
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null || parent.textContains('.') || parent.textContains(':')) {
                if (LookupElement.EMPTY_ARRAY == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(7);
                }
                return LookupElement.EMPTY_ARRAY;
            }
            if (grandParent instanceof JSNewExpression) {
                boolean appendSpace = JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, appendSpace, "function");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(8);
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSStatement && JSKeywordsCompletionProvider.isStatementContext(parent, grandParent)) {
                boolean appendSpace;
                if (grandParent instanceof JSDoWhileStatement) {
                    boolean appendSpace2 = commonSettings.SPACE_BEFORE_WHILE_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace2, "while");
                    LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                    if (lookupElementArray == null) {
                        JSKeywordsCompletionProvider.$$$reportNull$$$0(9);
                    }
                    return lookupElementArray;
                }
                PsiElement prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)grandParent, JSStatement.class);
                if (prevStatement instanceof JSIfStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_ELSE_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "else");
                } else if (prevStatement instanceof JSTryStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "catch");
                    appendSpace = commonSettings.SPACE_BEFORE_FINALLY_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "finally");
                }
                if (grandParent instanceof JSExpressionStatement) {
                    PsiElement grandParentParent;
                    PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
                    if (prevSibling != null && prevSibling.getNode().getElementType() == JSTokenTypes.ELSE_KEYWORD) {
                        boolean appendSpace3 = commonSettings.SPACE_BEFORE_IF_PARENTHESES;
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace3, "if");
                    }
                    if ((grandParentParent = grandParent.getParent()) instanceof JSCaseClause) {
                        JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
                    }
                    if (grandParentParent instanceof JSForStatement) {
                        if (prevSibling instanceof PsiErrorElement) {
                            prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevSibling);
                        }
                        if (prevSibling instanceof JSVarStatement) {
                            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "of", "in");
                            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                            if (lookupElementArray == null) {
                                JSKeywordsCompletionProvider.$$$reportNull$$$0(10);
                            }
                            return lookupElementArray;
                        }
                    } else if (JSKeywordsCompletionProvider.isContextForOperation(prevSibling)) {
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "in");
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "instanceof");
                        LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                        if (lookupElementArray == null) {
                            JSKeywordsCompletionProvider.$$$reportNull$$$0(11);
                        }
                        return lookupElementArray;
                    }
                }
            } else {
                if (JSKeywordsCompletionProvider.isES6ShortHandedProperty(parent, grandParent)) {
                    if (LookupElement.EMPTY_ARRAY == null) {
                        JSKeywordsCompletionProvider.$$$reportNull$$$0(12);
                    }
                    return LookupElement.EMPTY_ARRAY;
                }
                JSKeywordsCompletionProvider.appendExpressionKeywords(keywords, commonSettings, grandParent);
                contributor.appendExpressionContextKeywords(consumer, context, grandParent);
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
                if (lookupElementArray == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(13);
                }
                return lookupElementArray;
            }
        }
        if (JSKeywordsCompletionProvider.isEmbeddedContentExpression(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, TYPE_LITERAL_VALUES);
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "int", "uint");
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(14);
            }
            return lookupElementArray;
        }
        boolean isLoop = JSKeywordsCompletionProvider.isLoopContext(grandParent);
        if (isLoop) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "continue");
        }
        if (isLoop || JSKeywordsCompletionProvider.isCaseClauseBodyContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "break");
        }
        if (JSKeywordsCompletionProvider.isFunctionBodyStatementContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY_EXOTIC, false, "return");
        }
        if (JSKeywordsCompletionProvider.isThisOwnerContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "this");
        }
        PsiElement sibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)parent);
        JSKeywordsCompletionProvider.appendEachKeyword(keywords, commonSettings, sibling);
        if (sibling != null && sibling.getNode().getElementType() == JSTokenTypes.LPAR && grandParent instanceof JSForStatement) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, "var");
            if (DialectDetector.hasFeature(parent, JSLanguageFeature.CONST_DEFINITIONS)) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, "const");
            }
            if (DialectDetector.hasFeature(parent, JSLanguageFeature.LET_DEFINITIONS)) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, "let");
            }
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
            if (lookupElementArray == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(15);
            }
            return lookupElementArray;
        }
        JSKeywordsCompletionProvider.appendDefaultKeywords(keywords, context, commonSettings);
        contributor.appendSpecificKeywords(consumer, context, grandParent);
        LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords, contributor);
        if (lookupElementArray == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(16);
        }
        return lookupElementArray;
    }

    private static void appendEachKeyword(@NotNull List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull CommonCodeStyleSettings commonSettings, @Nullable PsiElement sibling) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(17);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(18);
        }
        if (sibling != null && DialectDetector.hasFeature(sibling, JSLanguageFeature.FOR_EACH) && sibling.getNode().getElementType() == JSTokenTypes.FOR_KEYWORD) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, commonSettings.SPACE_BEFORE_FOR_PARENTHESES, "each");
        }
    }

    private static void appendExpressionKeywords(@NotNull List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull CommonCodeStyleSettings commonSettings, @Nullable PsiElement grandParent) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(19);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(20);
        }
        boolean isComparison = JSKeywordsCompletionProvider.isComparisonContext(grandParent);
        boolean isAssignment = JSKeywordsCompletionProvider.isAssignmentContext(grandParent);
        JSLookupPriority priority = JSLookupPriority.KEYWORDS_PRIORITY;
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, TYPE_LITERAL_VALUES);
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, "this");
        if (isAssignment || !isComparison) {
            boolean appendSpace = commonSettings.SPACE_BEFORE_METHOD_PARENTHESES;
            JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpace, "function");
        }
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "typeof");
        if (isAssignment || !isComparison) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "new");
        }
        if (isAssignment || !isComparison) {
            if (grandParent instanceof JSArgumentList) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "void");
            } else {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "void", "delete");
            }
        }
    }

    private static boolean isStatementContext(@NotNull PsiElement parent, @NotNull PsiElement grandParent) {
        if (parent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(21);
        }
        if (grandParent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(22);
        }
        if (grandParent instanceof JSConditionOwner && ((JSConditionOwner)grandParent).getCondition() == parent) {
            return false;
        }
        if (grandParent instanceof JSSwitchStatement && ((JSSwitchStatement)grandParent).getSwitchExpression() == parent) {
            return false;
        }
        if (grandParent instanceof JSThrowStatement && ((JSThrowStatement)grandParent).getExpression() == parent) {
            return false;
        }
        if (grandParent instanceof JSReturnStatement && ((JSReturnStatement)grandParent).getExpression() == parent) {
            return false;
        }
        return !(grandParent instanceof JSForInStatement) || ((JSForInStatement)grandParent).getCollectionExpression() != parent;
    }

    private static boolean isContextForOperation(@Nullable PsiElement prevSibling) {
        if (prevSibling instanceof PsiErrorElement) {
            return true;
        }
        if (prevSibling instanceof JSExpression && JSKeywordsCompletionProvider.endsWithErrorElement(prevSibling)) {
            return true;
        }
        if (prevSibling instanceof JSReturnStatement) {
            return PsiUtilCore.getElementType((PsiElement)prevSibling.getLastChild()) != JSTokenTypes.SEMICOLON;
        }
        if (!(prevSibling instanceof JSVarStatement)) {
            return false;
        }
        JSVarStatement prev = (JSVarStatement)prevSibling;
        PsiElement child = prev.getLastChild();
        PsiElement sibling = prev.getNextSibling();
        return child == null || child.getNode().getElementType() != JSTokenTypes.SEMICOLON && (sibling == null || !sibling.textContains('\n'));
    }

    private static boolean endsWithErrorElement(@Nullable PsiElement prevSibling) {
        if (prevSibling == null) {
            return false;
        }
        while (prevSibling instanceof JSExpression) {
            prevSibling = prevSibling.getLastChild();
        }
        return prevSibling instanceof PsiErrorElement;
    }

    @NotNull
    private static KeywordCompletionConsumer createKeywordConsumer(final List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        return new KeywordCompletionConsumer(){

            @Override
            public void consume(JSLookupPriority priority, boolean appendSpaces, String ... contributorKeywords) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpaces, contributorKeywords);
            }
        };
    }

    private static boolean isComparisonContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign());
    }

    private static boolean isAssignmentContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSArgumentList || grandParent instanceof JSBinaryExpression && ((JSBinaryExpression)grandParent).getOperationSign() == JSTokenTypes.EQ;
    }

    public static boolean isExactContextForOperation(@NotNull PsiElement parentContext) {
        PsiElement prev;
        PsiElement gradParent;
        if (parentContext == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(23);
        }
        if ((gradParent = parentContext.getParent()) == null) {
            return false;
        }
        for (prev = gradParent.getPrevSibling(); prev != null && prev instanceof PsiWhiteSpace; prev = prev.getPrevSibling()) {
            if (!prev.textContains('\n')) continue;
            return false;
        }
        return JSKeywordsCompletionProvider.isContextForOperation(prev);
    }

    private static void appendDefaultKeywords(@NotNull List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull PsiElement context, @NotNull CommonCodeStyleSettings commonSettings) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(25);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(26);
        }
        ArrayList withoutSpace = new ArrayList(30);
        ContainerUtil.addAll(withoutSpace, (Object[])KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE);
        ArrayList<String> withSpace = new ArrayList<String>(20);
        ContainerUtil.addAll(withSpace, (Object[])DEFAULT_KEYWORDS_WITH_WHITESPACE);
        (commonSettings.SPACE_BEFORE_WHILE_PARENTHESES ? withSpace : withoutSpace).add("while");
        (commonSettings.SPACE_BEFORE_DO_LBRACE ? withSpace : withoutSpace).add("do");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("for");
        (JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH ? withSpace : withoutSpace).add("function");
        (commonSettings.SPACE_BEFORE_IF_PARENTHESES ? withSpace : withoutSpace).add("if");
        (commonSettings.SPACE_BEFORE_TRY_LBRACE ? withSpace : withoutSpace).add("try");
        (commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES ? withSpace : withoutSpace).add("switch");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, ArrayUtilRt.toStringArray(withoutSpace));
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, ArrayUtilRt.toStringArray(withSpace));
        keywords.add((Trinity<String, JSLookupPriority, Boolean>)Trinity.create((Object)"with", (Object)((Object)JSLookupPriority.LOWEST_PRIORITY), (Object)true));
    }

    private static boolean isCaseClauseContext(@NotNull PsiElement context, @Nullable PsiElement parent) {
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(27);
        }
        return parent instanceof JSCaseClause && SyntaxTraverser.psiTraverser().children((Object)parent).filter(Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{PsiErrorElement.class, PsiWhiteSpace.class}))).first() == context;
    }

    private static boolean isCaseClauseBodyContext(@Nullable PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, JSCaseClause.class) != null;
    }

    private static boolean isLoopContext(@Nullable PsiElement context) {
        return PsiTreeUtil.getParentOfType((PsiElement)context, JSLoopStatement.class) != null;
    }

    private static boolean isFunctionBodyStatementContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSExpressionStatement && PsiTreeUtil.getParentOfType((PsiElement)grandParent, JSFunction.class) != null;
    }

    private static boolean isThisOwnerContext(@Nullable PsiElement parent) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptEnum.class, (boolean)true, (Class[])new Class[]{TypeScriptFunction.class, TypeScriptModule.class, TypeScriptClass.class, JSObjectLiteralExpression.class}) != null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptModule.class) == null) {
            return true;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        return parentFunction != null;
    }

    private static boolean isNoKeywordsContext(@NotNull PsiElement context, PsiElement parent) {
        if (context == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(28);
        }
        return parent instanceof JSBreakStatement || parent instanceof JSContinueStatement || parent instanceof JSLiteralExpression || parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof XmlAttribute || parent instanceof XmlAttributeValue || parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == context || parent instanceof TypeScriptModule && ((TypeScriptModule)parent).getNameIdentifier() == context || JSTokenTypes.STRING_LITERALS.contains(context.getNode().getElementType()) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSAttribute.class}) != null || parent instanceof JSReferenceExpression && (JSResolveUtil.isSelfReference(parent) || parent.getParent() instanceof TypeScriptTypeofType) || parent != null && JSKeywordsCompletionProvider.isJustAfterLiteral(parent);
    }

    private static boolean isJustAfterLiteral(@NotNull PsiElement parent) {
        PsiElement leaf;
        if (parent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(29);
        }
        if ((leaf = PsiTreeUtil.prevLeaf((PsiElement)parent)) instanceof PsiErrorElement) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return leaf != null && JSTokenTypes.LITERALS.contains(PsiUtilCore.getElementType((PsiElement)leaf));
    }

    private static boolean isES6ShortHandedProperty(PsiElement parent, PsiElement grandParent) {
        return grandParent instanceof JSProperty && ((JSProperty)grandParent).getNameIdentifier() == parent;
    }

    private static boolean isEmbeddedContentExpression(PsiElement grandParent) {
        ASTNode grandParentNode;
        return grandParent instanceof JSEmbeddedContent && (grandParentNode = grandParent.getNode()) != null && grandParentNode.getElementType() == JSStubElementTypes.EMBEDDED_EXPRESSION;
    }

    private static void appendCaseKeywords(List<? super Trinity<String, JSLookupPriority, Boolean>> keywords) {
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "case");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "default");
    }

    public static void appendKeywords(List<? super Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull JSLookupPriority priority, boolean appendSpace, String ... names) {
        if (priority == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(30);
        }
        for (String name : names) {
            keywords.add((Trinity<String, JSLookupPriority, Boolean>)Trinity.create((Object)name, (Object)((Object)priority), (Object)appendSpace));
        }
    }

    private static LookupElement[] createKeywordItems(List<Trinity<String, JSLookupPriority, Boolean>> keywords, JSCompletionKeywordsContributor contributor) {
        THashMap keywordsMap = new THashMap();
        for (Trinity<String, JSLookupPriority, Boolean> keyword : keywords) {
            Pair oldKeywordValue = (Pair)keywordsMap.get(keyword.first);
            if (oldKeywordValue != null && ((JSLookupPriority)((Object)oldKeywordValue.first)).compareTo((Enum)keyword.second) >= 0) continue;
            keywordsMap.put(keyword.first, Pair.create((Object)keyword.second, (Object)keyword.third));
        }
        LookupElement[] result2 = new LookupElement[keywordsMap.size()];
        int i = 0;
        for (Map.Entry<String, Pair<JSLookupPriority, Boolean>> entry : keywordsMap.entrySet()) {
            String option = (String)entry.getKey();
            InsertHandler<LookupElement> insertHandler = JSKeywordsCompletionProvider.getInsertHandler(entry, option, contributor);
            LookupElementBuilder element = LookupElementBuilder.create((String)option).withBoldness(true).withInsertHandler(insertHandler);
            LookupElement item = JSCompletionUtil.withJSLookupPriority((LookupElement)element, (JSLookupPriority)((Object)entry.getValue().first));
            if (insertHandler instanceof JSKeywordInsertHandlerBase) {
                item.putUserData(LookupElementInteractivity.KEY, (Object)LookupElementInteractivity.ALWAYS);
            }
            result2[i++] = item;
        }
        return result2;
    }

    @NotNull
    private static InsertHandler<LookupElement> getInsertHandler(Map.Entry<String, Pair<JSLookupPriority, Boolean>> entry, String option, JSCompletionKeywordsContributor contributor) {
        InsertHandler<LookupElement> handlerForKeyword = contributor.createInsertHandlerForKeyword(option);
        if (handlerForKeyword != null) {
            InsertHandler<LookupElement> insertHandler = handlerForKeyword;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(31);
            }
            return insertHandler;
        }
        if (((Boolean)entry.getValue().second).booleanValue()) {
            InsertHandler insertHandler = AddSpaceInsertHandler.INSTANCE;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(32);
            }
            return insertHandler;
        }
        InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
        if (insertHandler == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(33);
        }
        return insertHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 18: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeywordVariants";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultKeywordVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendEachKeyword";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendExpressionKeywords";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStatementContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExactContextForOperation";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultKeywords";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isCaseClauseContext";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isNoKeywordsContext";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isJustAfterLiteral";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendKeywords";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

