/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompletionService
implements Disposable {
    private static final int MAX_THREADS = JobSchedulerImpl.getJobPoolParallelism();
    private static final int TIMEOUT = ApplicationManager.getApplication().isUnitTestMode() ? 10000 : 100;
    private final ExecutorService executor;
    private final Map<Icon, Icon> myPartialIcons;

    public JSCompletionService(@NotNull Project project) {
        if (project == null) {
            JSCompletionService.$$$reportNull$$$0(0);
        }
        this.executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"JS Completion Service", (int)MAX_THREADS);
        this.myPartialIcons = ContainerUtil.createConcurrentSoftMap();
        LookupManager lookupManager = LookupManager.getInstance((Project)project);
        lookupManager.addPropertyChangeListener(ev -> {
            if ("activeLookup".equals(ev.getPropertyName()) && ev.getOldValue() != null && ev.getNewValue() == null) {
                this.cancelAll();
            }
        });
    }

    private void cancelAll() {
        ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
    }

    public void dispose() {
        this.cancelAll();
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.myPartialIcons.clear();
    }

    public static JSCompletionService getInstance(@NotNull Project project) {
        if (project == null) {
            JSCompletionService.$$$reportNull$$$0(1);
        }
        return (JSCompletionService)ServiceManager.getService((Project)project, JSCompletionService.class);
    }

    void submitBackgroundActivity(Runnable task) {
        this.executor.execute(task);
    }

    @Nullable
    Icon getPartialIcon(@Nullable Icon icon) {
        Icon partialIcon;
        if (icon instanceof DeferredIcon) {
            icon = ((DeferredIcon)icon).evaluate();
        }
        if ((partialIcon = this.myPartialIcons.get(icon)) == null && icon != null) {
            partialIcon = IconUtil.desaturate((Icon)icon);
            if (!(icon instanceof CompositeIcon) && !(icon instanceof DeferredIcon)) {
                this.myPartialIcons.put(icon, partialIcon);
            }
            return partialIcon;
        }
        return partialIcon;
    }

    boolean awaitWithTimeout() {
        try {
            ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted((long)TIMEOUT, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

