/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.HtmlTextCompletionConfidence;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAutoCompletionPopupPolicy
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        boolean isIdentifier;
        IElementType nodeType;
        PsiElement prevContextElement;
        ASTNode node;
        PsiElement parent;
        PsiElement commentOrLiteral;
        if (contextElement == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(1);
        }
        if ((commentOrLiteral = PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{PsiComment.class, JSExpression.class})) instanceof JSLiteralExpression) {
            if (JSAutoCompletionPopupPolicy.shouldSkipAutopopupInLiteral((JSLiteralExpression)commentOrLiteral)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(2);
                }
                return threeState;
            }
        } else if (!(!(commentOrLiteral instanceof PsiComment) || contextElement.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME || (parent = contextElement.getParent()) instanceof JSDocTag && parent.getReference() instanceof JSDocParamReference || parent instanceof JSDocTagValue)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if ((node = (prevContextElement = contextElement).getNode()) != null && ((nodeType = node.getElementType()) == JSTokenTypes.DOT || nodeType == JSTokenTypes.DOT_DOT || nodeType == JSTokenTypes.DOT_DOT_DOT)) {
            prevContextElement = PsiTreeUtil.prevLeaf((PsiElement)prevContextElement);
        }
        if (prevContextElement != null && prevContextElement.getParent() instanceof JSParameterList || prevContextElement instanceof PsiErrorElement) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        PsiElement parent2 = contextElement.getParent();
        boolean bl = isIdentifier = node != null && JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType());
        if (parent2 instanceof JSProperty && !isIdentifier || (parent2 instanceof JSProperty || JSAutoCompletionPopupPolicy.isShorthandedProperty(parent2)) && !JSAutoCompletionPopupPolicy.isES6OrTypeScript(contextElement) || parent2 instanceof TypeScriptPropertySignature) {
            JSClass classOfContext = JSResolveUtil.getClassOfContext(parent2);
            if (classOfContext != null && classOfContext.isInterface()) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            if (parent2.getParent() instanceof TypeScriptObjectType) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (!JSCompletionUtil.isUnparsedGenericTail(parent2)) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    JSAutoCompletionPopupPolicy.$$$reportNull$$$0(7);
                }
                return threeState;
            }
        }
        if (HtmlTextCompletionConfidence.shouldSkipAutopopupInHtml((PsiElement)contextElement, (int)offset)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JSAutoCompletionPopupPolicy.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(9);
        }
        return threeState;
    }

    private static boolean isES6OrTypeScript(@NotNull PsiElement psiFile) {
        DialectOptionHolder holder;
        if (psiFile == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(10);
        }
        return (holder = DialectDetector.dialectOfElement(psiFile)) != null && (holder.isTypeScript || holder.isECMA6);
    }

    private static boolean isShorthandedProperty(@Nullable PsiElement parent) {
        return parent instanceof JSReferenceExpression && parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded();
    }

    private static boolean isExpressionOnTypeofContext(JSExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSBinaryExpression) {
            JSExpression otherOperand;
            JSBinaryExpression binaryExpr = (JSBinaryExpression)parent;
            JSExpression lOperand = binaryExpr.getLOperand();
            JSExpression jSExpression = otherOperand = lOperand == expr ? binaryExpr.getROperand() : lOperand;
            if (otherOperand instanceof JSPrefixExpression && ((JSPrefixExpression)otherOperand).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldSkipAutopopupInLiteral(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSAutoCompletionPopupPolicy.$$$reportNull$$$0(11);
        }
        if (literal instanceof JSXmlLiteralExpression) {
            return false;
        }
        PsiElement parent = literal.getParent();
        if (literal.isQuotedLiteral() && parent instanceof JSArgumentList) {
            return false;
        }
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            return false;
        }
        if (parent instanceof TypeScriptStringLiteralType && parent.getParent() instanceof TypeScriptIndexedAccessType) {
            return false;
        }
        if (parent instanceof ES6ImportCall) {
            return false;
        }
        return !JavaScriptReferenceContributor.Holder.REQUIRE_ARG_PLACE.accepts((Object)literal) && !JSAutoCompletionPopupPolicy.isExpressionOnTypeofContext((JSExpression)literal);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSAutoCompletionPopupPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldSkipAutopopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isES6OrTypeScript";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipAutopopupInLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

