/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ClassExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlers;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.TypeScriptCompletionKeywordsContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    public static final String IMPORT_WITH_BRACES = "import()";
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context) {
        JSClass containingClass;
        PsiElement grandParentParent;
        PsiElement parent;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (ES6CompletionKeywordsContributor.addMetaKeyword(consumer, parent = context.getParent())) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addFromOrAsKeyword(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addExtendsImplements(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExportDefault(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExtendsImplements(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterExport(parent)) {
            this.appendKeywordsAfterExport(consumer);
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterImport(parent)) {
            this.appendKeywordsAfterImport(consumer);
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent) && !TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(parent)) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "import", "export");
        }
        if (!ES6CompletionKeywordsContributor.processClassMemberContext(parent, grandParent, consumer)) {
            return false;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) != null && parentFunction.getJSContext() != JSContext.STATIC && !containingClass.isInterface() && containingClass.getExtendsList() != null && !(grandParent instanceof ES6Property)) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, false, "super");
        }
        return super.process(consumer, context);
    }

    protected void appendKeywordsAfterImport(KeywordCompletionConsumer consumer) {
    }

    private static boolean isAfterImport(PsiElement parent) {
        return parent instanceof ES6ImportedBinding && parent.getParent() instanceof ES6ImportDeclaration;
    }

    private static boolean addMetaKeyword(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        if (parent instanceof Es6MetaProperty) {
            String parentText = parent.getText();
            if (parentText.startsWith("new.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "target");
                return true;
            }
            if (parentText.startsWith("import.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "meta");
                return true;
            }
        }
        return false;
    }

    private static boolean processClassMemberContext(@NotNull PsiElement parent, @Nullable PsiElement grandParent, @NotNull KeywordCompletionConsumer consumer) {
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(4);
        }
        if (parent instanceof JSField && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class) {
            if (!ES6CompletionKeywordsContributor.checkClassMemberPrevSibling(grandParent)) {
                return false;
            }
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)parent).SPACE_BEFORE_METHOD_PARENTHESES, "constructor");
            consumer.consume(JSLookupPriority.SMART_PRIORITY, true, "static");
            return false;
        }
        return true;
    }

    protected static boolean checkClassMemberPrevSibling(@NotNull PsiElement grandParent) {
        PsiElement sibling;
        PsiElement prev;
        if (grandParent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(5);
        }
        return !((prev = grandParent.getPrevSibling()) instanceof PsiWhiteSpace) || prev.textContains('\n') || !((sibling = prev.getPrevSibling()) instanceof JSVarStatement) || !(sibling.getLastChild() instanceof PsiErrorElement);
    }

    private static boolean isModuleContext(@Nullable PsiElement parent, @Nullable PsiElement grandParent, @Nullable PsiElement grandParentParent) {
        return parent instanceof JSReferenceExpression && grandParent instanceof JSExpressionStatement && (grandParentParent instanceof JSFile || grandParentParent instanceof TypeScriptModule || grandParentParent instanceof JSEmbeddedContent);
    }

    public static boolean isAfterExport(@Nullable PsiElement parent) {
        PsiElement grandParentParent;
        if (parent == null) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent)) {
            PsiElement prevPrevSibling;
            assert (grandParent != null);
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
            if (prevSibling instanceof PsiErrorElement && JavaScriptBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription()) && (prevPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevSibling)) instanceof JSAttributeList && ((JSAttributeList)prevPrevSibling).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                return true;
            }
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAfterExportDefault(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(6);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prev instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        if (!((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev)) instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.EXPORT_KEYWORD) {
            return false;
        }
        consumer.consume(JSLookupPriority.SMART_PRIORITY, true, "class", "function", "async");
        return true;
    }

    public static boolean addAfterExtendsImplements(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        JSExpression expression;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(7);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSReferenceListMember && (expression = ((JSReferenceListMember)grandParent).getExpression()) == parent) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class");
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean addExtendsImplements(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof ES6ClassExpression) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsForClassExpressionContext(consumer, parent);
        }
        PsiElement expression = ES6CompletionKeywordsContributor.getBeforeExtendsExpression(parent);
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (expression instanceof JSReferenceExpression) {
            PsiElement prevPrev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression);
            if (prevPrev instanceof LeafPsiElement) {
                IElementType type = ((LeafPsiElement)prevPrev).getElementType();
                if (type == JSTokenTypes.CLASS_KEYWORD) {
                    return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, parent);
                }
                if (type == JSTokenTypes.INTERFACE_KEYWORD) {
                    if (consumer != null) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
                    }
                    return true;
                }
                if (type == JSTokenTypes.ENUM_KEYWORD) {
                    return true;
                }
            }
        } else if (expression instanceof JSReferenceList) {
            IElementType type;
            PsiElement child = expression.getParent().getFirstChild();
            PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
            if (hasInterfaces && possibleClassKeyword instanceof LeafPsiElement && (type = ((LeafPsiElement)possibleClassKeyword).getElementType()) == JSTokenTypes.CLASS_KEYWORD) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
                }
                return true;
            }
        } else if (expression instanceof TypeScriptTypeParameter) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
            }
            return true;
        }
        return false;
    }

    private static boolean addExtendsImplementsKeywords(@Nullable KeywordCompletionConsumer consumer, @NotNull PsiElement parent) {
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(8);
        }
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
            if (hasInterfaces) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
            }
        }
        return true;
    }

    private static boolean addExtendsImplementsForClassExpressionContext(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (possibleClassKeyword != null && possibleClassKeyword.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, parent);
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean addFromOrAsKeyword(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        ASTNode node;
        if (!(parent instanceof JSReferenceExpression)) {
            return ES6CompletionKeywordsContributor.addAsKeywordForImportExportSpecifier(consumer, parent);
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        boolean isImport = prevSiblingPrevSibling instanceof ES6ImportDeclaration;
        boolean isExport = prevSiblingPrevSibling instanceof ES6ExportDeclaration;
        if (!isImport && !isExport) {
            return false;
        }
        PsiElement last = prevSiblingPrevSibling.getLastChild();
        if (last != null) {
            PsiElement prev;
            PsiElement lastLast = last.getLastChild();
            if (lastLast instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastLast)) != null && prev.getNode().getElementType() == JSTokenTypes.MULT) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, isImport ? "as" : "from");
                }
                return true;
            }
            prev = last.getPrevSibling();
            if (prev != null) {
                IElementType type = prev.getNode().getElementType();
                if (type == JSTokenTypes.COMMA) {
                    return true;
                }
                if (!isImport && type == JSTokenTypes.MULT && consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "as");
                }
            }
        }
        if ((node = prevSiblingPrevSibling.getNode()).findChildByType(FILE_REFERENCES) == null) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "from");
            }
            return !isExport || !prevSibling.textContains('\n');
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAsKeywordForImportExportSpecifier(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        PsiElement prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prevNode instanceof PsiErrorElement)) {
            return false;
        }
        if (!((prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevNode)) instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "as");
        }
        return true;
    }

    @Nullable
    private static PsiElement getBeforeExtendsExpression(@NotNull PsiElement parent) {
        PsiElement prev;
        PsiElement deepestLast;
        PsiElement grandParent;
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(9);
        }
        if (!((grandParent = parent.getParent()) instanceof JSExpressionStatement)) {
            return null;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return null;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        if (prevSiblingPrevSibling instanceof JSClass) {
            PsiElement lastChild = prevSiblingPrevSibling.getLastChild();
            if (!(lastChild instanceof PsiErrorElement)) {
                return null;
            }
            return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        }
        if (prevSiblingPrevSibling instanceof JSStatement && (deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)prevSiblingPrevSibling)) instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)deepestLast)) instanceof JSReferenceExpression) {
            return prev;
        }
        return null;
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context, PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(11);
        }
        super.appendSpecificKeywords(consumer, context, grandParent);
        this.appendAwaitYieldKeywords(consumer, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class", "async");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, IMPORT_WITH_BRACES);
    }

    @Override
    public void appendExpressionContextKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context, @Nullable PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(13);
        }
        super.appendExpressionContextKeywords(consumer, context, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "class", "async");
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, IMPORT_WITH_BRACES);
        this.appendAwaitYieldKeywords(consumer, grandParent);
    }

    protected void appendAwaitYieldKeywords(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement grandParent) {
        JSLookupPriority priority;
        JSFunction function2;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(14);
        }
        if ((function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)grandParent, JSFunction.class)) != null && function2.isAsync()) {
            priority = ES6CompletionKeywordsContributor.isPrefixExpressionWith(grandParent, JSTokenTypes.AWAIT_KEYWORD) ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
            consumer.consume(priority, true, "await");
        }
        if (function2 != null && function2.isGenerator()) {
            priority = grandParent instanceof JSYieldExpression ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
            consumer.consume(priority, true, "yield");
        }
    }

    private static boolean isPrefixExpressionWith(@Nullable PsiElement grandParent, @NotNull IElementType prefix) {
        if (prefix == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(15);
        }
        return grandParent instanceof JSPrefixExpression && ((JSPrefixExpression)grandParent).getOperationSign() == prefix;
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "class", "var", "const", "let", "function", "default", "async");
    }

    @Override
    @Nullable
    public InsertHandler<LookupElement> createInsertHandlerForKeyword(String keyword) {
        if ("class".equals(keyword)) {
            return JSKeywordInsertHandlers.CLASS_KEYWORD_INSERT_HANDLER;
        }
        return super.createInsertHandlerForKeyword(keyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/ES6CompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addMetaKeyword";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassMemberContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassMemberPrevSibling";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExportDefault";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExtendsImplements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtendsImplementsKeywords";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeforeExtendsExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExpressionContextKeywords";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAwaitYieldKeywords";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrefixExpressionWith";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

