/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtService {
    public static final ExtensionPointName<JsbtService> EP_NAME = ExtensionPointName.create((String)"JavaScript.buildToolService");
    private static final Logger LOG = Logger.getInstance(JsbtService.class);
    private final Map<Project, JsbtToolWindowManager> myToolWindowManagerMap = new HashMap<Project, JsbtToolWindowManager>();

    @NonNls
    @NotNull
    public abstract String getName();

    @NotNull
    public String getShowTasksActionName() {
        String string = JavaScriptBundle.message((String)"buildTools.JsbtShowTasksAction.text", (Object[])new Object[]{this.getName()});
        if (string == null) {
            JsbtService.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getSearchEverywhereDescription(@NotNull String taskName) {
        if (taskName == null) {
            JsbtService.$$$reportNull$$$0(1);
        }
        String string = JavaScriptBundle.message((String)"buildTools.searchEverywhere.text", (Object[])new Object[]{taskName});
        if (string == null) {
            JsbtService.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getReloadTasksActionName() {
        String string = JavaScriptBundle.message((String)"buildTools.JsbtReloadTasksAction.text", (Object[])new Object[0]);
        if (string == null) {
            JsbtService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getToolWindowSettingsActionName() {
        String string = JavaScriptBundle.message((String)"buildTools.ShowSettingsAction.text", (Object[])new Object[]{this.getName()});
        if (string == null) {
            JsbtService.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public abstract Icon getIcon();

    @NotNull
    public abstract JsbtFileManager getFileManager(@NotNull Project var1);

    @NotNull
    public final JsbtToolWindowManager getToolWindowManager(@NotNull Project project) {
        if (project == null) {
            JsbtService.$$$reportNull$$$0(5);
        }
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        JsbtToolWindowManager toolWindowManager = this.myToolWindowManagerMap.get(project);
        if (toolWindowManager == null) {
            toolWindowManager = this.createToolWindowManager(project);
            this.myToolWindowManagerMap.put(project, toolWindowManager);
            app.getMessageBus().connect((Disposable)project).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    JsbtService.this.myToolWindowManagerMap.remove(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtService$1", "projectClosed"));
                }
            });
        }
        JsbtToolWindowManager jsbtToolWindowManager = toolWindowManager;
        if (jsbtToolWindowManager == null) {
            JsbtService.$$$reportNull$$$0(6);
        }
        return jsbtToolWindowManager;
    }

    @NotNull
    protected abstract JsbtToolWindowManager createToolWindowManager(@NotNull Project var1);

    @NotNull
    public abstract JsbtTaskTreeView createTaskTreeView(@NotNull Project var1, @Nullable String var2);

    @NotNull
    public abstract List<VirtualFile> detectAllBuildfiles(@NotNull Project var1);

    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            JsbtService.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list2 = this.detectAllBuildfilesInContentRoots(project, webModulesOnly, false);
        if (list2 == null) {
            JsbtService.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public abstract List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project var1, boolean var2, boolean var3);

    public abstract String getBuildfileCommonName();

    public abstract boolean isBuildfile(@NotNull VirtualFile var1);

    @NotNull
    public abstract JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile var1);

    @NotNull
    public abstract JsbtFileStructure fetchBuildfileStructure(@NotNull Project var1, @NotNull VirtualFile var2) throws JsbtTaskFetchException;

    @NotNull
    public abstract ConfigurationFactory getConfigurationFactory();

    public abstract boolean isConfigurationMatched(@NotNull RunConfiguration var1, @NotNull Object var2);

    public abstract void setupRunConfiguration(@NotNull RunConfiguration var1, @NotNull JsbtTaskSet var2);

    public abstract boolean showTaskListingSettingsDialog(@NotNull Project var1, @Nullable VirtualFile var2);

    @NotNull
    protected static <T extends JsbtService> AtomicNotNullLazyValue<T> newLazyInstance(final @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            JsbtService.$$$reportNull$$$0(9);
        }
        return new AtomicNotNullLazyValue<T>(){

            @NotNull
            protected T compute() {
                JsbtService instance = (JsbtService)EP_NAME.findExtension(serviceClass);
                if (instance == null) {
                    String message = "Cannot find extension " + EP_NAME.getName() + " of class " + serviceClass.getName();
                    LOG.error(message);
                    try {
                        instance = (JsbtService)serviceClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot instantiate new instance either: " + message, e);
                    }
                }
                JsbtService jsbtService = instance;
                if (jsbtService == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jsbtService;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService$2", "compute"));
            }
        };
    }

    public void editConfigurations(@NotNull Project project) {
        if (project == null) {
            JsbtService.$$$reportNull$$$0(10);
        }
        EditConfigurationsDialog dialog = new EditConfigurationsDialog(project);
        UiNotifyConnector.doWhenFirstShown((JComponent)dialog.getContentPanel(), () -> {
            RunConfiguration configuration;
            RunConfigurationSelector selector = (RunConfigurationSelector)RunConfigurationSelector.KEY.getData(DataManager.getInstance().getDataContext((Component)dialog.getPreferredFocusedComponent()));
            if (selector != null && (configuration = (RunConfiguration)ContainerUtil.getFirstItem((List)RunManager.Companion.getInstance(project).getConfigurationsList(this.getConfigurationFactory().getType()))) != null) {
                selector.select(configuration);
            }
        });
        dialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShowTasksActionName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchEverywhereDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReloadTasksActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowSettingsActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSearchEverywhereDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowManager";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newLazyInstance";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

