/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JavaScriptDialectFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialectDetector {
    public static final Key<JSLanguageLevel> KEY = Key.create((String)"JS_LANGUAGE_LEVEL");
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = new FileType[]{JavaScriptSupportLoader.JAVASCRIPT, ES6FileType.INSTANCE, JSXHarmonyFileType.INSTANCE, FlowJSFileType.INSTANCE};
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = Collections.unmodifiableList(ContainerUtil.newArrayList((Object[])JAVASCRIPT_FILE_TYPES_ARRAY));
    private static final Key<ParameterizedCachedValue<JSLanguageDialect, PsiFile>> KEY_DIALECT_HOLDER = Key.create((String)"JavaScript.Dialect.Holder");
    private static final ParameterizedCachedValueProvider<JSLanguageDialect, PsiFile> PROVIDER = file2 -> CachedValueProvider.Result.create((Object)((Object)DialectDetector.dialectOfFileNoCache(file2)), (Object[])new Object[]{file2});

    private DialectDetector() {
    }

    @Nullable
    public static DialectOptionHolder dialectOfElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect ? ((JSLanguageDialect)language).getOptionHolder() : null;
    }

    public static boolean hasFeature(@Nullable PsiElement element, @NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectDetector.$$$reportNull$$$0(0);
        }
        return element != null && DialectDetector.hasFeature(DialectDetector.dialectOfElement(element), feature);
    }

    public static boolean hasFeature(@Nullable DialectOptionHolder optionHolder, @NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectDetector.$$$reportNull$$$0(1);
        }
        return optionHolder != null && optionHolder.hasFeature(feature);
    }

    @Deprecated
    @Nullable
    public static DialectOptionHolder dialectOfFile(@Nullable PsiFile file2) {
        return DialectDetector.dialectOfElement((PsiElement)file2);
    }

    @Nullable
    private static JSLanguageDialect dialectOfFileNoCache(@NotNull PsiFile file2) {
        JSLanguageDialect dialect;
        Language language;
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(2);
        }
        if ((language = file2.getLanguage()) instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        if (language == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (JavaScriptSupportLoader.isMxmlOrFxgFile(file2)) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file2.getOriginalFile().getVirtualFile();
        VirtualFile virtualFile2 = virtualFile = virtualFile == null ? (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)file2) : virtualFile;
        if (virtualFile != null && ("swf".equalsIgnoreCase(virtualFile.getExtension()) || "swc".equalsIgnoreCase(virtualFile.getExtension()))) {
            return JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null && (dialect = DialectDetector.getLanguageDialect(virtualFile, file2.getProject())) != null) {
            return dialect;
        }
        return null;
    }

    @NotNull
    public static Language languageOfElement(@NotNull PsiElement element) {
        JSLanguageDialect dialect;
        PsiFile file2;
        PsiElement context;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(3);
        }
        if (element instanceof LeafPsiElement && (context = element.getContext()) instanceof JSElement) {
            Language language = context.getLanguage();
            if (language == null) {
                DialectDetector.$$$reportNull$$$0(4);
            }
            return language;
        }
        if (element instanceof XmlElement && (file2 = element.getContainingFile()) != null && (dialect = DialectDetector.getJSDialectOfFileOrNull(file2)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(5);
            }
            return jSLanguageDialect;
        }
        Language language = element.getLanguage();
        if (language == null) {
            DialectDetector.$$$reportNull$$$0(6);
        }
        return language;
    }

    @NotNull
    public static Language calculateJSLanguage(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(7);
        }
        if (element instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(8);
            }
            return jSLanguageDialect;
        }
        if (element instanceof PsiFile) {
            return DialectDetector.getJSDialectOfFile((PsiFile)element);
        }
        if (element instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            PsiFile file2 = element.getContainingFile();
            Object object = file2 instanceof JSFile ? file2.getLanguage() : JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element).getElementType(), file2, element.getProject());
            if (object == null) {
                DialectDetector.$$$reportNull$$$0(9);
            }
            return object;
        }
        for (parent = element.getContext(); parent != null; parent = parent.getContext()) {
            if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl || parent instanceof JSEmbeddedContent) {
                Language language = parent.getLanguage();
                if (language == null) {
                    DialectDetector.$$$reportNull$$$0(10);
                }
                return language;
            }
            if (!(parent instanceof PsiFile)) continue;
            return DialectDetector.getJSDialectOfFile((PsiFile)parent);
        }
        if (!element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            DialectDetector.$$$reportNull$$$0(11);
        }
        return javascriptLanguage;
    }

    @NotNull
    private static Language getJSDialectOfFile(@NotNull PsiFile file2) {
        JSLanguageDialect dialect;
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(12);
        }
        JSLanguageDialect jSLanguageDialect = (dialect = DialectDetector.getJSDialectOfFileOrNull(file2)) != null ? dialect : JavascriptLanguage.INSTANCE;
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(13);
        }
        return jSLanguageDialect;
    }

    @Nullable
    private static JSLanguageDialect getJSDialectOfFileOrNull(@NotNull PsiFile file2) {
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(14);
        }
        return (JSLanguageDialect)((Object)CachedValuesManager.getManager((Project)file2.getProject()).getParameterizedCachedValue((UserDataHolder)file2, KEY_DIALECT_HOLDER, PROVIDER, false, (Object)file2));
    }

    @Nullable
    public static JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(15);
        }
        return (language = DialectDetector.languageOfElement(element)) instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    public static boolean isTypeScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(16);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isTypeScript;
    }

    public static boolean isActionScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(17);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == DialectOptionHolder.ECMA_4;
    }

    public static boolean isJavaScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(18);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) == null || dialect.isJavaScript();
    }

    public static boolean isTemplateJavaScript(@NotNull PsiElement element) {
        String languageId;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(19);
        }
        return "VueJS".equals(languageId = DialectDetector.languageOfElement(element).getID()) || "AngularJS".equals(languageId);
    }

    public static boolean isJavaScriptFamily(@NotNull PsiElement element) {
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(20);
        }
        return !DialectDetector.isActionScript(element);
    }

    public static boolean isCoffeeScript(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(21);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isCoffeeScript;
    }

    public static boolean isES6(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(22);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isECMA6;
    }

    public static boolean isES6OrES6Target(@NotNull PsiElement element) {
        TypeScriptConfig config2;
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(23);
        }
        if ((dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isTypeScript && (config2 = TypeScriptConfigService.Provider.get(element.getProject()).getPreferableConfig(element.getContainingFile().getVirtualFile())) != null) {
            return config2.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6 || config2.getLanguageTarget() == TypeScriptConfig.LanguageTarget.NEXT;
        }
        return dialect != null && dialect.isECMA6;
    }

    public static boolean isFlow(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(24);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isFlow;
    }

    public static boolean isTypeScriptOrFlow(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(25);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && (dialect.isTypeScript || dialect.isFlow);
    }

    public static boolean isJSX(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            DialectDetector.$$$reportNull$$$0(26);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && dialect.isJSX;
    }

    @NotNull
    public static Language getJSLanguage(@NotNull VirtualFile file2) {
        FileType type;
        Language language;
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(27);
        }
        Language language2 = language = (type = file2.getFileType()) instanceof LanguageFileType ? ((LanguageFileType)type).getLanguage() : null;
        Object object = JavaScriptSupportLoader.GWT_DIALECT.getFileExtension().equals(file2.getExtension()) ? JavaScriptSupportLoader.GWT_DIALECT : (language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE);
        if (object == null) {
            DialectDetector.$$$reportNull$$$0(28);
        }
        return object;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file2, @NotNull Project project) {
        JSLanguageDialect jsDialect;
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(29);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(30);
        }
        if ((jsDialect = DialectDetector.getLanguageDialectForJSFile(file2, project)) != null) {
            return jsDialect;
        }
        Language language = DialectDetector.getJSLanguage(file2);
        if (language instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language;
        }
        language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
    }

    @Nullable
    public static JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file2, @NotNull Project project) {
        FileType type;
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(31);
        }
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(32);
        }
        if ((type = SubstitutedFileType.substituteFileType((VirtualFile)file2, (FileType)file2.getFileType(), (Project)project)) instanceof SubstitutedFileType) {
            type = ((SubstitutedFileType)type).getFileType();
        }
        if (JAVASCRIPT_FILE_TYPES.contains(type)) {
            JSLanguageLevel configuredJSLevel = DialectDetector.getConfiguredJSLevel(file2, project);
            JSLanguageDialect fileSpecialLanguage = type instanceof JavaScriptDialectFileType ? ((JavaScriptDialectFileType)type).getDefaultLanguage() : null;
            return DialectDetector.getCombinedLanguageDialect(configuredJSLevel, fileSpecialLanguage);
        }
        return null;
    }

    @NotNull
    public static JSLanguageDialect getCombinedLanguageDialect(@NotNull JSLanguageLevel configuredLanguage, @Nullable JSLanguageDialect fileSpecialLanguage) {
        if (configuredLanguage == null) {
            DialectDetector.$$$reportNull$$$0(33);
        }
        if (fileSpecialLanguage == null || configuredLanguage.getDialect().isAtLeast(fileSpecialLanguage)) {
            JSLanguageDialect jSLanguageDialect = configuredLanguage.getDialect();
            if (jSLanguageDialect == null) {
                DialectDetector.$$$reportNull$$$0(34);
            }
            return jSLanguageDialect;
        }
        JSLanguageDialect jSLanguageDialect = fileSpecialLanguage;
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(35);
        }
        return jSLanguageDialect;
    }

    @NotNull
    public static JSLanguageLevel getConfiguredJSLevel(@Nullable PsiFile file2, @NotNull Project project) {
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(36);
        }
        VirtualFile virtualFile = file2 != null ? file2.getViewProvider().getVirtualFile() : null;
        return DialectDetector.getConfiguredJSLevel(virtualFile, project);
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file2) {
        if (file2 == null) {
            DialectDetector.$$$reportNull$$$0(37);
        }
        return DialectDetector.getConfiguredJSVersion(file2.getViewProvider().getVirtualFile(), file2.getProject());
    }

    @NotNull
    public static JSLanguageLevel getConfiguredJSLevel(@Nullable VirtualFile file2, @NotNull Project project) {
        VirtualFile originalFile;
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(38);
        }
        if (file2 instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file2).getOriginalFile()) != null) {
            file2 = originalFile;
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        JSLanguageLevel configuredLevel = null;
        if (file2 != null) {
            VirtualFile parent = file2.getParent();
            configuredLevel = (JSLanguageLevel)((Object)KEY.get((UserDataHolder)parent));
        }
        if (configuredLevel == null) {
            JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
            configuredLevel = configuration != null ? configuration.getLanguageLevel() : JSLanguageLevel.DEFAULT;
        }
        JSLanguageLevel jSLanguageLevel = configuredLevel;
        if (jSLanguageLevel == null) {
            DialectDetector.$$$reportNull$$$0(39);
        }
        return jSLanguageLevel;
    }

    @NotNull
    public static JSLanguageDialect getConfiguredJSVersion(@Nullable VirtualFile file2, @NotNull Project project) {
        if (project == null) {
            DialectDetector.$$$reportNull$$$0(40);
        }
        JSLanguageDialect jSLanguageDialect = DialectDetector.getConfiguredJSLevel(file2, project).getDialect();
        if (jSLanguageDialect == null) {
            DialectDetector.$$$reportNull$$$0(41);
        }
        return jSLanguageDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 27: 
            case 29: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 30: 
            case 32: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuredLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/DialectDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "languageOfElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateJSLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSDialectOfFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSLanguage";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedLanguageDialect";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredJSLevel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredJSVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfFileNoCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "languageOfElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateJSLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJSDialectOfFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJSDialectOfFileOrNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "languageDialectOfElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScript";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isActionScript";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScript";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateJavaScript";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFamily";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCoffeeScript";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isES6";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isES6OrES6Target";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFlow";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptOrFlow";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isJSX";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialect";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialectForJSFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedLanguageDialect";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredJSLevel";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredJSVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 28: 
            case 34: 
            case 35: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

