/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6AddImportExecutor {
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final Project myProject;

    public ES6AddImportExecutor(@Nullable Editor editor, @NotNull PsiElement place) {
        if (place == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myPlace = place;
        this.myProject = place.getProject();
    }

    public final void execute(@NotNull String importedName, @NotNull JSElement elementToImport) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(2);
        }
        PsiFile file2 = this.myPlace.getContainingFile();
        if (!this.executeImpl(importedName, elementToImport)) {
            TypeScriptAutoImportUtil.showError(this.myProject, this.myEditor);
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
    }

    private boolean executeForNamespaceAndModuleImport(@NotNull String importedName, @NotNull JSElement elementToImport) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(3);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(4);
        }
        PsiElement current = elementToImport.getParent();
        PsiElement lastElement = null;
        while (current != null) {
            PsiElement parent = current.getParent();
            if (parent != null && ES6PsiUtil.isExternalModule(parent)) {
                lastElement = current;
                break;
            }
            current = parent;
        }
        if (!(lastElement instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)lastElement;
        String moduleName = element.getName();
        if (moduleName == null) {
            return false;
        }
        if (!this.hasImportForNamespace(element, moduleName) && !this.executeImpl(moduleName, (JSElement)element)) {
            return false;
        }
        return this.executeForImportType(importedName, elementToImport, ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE);
    }

    private boolean hasImportForNamespace(@NotNull JSQualifiedNamedElement element, @NotNull String name) {
        PsiElement scope;
        if (element == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(5);
        }
        if (name == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(6);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, false)) == null) {
            return false;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(name, this.myPlace);
        return result2.getElements().contains(element);
    }

    private boolean executeImpl(@NotNull String importedName, @NotNull JSElement elementToImport) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(7);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        JSElement placeContainer = ES6PsiUtil.getExportScope(this.myPlace);
        if (elementContainer == null || elementContainer.isEquivalentTo((PsiElement)placeContainer)) {
            return true;
        }
        ES6ImportPsiUtil.ImportExportType importType = this.getImportType(elementToImport, (PsiElement)elementContainer);
        if (importType == null) {
            return false;
        }
        return this.executeForImportType(importedName, elementToImport, importType);
    }

    @Nullable
    private static JSQualifiedName getElementNamespace(@NotNull JSElement elementToImport) {
        String name;
        PsiElement module;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(9);
        }
        if (elementToImport instanceof JSQualifiedNamedElement) {
            return ((JSQualifiedNamedElement)elementToImport).getNamespace();
        }
        if (elementToImport instanceof ES6ImportExportDeclarationPart && (module = ES6PsiUtil.findExternalModule((PsiElement)elementToImport)) instanceof TypeScriptModule && ((TypeScriptModule)module).isExternal() && !((TypeScriptModule)module).isAugmentation() && (name = ((TypeScriptModule)module).getName()) != null) {
            return JSQualifiedNameImpl.fromQualifiedName(name);
        }
        return null;
    }

    public boolean executeForImportType(@NotNull String importedName, @NotNull JSElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        String moduleOrNamespaceName;
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(10);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(11);
        }
        if (importType == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(12);
        }
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE) {
            return this.executeForNamespaceAndModuleImport(importedName, elementToImport);
        }
        JSQualifiedName namespace = ES6AddImportExecutor.getElementNamespace(elementToImport);
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        if (elementContainer == null) {
            return false;
        }
        PsiElement externalModule = null;
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE) {
            moduleOrNamespaceName = namespace == null ? importedName : namespace + "." + importedName;
        } else {
            String externalModuleName = null;
            PsiElement rawExternalModule = this.getRawExternalModule(elementToImport, (PsiElement)elementContainer, namespace);
            if (rawExternalModule == null) {
                return false;
            }
            if (rawExternalModule instanceof PsiFile) {
                PsiFile moduleFile = (PsiFile)rawExternalModule;
                JSModuleNameInfo moduleNameWithResolve = ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, moduleFile.getVirtualFile(), this.myPlace, true);
                if (moduleNameWithResolve != null) {
                    externalModuleName = moduleNameWithResolve.getPath();
                    VirtualFile module = moduleNameWithResolve.getResolvedFile();
                    externalModule = PsiManager.getInstance((Project)this.myProject).findFile(module);
                }
            } else if (rawExternalModule instanceof TypeScriptModule) {
                externalModule = rawExternalModule;
                String rawName = ((TypeScriptModule)rawExternalModule).getExternalModuleText();
                if (rawName == null) {
                    return false;
                }
                externalModuleName = ES6ImportPsiUtil.wrapWithQuotesFromSettings(StringUtil.unquoteString((String)rawName), (PsiElement)elementToImport);
            }
            if (externalModuleName == null) {
                return false;
            }
            moduleOrNamespaceName = externalModuleName;
        }
        return this.createImportOrUseExisting(importedName, elementToImport.getName(), externalModule, moduleOrNamespaceName, importType, elementToImport instanceof TypeScriptCompileTimeType);
    }

    @Nullable
    public PsiElement getRawExternalModule(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        PsiElement externalModuleForContainer;
        boolean isDefaultExport;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(13);
        }
        if (elementContainer == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(14);
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return elementToImport;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isAugmentation()) {
            return elementContainer.getParent();
        }
        boolean bl = isDefaultExport = elementToImport instanceof JSPsiElementBase && ((JSPsiElementBase)elementToImport).isExportedWithDefault();
        if (namespace == null && !isDefaultExport) {
            return elementContainer.getContainingFile();
        }
        PsiElement psiElement = externalModuleForContainer = ES6PsiUtil.isExternalModule(elementContainer) ? elementContainer : elementContainer.getParent();
        if (!ES6PsiUtil.isExternalModule(externalModuleForContainer)) {
            return null;
        }
        if (externalModuleForContainer instanceof TypeScriptModule) {
            String currentModuleName = ((TypeScriptModule)externalModuleForContainer).getExternalModuleText();
            if (currentModuleName == null) {
                return null;
            }
            return externalModuleForContainer;
        }
        return elementContainer.getContainingFile();
    }

    public boolean createImportOrUseExisting(@NotNull String importedName, @Nullable String exportedName, @Nullable PsiElement externalModule, @NotNull String quotedModuleOrNamespaceName, @NotNull ES6ImportPsiUtil.ImportExportType importType, boolean isTypeContext) {
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(15);
        }
        if (quotedModuleOrNamespaceName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(16);
        }
        if (importType == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(17);
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, importType, true, isTypeContext){

            @Override
            public boolean shouldCreateImportTypeOnly() {
                if (!this.isTypeContext()) {
                    return false;
                }
                TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(ES6AddImportExecutor.this.myPlace.getContainingFile());
                return config2 != null && config2.importsNotUsedAsValues() == TypeScriptConfig.ImportsValues.ERROR;
            }
        };
        return this.createImportOrUseExisting(info, externalModule, quotedModuleOrNamespaceName);
    }

    public boolean createImportOrUseExisting(@NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @Nullable PsiElement externalModule, @NotNull String quotedModuleOrNamespaceName) {
        ES6ImportPsiUtil.ImportExportType type;
        PsiElement scope;
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(18);
        }
        if (quotedModuleOrNamespaceName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(19);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, (type = info.getImportType()) != ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE)) == null) {
            return false;
        }
        if (this.tryToUseExistingImport(info, quotedModuleOrNamespaceName, externalModule, scope)) {
            return true;
        }
        PsiElement importPsi = this.createTypeScriptOrES6Import(quotedModuleOrNamespaceName, info);
        if (importPsi == null) {
            return false;
        }
        if (importPsi instanceof ES6ImportDeclaration && type != ES6ImportPsiUtil.ImportExportType.BARE) {
            ES6CreateImportUtil.findPlaceAndInsertES6Import(scope, importPsi, StringUtil.unquoteString((String)quotedModuleOrNamespaceName), this.myEditor);
        } else {
            ES6CreateImportUtil.findPlaceAndInsertAnyImport(scope, importPsi, this.myEditor);
        }
        return true;
    }

    @Nullable
    private PsiElement createTypeScriptOrES6Import(@NotNull String externalModuleName, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info) {
        if (externalModuleName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(20);
        }
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(21);
        }
        if (info.getImportType().isES6() || DialectDetector.isJavaScript(this.myPlace)) {
            return ES6ImportPsiUtil.createImportOrExport(this.myPlace, info, externalModuleName);
        }
        return TypeScriptAutoImportUtil.createTypeScriptImport(this.myPlace, info, externalModuleName);
    }

    @Nullable
    public ES6ImportPsiUtil.ImportExportType getImportType(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer) {
        TypeScriptModule container;
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(22);
        }
        if (elementContainer == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(23);
        }
        JSQualifiedName namespace = ES6AddImportExecutor.getElementNamespace(elementToImport);
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elementToImport instanceof ES6ExportSpecifier) {
            return ((ES6ExportSpecifier)elementToImport).isExportDefault() ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
        }
        if (elementContainer instanceof TypeScriptModule && (container = (TypeScriptModule)elementContainer).isAugmentation()) {
            if (TypeScriptAutoImportUtil.isSelfExportedAugmentationModule(container)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            return null;
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer);
        if (exportAssignment instanceof TypeScriptExportAssignment) {
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(this.myPlace.getContainingFile());
            if (config2 != null && config2.allowSyntheticDefaultImports()) {
                return ES6ImportPsiUtil.ImportExportType.DEFAULT;
            }
            if (elementToImport instanceof TypeScriptModule) {
                return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
            }
            return ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT;
        }
        if (namespace != null && elementContainer instanceof TypeScriptModule && !ES6PsiUtil.isExternalModule(elementContainer)) {
            PsiElement module = ES6PsiUtil.findExternalModule(elementContainer);
            if (module == null) {
                return ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE;
            }
            JSExportAssignment externalModuleExportAssignment = TypeScriptAutoImportUtil.getExportAssignment(module);
            if (!(externalModuleExportAssignment instanceof TypeScriptExportAssignment) || elementContainer.getParent() != module) {
                return ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE;
            }
        }
        if (elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault()) {
            return ES6ImportPsiUtil.ImportExportType.DEFAULT;
        }
        ES6ImportPsiUtil.ImportExportType resultKind = ES6ImportPsiUtil.ImportExportType.DEFAULT;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (!(elementToImport.getParent() instanceof JSExportAssignment) && attributeList != null && elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExported()) {
                resultKind = ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
        }
        return resultKind;
    }

    public boolean tryToUseExistingImport(@NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @NotNull String quotedModuleOrNamespaceName, @Nullable PsiElement externalModule, @NotNull PsiElement scope) {
        ES6ImportExportDeclaration grandParent;
        PsiElement parent;
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(24);
        }
        if (quotedModuleOrNamespaceName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(26);
        }
        if ((parent = this.myPlace.getParent()) instanceof ES6ImportExportDeclarationPart && (grandParent = ((ES6ImportExportDeclarationPart)parent).getDeclaration()) instanceof ES6ImportDeclaration && grandParent.getFromClause() == null) {
            ES6CreateImportUtil.insertFromClause((ES6ImportExportDeclarationPart)parent, grandParent, quotedModuleOrNamespaceName);
            return true;
        }
        ES6ImportPsiUtil.ImportExportType importType = info.getImportType();
        if (JSCodeStyleSettings.isMergeImports(this.myPlace) && importType.isES6()) {
            ES6ImportDeclaration possibleImport = ES6ImportPsiUtil.findExistingES6Import(scope, externalModule, quotedModuleOrNamespaceName, info);
            return possibleImport != null && ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(possibleImport, info);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContainer";
                break;
            }
            case 16: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedModuleOrNamespaceName";
                break;
            }
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModuleName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/actions/ES6AddImportExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeForNamespaceAndModuleImport";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasImportForNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementNamespace";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "executeForImportType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getRawExternalModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createImportOrUseExisting";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeScriptOrES6Import";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToUseExistingImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

