/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.Language;
import com.intellij.lang.css.linter.stylelint.StylelintPackage;
import com.intellij.lang.css.linter.stylelint.StylelintResultParser;
import com.intellij.lang.css.linter.stylelint.StylelintSessionData;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.css.linter.stylelint.StylelintUtil;
import com.intellij.lang.css.linter.stylelint.config.StylelintConfigFileChangeTracker;
import com.intellij.lang.css.linter.stylelint.config.StylelintUnsavedConfigFileManager;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalRunner {
    private static final Logger LOG = Logger.getInstance(StylelintExternalRunner.class);
    private static final String FORMAT_PARAMETER = "-f";
    private static final String JSON_FORMAT = "json";
    private static final String SYNTAX = "--syntax";
    private static final String STDIN_FILENAME = "--stdin-filename";
    private static final String DEFAULT_ERROR_PREFIX = "Error: ";
    private final boolean myIsOnTheFly;

    public StylelintExternalRunner(boolean isOnTheFly) {
        this.myIsOnTheFly = isOnTheFly;
    }

    public JSLinterAnnotationResult execute(JSLinterInput<StylelintState> input) {
        VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid() || fileToLint.getParent() == null) {
            return null;
        }
        try {
            boolean canRun;
            StylelintState state = input.getState();
            Project project = input.getProject();
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile workingDirectory = (VirtualFile)ReadAction.compute(() -> StylelintUtil.findWorkingDirectory(fileToLint));
            if (workingDirectory == null) {
                return null;
            }
            if (this.myIsOnTheFly) {
                ((StylelintConfigFileChangeTracker)ServiceManager.getService((Project)project, StylelintConfigFileChangeTracker.class)).startIfNeeded();
            }
            boolean bl = canRun = !this.myIsOnTheFly || (Boolean)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return false;
                }
                Collection<VirtualFile> configs = StylelintUtil.getPossibleConfigs(workingDirectory);
                return ((StylelintUnsavedConfigFileManager)ServiceManager.getService((Project)project, StylelintUnsavedConfigFileManager.class)).requestSaveIfNeeded(configs);
            }) != false;
            if (!canRun) {
                LOG.debug("Stylelint postponed because of unsaved configs");
                return null;
            }
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolveNotNull(input.getProject());
            JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(input.getProject(), interpreter, state.getStylelintPackage(), "stylelint", fileToLint);
            if (error != null) {
                return JSLinterAnnotationResult.create(input, error, null);
            }
            StylelintPackage stylelintPackage = StylelintPackage.fromNodePackage(input.getProject(), state.getStylelintPackage());
            StylelintSessionData sessionData = new StylelintSessionData(interpreter, stylelintPackage, workingDirectory, fileToLint, input.getFileContent(), StylelintExternalRunner.suggestSyntax(input.getPsiFile()));
            return StylelintExternalRunner.stylelint(input, sessionData);
        }
        catch (ExecutionException e) {
            return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
        }
    }

    @Nullable
    private static String suggestSyntax(@NotNull PsiFile file2) {
        if (file2 == null) {
            StylelintExternalRunner.$$$reportNull$$$0(0);
        }
        if (file2 instanceof StylesheetFile) {
            Language language = file2.getLanguage();
            String languageId = language.getID();
            if ("LESS".equals(languageId)) {
                return "less";
            }
            if ("SCSS".equals(languageId)) {
                return "scss";
            }
        }
        return null;
    }

    private static JSLinterAnnotationResult stylelint(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(1);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(2);
        }
        long startNanoTime = System.nanoTime();
        JSLinterAnnotationResult result2 = StylelintExternalRunner.runProcess(input, sessionData);
        StylelintExternalRunner.logEnd(startNanoTime, result2.getErrors().size());
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private static JSLinterAnnotationResult runProcess(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        block13: {
            if (input == null) {
                StylelintExternalRunner.$$$reportNull$$$0(3);
            }
            if (sessionData == null) {
                StylelintExternalRunner.$$$reportNull$$$0(4);
            }
            commandLine = StylelintExternalRunner.createCommandLine(sessionData);
            StylelintExternalRunner.logStart(sessionData, commandLine);
            processHandler = new KillableColoredProcessHandler(commandLine, false);
            try {
                StylelintExternalRunner.writeFileContentToStdin(processHandler, sessionData, commandLine.getCharset());
            }
            catch (IOException e) {
                StylelintExternalRunner.LOG.warn((Throwable)e);
                output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
                output.appendStderr("\n" + e.getMessage() + "\n");
                return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, commandLine, (ProcessHandler)processHandler, output);
            }
            output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
            stderr = output.getStderr();
            if (!StringUtil.isEmptyOrSpaces((String)stderr)) {
                return StylelintExternalRunner.createFileLevelWarning(stderr, input, commandLine, (ProcessHandler)processHandler, output);
            }
            stylelintResultParser = new StylelintResultParser();
            stdout = output.getStdout();
            errors = stylelintResultParser.parse(stdout);
            if (errors != null) ** GOTO lbl34
            if (!StringUtil.isEmptyOrSpaces((String)stdout)) break block13;
            v0 = JSLinterAnnotationResult.createLinterResult(input, Collections.emptyList(), null);
            if (v0 == null) {
                StylelintExternalRunner.$$$reportNull$$$0(5);
            }
            return v0;
        }
        return StylelintExternalRunner.createFileLevelWarning(stdout, input, commandLine, (ProcessHandler)processHandler, output);
lbl34:
        // 1 sources

        v1 = JSLinterAnnotationResult.createLinterResult(input, errors, null);
        if (v1 == null) {
            StylelintExternalRunner.$$$reportNull$$$0(6);
        }
        return v1;
        {
            catch (Exception e) {
                try {
                    return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, commandLine, (ProcessHandler)processHandler, output);
                }
                catch (ExecutionException e) {
                    return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
                }
            }
        }
    }

    private static void writeFileContentToStdin(@NotNull KillableColoredProcessHandler processHandler, @NotNull StylelintSessionData sessionData, @NotNull Charset charset) throws IOException {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(7);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(8);
        }
        if (charset == null) {
            StylelintExternalRunner.$$$reportNull$$$0(9);
        }
        String content = sessionData.getFileToLintContent();
        try (OutputStream stdin = Objects.requireNonNull(processHandler.getProcessInput());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file content to stdin\n\n" + content, e);
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull StylelintSessionData sessionData) throws ExecutionException {
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(10);
        }
        File workDirectory = VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDir());
        GeneralCommandLine commandLine = new GeneralCommandLine().withCharset(StandardCharsets.UTF_8).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(workDirectory);
        sessionData.getStylelintPackage().addMainEntryJsFile(commandLine, sessionData.getInterpreter());
        commandLine.addParameters(new String[]{FORMAT_PARAMETER, JSON_FORMAT});
        if (sessionData.getSyntax() != null) {
            commandLine.withParameters(new String[]{SYNTAX, sessionData.getSyntax()});
        }
        String pathToLint = FileUtil.toSystemDependentName((String)sessionData.getFileToLint().getPath());
        String relativePath = FileUtil.getRelativePath((String)workDirectory.getAbsolutePath(), (String)pathToLint, (char)File.separatorChar);
        if (relativePath != null) {
            commandLine.withParameters(new String[]{STDIN_FILENAME, relativePath});
        }
        NodeCommandLineConfigurator.find(sessionData.getInterpreter()).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(12);
        }
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        catcher.run();
        ProcessOutput processOutput = catcher.getOutput();
        if (processOutput == null) {
            StylelintExternalRunner.$$$reportNull$$$0(13);
        }
        return processOutput;
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(14);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(15);
        }
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(StringUtil.decapitalize((String)message)), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(16);
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler processHandler, @NotNull ProcessOutput output) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(17);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(18);
        }
        if (commandLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(19);
        }
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(20);
        }
        if (output == null) {
            StylelintExternalRunner.$$$reportNull$$$0(21);
        }
        JsqtViewProcessOutputAction detailsAction = new JsqtViewProcessOutputAction("Failed to lint " + input.getVirtualFile().getPath(), JavaScriptLanguageIcons.FileTypes.Stylelint, commandLine, processHandler, output);
        String errorMessage = StringUtil.splitByLines((String)message)[0];
        errorMessage = StringUtil.trimStart((String)errorMessage, (String)DEFAULT_ERROR_PREFIX);
        errorMessage = StringUtil.decapitalize((String)errorMessage);
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(errorMessage, detailsAction).withIcon(JavaScriptLanguageIcons.FileTypes.Stylelint), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(22);
        }
        return jSLinterAnnotationResult;
    }

    private static void logStart(@NotNull StylelintSessionData sessionData, @NotNull GeneralCommandLine commandLine) {
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(23);
        }
        if (commandLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(24);
        }
        String stylelintVersion = sessionData.getStylelintPackage().getVersionStr();
        String fileToLintPath = sessionData.getFileToLint().getPath();
        LOG.debug(String.format("Running stylelint@%s at %s$ %s", stylelintVersion, fileToLintPath, commandLine.getCommandLineString()));
    }

    private static void logEnd(long startTime, int resultSize) {
        long durationMillis = TimeoutUtil.getDurationMillis((long)startTime);
        LOG.debug(String.format(CssBundle.message((String)"css.stylelint.message.prefix", (Object[])new Object[0]) + " done in %d ms, found %d problems", durationMillis, resultSize));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionData";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner";
                break;
            }
            case 7: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "captureOutput";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLevelWarning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestSyntax";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stylelint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeFileContentToStdin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "captureOutput";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFileLevelWarning";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "logStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

