/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.actionscript.parsing.ActionScriptParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ActionScriptStatementParser
extends StatementParser<ActionScriptParser> {
    protected ActionScriptStatementParser(ActionScriptParser parser) {
        super(parser);
    }

    @Override
    public void parseSourceElement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.PACKAGE_KEYWORD) {
            this.parsePackage();
        } else if (tokenType == JSTokenTypes.AT) {
            this.builder.advanceLexer();
            this.parseAttributeBody();
        } else {
            super.parseSourceElement();
        }
    }

    private void parseAttributeBody() {
        PsiBuilder.Marker attribute = this.builder.mark();
        if (!ActionScriptStatementParser.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.identifier")) {
            attribute.drop();
            return;
        }
        ((FunctionParser)((ActionScriptParser)this.myJavaScriptParser).getFunctionParser()).parseAttributeBody();
        attribute.done(JSStubElementTypes.ATTRIBUTE);
    }

    @Override
    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
        return true;
    }

    @Override
    protected void doParseStatement(boolean canHaveClasses) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.DEFAULT_KEYWORD) {
            this.parseDefaultNsStatement();
            return;
        }
        if (firstToken == JSTokenTypes.IMPORT_KEYWORD) {
            this.parseImportStatement();
            return;
        }
        if (firstToken == JSTokenTypes.USE_KEYWORD) {
            this.parseUseNamespaceDirective();
            return;
        }
        if (firstToken == JSTokenTypes.GOTO_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1))) {
            PsiBuilder.Marker statement = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            this.checkForSemicolon();
            statement.done(ActionScriptElementTypes.GOTO_STATEMENT);
            return;
        }
        super.doParseStatement(canHaveClasses);
    }

    private void parseDefaultNsStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
        PsiBuilder.Marker statementMarker = this.builder.mark();
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER && "xml".equals(this.builder.getTokenText())) {
            this.builder.advanceLexer();
            if (ActionScriptStatementParser.checkMatches(this.builder, JSTokenTypes.NAMESPACE_KEYWORD, "javascript.parser.message.expected.namespace") && ActionScriptStatementParser.checkMatches(this.builder, JSTokenTypes.EQ, "javascript.parser.message.expected.equal")) {
                ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseExpression();
            }
        } else {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.xml", (Object[])new Object[0]));
        }
        marker.done(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
        this.checkForSemicolon();
        statementMarker.done(JSElementTypes.EXPRESSION_STATEMENT);
    }

    @Override
    protected PsiBuilder.Marker startAttributeListOwner() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (!this.isBlockBodyContext()) {
            PsiBuilder.Marker modifierListMarker = this.builder.mark();
            modifierListMarker.done(((FunctionParser)((ActionScriptParser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
        }
        return marker;
    }

    @Override
    public IElementType getVariableElementType() {
        return this.isBlockBodyContext() ? ActionScriptElementTypes.LOCAL_VARIABLE : ActionScriptElementTypes.VARIABLE;
    }

    public void parseUseNamespaceDirective() {
        PsiBuilder.Marker useNSStatement = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.NAMESPACE_KEYWORD) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.namespace", (Object[])new Object[0]));
        } else {
            this.builder.advanceLexer();
            if (!((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
            }
            while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) continue;
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
                break;
            }
        }
        this.checkForSemicolon();
        useNSStatement.done(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
    }

    private void parsePackage() {
        PsiBuilder.Marker _package = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
            ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.name.or.lbrace", (Object[])new Object[0]));
        } else {
            this.parseBlockOrFunctionBody(StatementParser.BlockType.PACKAGE_OR_CLASS_BODY);
        }
        _package.done(JSStubElementTypes.PACKAGE_STATEMENT);
    }

    private void parseImportStatement() {
        PsiBuilder.Marker importStatement = this.builder.mark();
        try {
            this.builder.advanceLexer();
            PsiBuilder.Marker nsAssignment = this.builder.mark();
            if (!((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName(true)) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
                nsAssignment.drop();
                return;
            }
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                if (!((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
                }
                nsAssignment.done((IElementType)JSElementTypes.ASSIGNMENT_EXPRESSION);
            } else {
                nsAssignment.drop();
            }
            this.checkForSemicolon();
        }
        finally {
            importStatement.done(JSStubElementTypes.IMPORT_STATEMENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseClassOrInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            ActionScriptStatementParser.$$$reportNull$$$0(0);
        }
        String methodEmptiness = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
        try {
            IElementType tokenType = this.builder.getTokenType();
            LOG.assertTrue(JSTokenTypes.CLASS_KEYWORD == tokenType || JSTokenTypes.INTERFACE_KEYWORD == tokenType);
            if (this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD) {
                this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)"a");
                this.builder.putUserData(withinInterfaceKey, (Object)"");
            }
            this.builder.advanceLexer();
            if (!((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
            }
            if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
                this.parseReferenceList((IElementType)JSStubElementTypes.DEFAULT_EXTENDS_LIST);
            }
            if (this.builder.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
                this.parseReferenceList((IElementType)JSStubElementTypes.IMPLEMENTS_LIST);
            }
            this.parseBlockOrFunctionBody(StatementParser.BlockType.PACKAGE_OR_CLASS_BODY);
            clazz.done((IElementType)JSStubElementTypes.CLASS);
            clazz.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodEmptiness);
            this.builder.putUserData(withinInterfaceKey, null);
        }
    }

    @Override
    protected IElementType getClassElementType() {
        return JSStubElementTypes.CLASS;
    }

    @Override
    protected IElementType getClassExtendListElementType() {
        return JSStubElementTypes.DEFAULT_EXTENDS_LIST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/actionscript/parsing/ActionScriptStatementParser", "parseClassOrInterfaceNoMarker"));
    }
}

