/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageRef {
    private final String myReferenceName;
    private final NodePackage myPkg;

    private NodePackageRef(@Nullable String referenceName, @Nullable NodePackage pkg) {
        if (referenceName == null && pkg == null) {
            throw new AssertionError((Object)"Both parameters are null");
        }
        if (referenceName != null && pkg != null) {
            throw new AssertionError((Object)"Both parameters are not-null");
        }
        this.myReferenceName = referenceName;
        this.myPkg = pkg;
    }

    public boolean isConstant() {
        return this.myPkg != null;
    }

    @Nullable
    public String getReferenceName() {
        return this.myReferenceName;
    }

    @Nullable
    public NodePackage getConstantPackage() {
        return this.myPkg;
    }

    @NotNull
    public String getIdentifier() {
        String windowsPath;
        if (this.myReferenceName != null) {
            String string = this.myReferenceName;
            if (string == null) {
                NodePackageRef.$$$reportNull$$$0(0);
            }
            return string;
        }
        NodePackage pkg = Objects.requireNonNull(this.myPkg);
        if (SystemInfo.isWindows && ((windowsPath = pkg.getSystemDependentPath()).startsWith("\\") || FileUtil.isWindowsAbsolutePath((String)windowsPath))) {
            String string = windowsPath;
            if (string == null) {
                NodePackageRef.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = pkg.getSystemIndependentPath();
        if (string == null) {
            NodePackageRef.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myReferenceName != null ? this.myReferenceName : Objects.requireNonNull(this.myPkg).getPresentablePath();
        if (string == null) {
            NodePackageRef.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static NodePackageRef create(@NotNull String referenceName) {
        if (referenceName == null) {
            NodePackageRef.$$$reportNull$$$0(4);
        }
        return new NodePackageRef(referenceName, null);
    }

    public static NodePackageRef create(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NodePackageRef.$$$reportNull$$$0(5);
        }
        return new NodePackageRef(null, pkg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackageRef ref = (NodePackageRef)o;
        return Objects.equals(this.myReferenceName, ref.myReferenceName) && Objects.equals(this.myPkg, ref.myPkg);
    }

    public int hashCode() {
        int result2 = this.myReferenceName != null ? this.myReferenceName.hashCode() : 0;
        result2 = 31 * result2 + (this.myPkg != null ? this.myPkg.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.myReferenceName != null ? this.myReferenceName : "-> " + Objects.requireNonNull(this.myPkg).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

