/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NodePackage {
    @NotNull
    private final String mySystemDependentPath;
    @Nullable
    private File myDir;

    public NodePackage(@NotNull String path) {
        if (path == null) {
            NodePackage.$$$reportNull$$$0(0);
        }
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEmptyPath() {
        return this.mySystemDependentPath.isEmpty();
    }

    @NotNull
    public String getName() {
        int ind = this.mySystemDependentPath.lastIndexOf(File.separatorChar);
        if (ind >= 0) {
            int prev = this.mySystemDependentPath.lastIndexOf(File.separatorChar, ind - 1);
            if (prev >= 0 && this.mySystemDependentPath.charAt(prev + 1) == '@') {
                String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath.substring(prev + 1));
                if (string == null) {
                    NodePackage.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.mySystemDependentPath.substring(ind + 1);
            if (string == null) {
                NodePackage.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean nameMatches(@NotNull String packageName) {
        String path;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(6);
        }
        return (path = this.getSystemIndependentPath()).endsWith(packageName) && StringUtil.isChar((CharSequence)path, (int)(path.length() - packageName.length() - 1), (char)'/');
    }

    @Nullable
    public SemVer getVersion() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        return NodePackageVersionUtil.getPackageVersion(this.getDir());
    }

    @Nullable
    public SemVer getVersion(@Nullable Project project) {
        return this.getVersion();
    }

    @NotNull
    public Promise<SemVer> getVersionPromise(@Nullable Project project) {
        Promise promise = Promises.resolvedPromise((Object)this.getVersion(project));
        if (promise == null) {
            NodePackage.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @NotNull
    private File getDir() {
        File file2 = this.myDir;
        if (file2 == null) {
            this.myDir = file2 = new File(this.mySystemDependentPath);
        }
        File file3 = file2;
        if (file3 == null) {
            NodePackage.$$$reportNull$$$0(8);
        }
        return file3;
    }

    @NotNull
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                NodePackage.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodePackage.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isValid() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return false;
        }
        File dir = this.getDir();
        return dir.isAbsolute() && dir.isDirectory();
    }

    public boolean isValid(@NotNull Project project) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(12);
        }
        return this.isValid();
    }

    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return "Unspecified " + packageName + " package";
        }
        File dir = this.getDir();
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            return "Invalid " + packageName + " package: no such directory";
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        String message;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(14);
        }
        if ((message = this.getErrorMessage(packageName)) != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    @Nullable
    public String getAbsolutePackagePathToRequire(@NotNull Project project) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(15);
        }
        return this.getSystemDependentPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(16);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(17);
        }
        List<NodePackage> packages = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, null);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull List<String> packageNames, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(18);
        }
        if (packageNames == null) {
            NodePackage.$$$reportNull$$$0(19);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageNames).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(20);
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(21);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(22);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageName).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(23);
        }
        return nodePackage;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }

    @Nullable
    public File findBinFile() {
        return this.findBinFile(this.getName(), null);
    }

    @Nullable
    public File findBinFile(@NotNull String executableName, @Nullable String failoverBinRelativePath) {
        if (executableName == null) {
            NodePackage.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        return NodePackage.findBinFile(this.getDir(), executableName, failoverBinRelativePath);
    }

    @Nullable
    public static File findBinFile(@NotNull File packageDir, @NotNull String executableName, @Nullable String failoverBinRelativePath) {
        if (packageDir == null) {
            NodePackage.$$$reportNull$$$0(25);
        }
        if (executableName == null) {
            NodePackage.$$$reportNull$$$0(26);
        }
        File packageJsonFile = new File(packageDir, "package.json");
        File binFile = null;
        if (packageJsonFile.isFile()) {
            VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(packageJsonFile);
            String binPath = vf != null ? PackageJsonData.getOrCreate(vf).getBinPath(executableName) : null;
            File file2 = binFile = binPath != null ? new File(packageDir, binPath) : null;
            if (binFile != null) {
                binFile = binFile.toPath().normalize().toFile();
            }
        }
        if (!(binFile != null && binFile.isFile() || failoverBinRelativePath == null)) {
            binFile = new File(packageDir, failoverBinRelativePath);
        }
        return binFile != null && binFile.isFile() ? binFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDependentPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionPromise";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDir";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreferredPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nameMatches";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateForRunConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePackagePathToRequire";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPackage";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredPackage";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

