/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.reference.NodePathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeModuleManager {
    private final Project myProject;
    private final NodePathManager myNodePathManager;
    private final NodeCoreLibraryManager myCoreLibraryManager;

    public NodeModuleManager(@NotNull Project project) {
        if (project == null) {
            NodeModuleManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myNodePathManager = new NodePathManager(project);
        this.myCoreLibraryManager = NodeCoreLibraryManager.getInstance(project);
    }

    @NotNull
    public static NodeModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeModuleManager.$$$reportNull$$$0(1);
        }
        NodeModuleManager nodeModuleManager = (NodeModuleManager)ServiceManager.getService((Project)project, NodeModuleManager.class);
        if (nodeModuleManager == null) {
            NodeModuleManager.$$$reportNull$$$0(2);
        }
        return nodeModuleManager;
    }

    private void collectCoreModules(@NotNull VirtualFile requester, @NotNull Map<String, CompletionModuleInfo> modules) {
        if (requester == null) {
            NodeModuleManager.$$$reportNull$$$0(3);
        }
        if (modules == null) {
            NodeModuleManager.$$$reportNull$$$0(4);
        }
        if (this.myCoreLibraryManager.isAssociatedWithNodeCoreLibrary(requester)) {
            NodeCoreLibraryManager coreLibraryManager = NodeCoreLibraryManager.getInstance(this.myProject);
            Collection<String> coreModuleNames = coreLibraryManager.listCoreModuleNames();
            for (String coreModuleName : coreModuleNames) {
                modules.put(coreModuleName, new CompletionModuleInfo(coreModuleName, coreLibraryManager.findCoreModuleFileByName(coreModuleName), ModuleType.CORE_MODULE));
            }
        }
    }

    @NotNull
    public Collection<CompletionModuleInfo> collectVisibleNodeModules(@Nullable VirtualFile requester) {
        HashMap<String, CompletionModuleInfo> modules = new HashMap<String, CompletionModuleInfo>();
        if (requester != null) {
            this.collectCoreModules(requester, modules);
        }
        NodeModuleSearchUtil.collectVisibleNodeModules(modules, this.myProject, requester);
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            NodeModuleManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        GlobalSearchScope scope;
        if (requiredModuleName == null) {
            NodeModuleManager.$$$reportNull$$$0(6);
        }
        NodeCoreLibraryManager coreLibraryManager = NodeCoreLibraryManager.getInstance(this.myProject);
        VirtualFile resolvedModuleFile = coreLibraryManager.findCoreModuleFileByName(requiredModuleName);
        if (requester != null && resolvedModuleFile != null && !(scope = ResolveScopeManager.getInstance((Project)this.myProject).getDefaultResolveScope(requester)).contains(resolvedModuleFile)) {
            resolvedModuleFile = null;
        }
        if (resolvedModuleFile != null) {
            return new ResolvedModuleInfo(resolvedModuleFile, ModuleType.CORE_MODULE);
        }
        List<VirtualFile> nodePathFolders = this.myNodePathManager.getNodePaths(requester);
        return NodeModuleSearchUtil.resolveModule(requiredModuleName, requester, nodePathFolders, true, this.myProject);
    }

    @Deprecated
    public void dropNodePathCache() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodeModuleManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodeModuleManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleNodeModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectCoreModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

