/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonSeveralFilesAction;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PackageJsonUpdateNotifier.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Dependencies from package.json", NotificationDisplayType.STICKY_BALLOON, false, null);
    private static final String DISMISSED = "dismissed";
    private static final long MERGING_DELAY_MILLIS = 1000L;
    private final Project myProject;
    private final Set<VirtualFile> myDismissedFiles;
    private final Set<VirtualFile> myOpenedPackageJsonFiles;
    private final Map<VirtualFile, Notification> myShownNotifications;
    private final Alarm mySchedulingAlarm;
    private final BlockingQueue<VirtualFile> myScheduledPackageJsonFiles;

    public PackageJsonUpdateNotifier(@NotNull Project project) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(0);
        }
        this.myDismissedFiles = Collections.synchronizedSet(new HashSet());
        this.myOpenedPackageJsonFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.myShownNotifications = ContainerUtil.createWeakValueMap();
        this.myScheduledPackageJsonFiles = new LinkedBlockingQueue<VirtualFile>();
        this.myProject = project;
        this.mySchedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        PackageJsonDependenciesExternalUpdateManager.getInstance(project).addListener(new PackageJsonDependenciesExternalUpdateListener(){

            @Override
            public void externalUpdateStarted(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }

            @Override
            public void externalUpdateFinished(@Nullable VirtualFile packageJson) {
                if (packageJson != null) {
                    PackageJsonUpdateNotifier.this.scheduleProcessing(packageJson);
                }
            }
        });
    }

    private PackageJsonNotifierConfiguration getPackageJsonNotifierConfiguration() {
        return (PackageJsonNotifierConfiguration)this.myProject.getService(PackageJsonNotifierConfiguration.class);
    }

    public void onPackageJsonUpdated(@NotNull VirtualFile packageJson, @NotNull ProjectFileIndex fileIndex) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(1);
        }
        if (fileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(2);
        }
        if ((projectPackageJson = this.findProjectPackageJson(packageJson, fileIndex)) != null) {
            this.scheduleProcessing(projectPackageJson);
        }
    }

    private void scheduleProcessing(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(3);
        }
        this.scheduleProcessing(Collections.singleton(packageJson), 1000L);
    }

    @Nullable
    private VirtualFile findProjectPackageJson(@NotNull VirtualFile packageJson, @NotNull ProjectFileIndex fileIndex) {
        VirtualFile projectPackageJson;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(4);
        }
        if (fileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        if (fileIndex.isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && fileIndex.isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    private void scheduleProcessing(@NotNull Collection<VirtualFile> packageJsonFiles, long delayMillis) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed()) {
                this.mySchedulingAlarm.cancelAllRequests();
                this.myScheduledPackageJsonFiles.addAll(packageJsonFiles);
                this.mySchedulingAlarm.addRequest(() -> {
                    HashSet<VirtualFile> copy = new HashSet<VirtualFile>(this.myScheduledPackageJsonFiles.size());
                    this.myScheduledPackageJsonFiles.drainTo(copy);
                    this.processPackageJsonFiles(copy);
                }, delayMillis);
            }
        });
    }

    @NotNull
    public static PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(7);
        }
        PackageJsonUpdateNotifier packageJsonUpdateNotifier = (PackageJsonUpdateNotifier)ServiceManager.getService((Project)project, PackageJsonUpdateNotifier.class);
        if (packageJsonUpdateNotifier == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(8);
        }
        return packageJsonUpdateNotifier;
    }

    private void onProjectOpened() {
        this.getPackageJsonNotifierConfiguration().detectPackageJsonFiles().onSuccess(packageJsonFiles -> this.init((List<VirtualFile>)ImmutableList.copyOf((Collection)packageJsonFiles)));
    }

    private void init(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PackageJsonBuildFileManager.getInstance(this.myProject).setPackageJsonFilesFromConfiguration(packageJsonFiles);
            List openedPackageJsonFiles = Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()).filter(PackageJsonUtil::isPackageJsonFile).collect(Collectors.toList());
            this.scheduleProcessing(ContainerUtil.union((Collection)packageJsonFiles, openedPackageJsonFiles), 300L);
            this.myOpenedPackageJsonFiles.addAll(openedPackageJsonFiles);
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                    if (source == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (PackageJsonUtil.isPackageJsonFile(file2)) {
                        PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.add(file2);
                        PackageJsonUpdateNotifier.this.scheduleProcessing(file2);
                    }
                }

                public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                    if (source == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (file2 == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    PackageJsonUpdateNotifier.this.myOpenedPackageJsonFiles.remove(file2);
                    if (PackageJsonUtil.isPackageJsonFile(file2) && !PackageJsonUpdateNotifier.this.getPackageJsonNotifierConfiguration().isEssential(file2)) {
                        PackageJsonUpdateNotifier.this.hideNotificationLater(file2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "source";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileOpened";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }, this.myProject.getDisposed());
    }

    private void processPackageJsonFiles(@NotNull Set<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(10);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPackageJsonFiles " + packageJsonFiles);
        }
        ArrayList matchDepsPackageJsons = new ArrayList();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed() || !NodeJsInterpreterManager.getInstance(this.myProject).isInterpreterAvailable()) {
                return;
            }
            boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).isExternalUpdateRunning();
            PackageJsonNotifierConfiguration packageJsonNotifierConfiguration = this.getPackageJsonNotifierConfiguration();
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
            for (VirtualFile file2 : packageJsonFiles) {
                PackageJsonDependencies deps;
                VirtualFile nodeModulesDir;
                if (!file2.isValid() || !packageJsonNotifierConfiguration.isNpmPackageJson(file2) || this.isPackageJsonNotificationSuppressed(file2) || !PackageJsonUpdateNotifier.isNodeJsPackageJson(file2, fileIndex) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file2)) == null && !packageJsonNotifierConfiguration.isEssential(file2) && !this.myOpenedPackageJsonFiles.contains(file2) || PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)file2) || (deps = PackageJsonDependencies.getOrCreate(this.myProject, file2)) == null || deps.isEmpty()) continue;
                if (externalUpdateRunning) {
                    this.hideNotificationLater(file2);
                    continue;
                }
                if (PackageJsonUpdateNotifier.isNodeModulesUpdatingExternally(file2)) {
                    this.hideNotificationLater(file2);
                    continue;
                }
                matchDepsPackageJsons.add(file2);
            }
        });
        ArrayList<VirtualFile> toShow = new ArrayList<VirtualFile>();
        for (VirtualFile packageJson : matchDepsPackageJsons) {
            boolean depsMatched = new PackageJsonDependenciesVerifier(this.myProject, packageJson).verify();
            if (depsMatched) {
                this.hideNotificationLater(packageJson);
                continue;
            }
            toShow.add(packageJson);
        }
        this.showNotification(toShow);
    }

    private boolean isPackageJsonNotificationSuppressed(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(11);
        }
        return this.myDismissedFiles.contains(packageJson);
    }

    void enableNotificationForPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(12);
        }
        this.myDismissedFiles.remove(packageJson);
        this.scheduleProcessing(packageJson);
    }

    void enableNotificationForAllPackageJsonFiles() {
        ArrayList<VirtualFile> packageJsonFiles = new ArrayList<VirtualFile>(this.myDismissedFiles);
        this.myDismissedFiles.clear();
        this.scheduleProcessing(packageJsonFiles, 1000L);
    }

    private static boolean isNodeModulesUpdatingExternally(@NotNull VirtualFile packageJson) {
        File parent;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(13);
        }
        if ((parent = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson).getParentFile()) == null) {
            return true;
        }
        return new File(parent, "node_modules" + File.separator + ".staging").isDirectory();
    }

    private void showNotification(@NotNull List<VirtualFile> packageJsonFiles) {
        if (packageJsonFiles == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(14);
        }
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile packageJson = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem((List)packageJsonFiles));
            if (packageJsonFiles.size() > 1) {
                Notification notification2 = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + this.createFileLink(packageJson) + " and " + (packageJsonFiles.size() - 1) + " others", NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener());
                notification2.addAction((AnAction)new PackageJsonSeveralFilesAction(this.myProject, packageJsonFiles, notification2));
                notification2.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification2));
                notification2.notify(this.myProject);
            } else {
                if (this.isNotificationShownFor(packageJson)) {
                    return;
                }
                VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
                if (nodeModulesDir == null) {
                    Notification notification3 = NOTIFICATION_GROUP.createNotification("Install Dependencies", "From " + this.createFileLink(packageJson), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener());
                    notification3.addAction((AnAction)new PackageJsonGetDependenciesAction(this.myProject, packageJson, notification3));
                    notification3.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification3));
                    notification3.notify(this.myProject);
                    this.register(packageJson, notification3);
                } else {
                    Notification notification4 = NOTIFICATION_GROUP.createNotification("Update Dependencies", "From " + this.createFileLink(packageJson), NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener());
                    notification4.addAction((AnAction)new PackageJsonGetDependenciesAction(this.myProject, packageJson, notification4));
                    notification4.addAction((AnAction)new PackageJsonDismissAction(packageJsonFiles, notification4));
                    notification4.notify(this.myProject);
                    this.register(packageJson, notification4);
                }
            }
        }, this.myProject.getDisposed());
    }

    private boolean isNotificationShownFor(@NotNull VirtualFile packageJson) {
        Notification notification2;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(15);
        }
        if ((notification2 = this.myShownNotifications.get(packageJson)) != null) {
            Balloon balloon = notification2.getBalloon();
            return balloon != null && !balloon.isDisposed();
        }
        return false;
    }

    private void hideNotificationLater(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Notification notification2 = this.myShownNotifications.get(packageJson);
            if (notification2 != null && !notification2.isExpired()) {
                notification2.expire();
            }
        }, this.myProject.getDisposed());
    }

    private void register(final @NotNull VirtualFile packageJson, @NotNull Notification notification2) {
        Balloon balloon;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(17);
        }
        if (notification2 == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(18);
        }
        if ((balloon = notification2.getBalloon()) != null) {
            this.myShownNotifications.put(packageJson, notification2);
            balloon.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PackageJsonUpdateNotifier.this.myShownNotifications.remove(packageJson);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$3", "onClosed"));
                }
            });
        }
    }

    @NotNull
    private String createFileLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(19);
        }
        return PackageJsonUpdateNotifier.createLink(file2.getPath(), JsbtUtil.getRelativePath(this.myProject, file2, false));
    }

    @NotNull
    private static String createLink(@NotNull String href, @NotNull String linkText) {
        if (href == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(20);
        }
        if (linkText == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(21);
        }
        String string = "<a href='" + StringUtil.escapeXmlEntities((String)href) + "'>" + StringUtil.escapeXmlEntities((String)linkText) + "</a>";
        if (string == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static boolean isNodeJsPackageJson(@NotNull VirtualFile packageJson, @NotNull ProjectFileIndex fileIndex) {
        Module module;
        if (packageJson == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(23);
        }
        if (fileIndex == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(24);
        }
        if ((module = fileIndex.getModuleForFile(packageJson, true)) == null || module.isDisposed()) {
            return false;
        }
        ModuleType moduleType = ModuleType.get((Module)module);
        if (moduleType instanceof ModuleTypeWithWebFeatures && !((ModuleTypeWithWebFeatures)moduleType).hasWebFeatures(module)) {
            return false;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(packageJson, true);
        return contentRoot != null && !NodeModuleUtil.hasNodeModulesDirInPath(packageJson, contentRoot);
    }

    @NotNull
    public Element getState() {
        Element root = new Element("root");
        ArrayList<String> paths = new ArrayList<String>();
        for (VirtualFile file2 : this.myDismissedFiles) {
            if (!file2.isValid()) continue;
            paths.add(file2.getPath());
        }
        Collections.sort(paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)DISMISSED, paths);
        Element element = root;
        if (element == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(25);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PackageJsonUpdateNotifier.$$$reportNull$$$0(26);
        }
        ArrayList paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)DISMISSED);
        paths = new ArrayList(paths);
        ArrayList<VirtualFile> dismissedFiles = new ArrayList<VirtualFile>();
        for (String path : paths) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null || !file2.isValid() || !PackageJsonUtil.isPackageJsonFile(file2)) continue;
            dismissedFiles.add(file2);
        }
        this.myDismissedFiles.clear();
        this.myDismissedFiles.addAll(dismissedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 2: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 8: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createLink";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonUpdated";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleProcessing";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findProjectPackageJson";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 22: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processPackageJsonFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonNotificationSuppressed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "enableNotificationForPackageJson";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNodeModulesUpdatingExternally";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationShownFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hideNotificationLater";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFileLink";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLink";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNodeJsPackageJson";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyStartupActivity
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            PackageJsonUpdateNotifier.getInstance(project).onProjectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity", "runActivity"));
        }
    }

    private class MyNotificationListener
    implements NotificationListener {
        private MyNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            VirtualFile file2;
            if (notification2 == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (file2 = LocalFileSystem.getInstance().findFileByPath(event.getDescription())) != null && file2.isValid()) {
                FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.myProject).openFile(file2, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PackageJsonDismissAction
    extends DumbAwareAction {
        private final Collection<? extends VirtualFile> myPackageJsonFiles;
        private final Notification myNotification;

        PackageJsonDismissAction(@NotNull Collection<? extends VirtualFile> packageJsonFiles, Notification notification2) {
            if (packageJsonFiles == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(0);
            }
            if (notification2 == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(1);
            }
            super("Don't ask again");
            this.myPackageJsonFiles = packageJsonFiles;
            this.myNotification = notification2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PackageJsonDismissAction.$$$reportNull$$$0(2);
            }
            this.myNotification.expire();
            PackageJsonUpdateNotifier.this.myDismissedFiles.addAll(this.myPackageJsonFiles);
            NotificationGroup group = new NotificationGroup("Enable Notifications for package.json Action", NotificationDisplayType.NONE, true, null);
            List paths = ContainerUtil.map(this.myPackageJsonFiles, packageJson -> PackageJsonUpdateNotifier.this.createFileLink(packageJson));
            String content = "Notifications for installing dependencies from " + StringUtil.join((Collection)paths, (String)", ") + " are disabled.<p> Enable them back with the \"" + "Enable Notifications about Installing Dependencies from package.json" + "\" action.";
            Notification notification2 = group.createNotification(null, null, content, NotificationType.INFORMATION, (NotificationListener)new MyNotificationListener());
            notification2.notify(PackageJsonUpdateNotifier.this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

