/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependencyTree;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpManagerState {
    @XCollection(propertyElementName="pnp-files")
    private List<PnpFileState> myFileStates;

    @NotNull
    List<YarnPnpFile> convertStateToFileList(@NotNull Project project) {
        if (project == null) {
            YarnPnpManagerState.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.mapNotNull((Collection)ContainerUtil.notNullize(this.myFileStates), state -> YarnPnpManagerState.convertStateToFile(state, project));
        if (list2 == null) {
            YarnPnpManagerState.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    private static YarnPnpFile convertStateToFile(@NotNull PnpFileState state, @NotNull Project project) {
        if (state == null) {
            YarnPnpManagerState.$$$reportNull$$$0(2);
        }
        if (project == null) {
            YarnPnpManagerState.$$$reportNull$$$0(3);
        }
        if (state.myPath == null) {
            return null;
        }
        VirtualFile pnpFile = LocalFileSystem.getInstance().findFileByPath(state.myPath);
        if (pnpFile == null) {
            return null;
        }
        YarnPnpFile file2 = new YarnPnpFile(pnpFile, project);
        file2.setLibraryName(state.myLibraryName);
        if (state.myDependencies != null && new File(state.myPath).lastModified() == state.myLastModified) {
            YarnPnpDependencyTree.Builder builder = new YarnPnpDependencyTree.Builder();
            builder.setVirtualResolved(state.myPnpVirtualResolved);
            for (PnpDependencyState dependencyState : state.myDependencies) {
                if (dependencyState.myName == null || dependencyState.myRequireableLocation == null) continue;
                builder.addDependency(dependencyState.myName, dependencyState.myRequireableLocation, dependencyState.myRequireableLocationWithVirtualResolved);
            }
            file2.setDependencyTree(builder.build());
        }
        return file2;
    }

    @NotNull
    static YarnPnpManagerState convertFileListToState(@NotNull Collection<YarnPnpFile> files) {
        if (files == null) {
            YarnPnpManagerState.$$$reportNull$$$0(4);
        }
        YarnPnpManagerState state = new YarnPnpManagerState();
        ArrayList<PnpFileState> fileStates = new ArrayList<PnpFileState>();
        for (YarnPnpFile data : files) {
            fileStates.add(YarnPnpManagerState.convertFileToState(data));
        }
        Collections.sort(fileStates, Comparator.comparing(s -> ((PnpFileState)s).myPath));
        state.myFileStates = fileStates;
        YarnPnpManagerState yarnPnpManagerState = state;
        if (yarnPnpManagerState == null) {
            YarnPnpManagerState.$$$reportNull$$$0(5);
        }
        return yarnPnpManagerState;
    }

    @NotNull
    private static PnpFileState convertFileToState(@NotNull YarnPnpFile file2) {
        if (file2 == null) {
            YarnPnpManagerState.$$$reportNull$$$0(6);
        }
        PnpFileState fileState = new PnpFileState();
        fileState.myPath = file2.getPnpFile().getPath();
        fileState.myLastModified = VfsUtilCore.virtualToIoFile((VirtualFile)file2.getPnpFile()).lastModified();
        fileState.myLibraryName = file2.getLibraryName();
        YarnPnpDependencyTree tree = file2.getDependencyTree();
        if (tree != null) {
            fileState.myPnpVirtualResolved = file2.getDependencyTree().isVirtualResolved();
            fileState.myDependencies = ContainerUtil.map((Collection)tree.getDeps().values(), dependency -> {
                PnpDependencyState dependencyState = new PnpDependencyState();
                dependencyState.myName = dependency.getName();
                dependencyState.myRequireableLocation = dependency.getRequireableLocation();
                dependencyState.myRequireableLocationWithVirtualResolved = dependency.getRequireableLocationWithVirtualResolved();
                return dependencyState;
            });
        }
        PnpFileState pnpFileState = fileState;
        if (pnpFileState == null) {
            YarnPnpManagerState.$$$reportNull$$$0(7);
        }
        return pnpFileState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManagerState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManagerState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStateToFileList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFileListToState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFileToState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertStateToFileList";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertStateToFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertFileListToState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertFileToState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="dependency")
    public static class PnpDependencyState {
        @Attribute(value="name")
        private String myName;
        @Attribute(value="requireableLocation")
        private String myRequireableLocation;
        @Attribute(value="requireableLocationWithVirtualResolved")
        private String myRequireableLocationWithVirtualResolved;
    }

    @Tag(value="pnp-file")
    public static class PnpFileState {
        @Attribute(value="path")
        private String myPath;
        @Attribute(value="last-modified")
        private long myLastModified;
        @Attribute(value="library-name")
        private String myLibraryName;
        @Attribute(value="pnp-virtual-resolved")
        private boolean myPnpVirtualResolved = false;
        @XCollection(propertyElementName="dependencies")
        private List<PnpDependencyState> myDependencies;
    }
}

