/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependencyTree;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependencyTreeLoader;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpResolvedDependencyTree;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpSyntheticLibrary;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpFile {
    private static final Logger LOG = Logger.getInstance(YarnPnpFile.class);
    private final VirtualFile myPnpFile;
    private final Project myProject;
    private volatile YarnPnpDependencyTree myDependencyTree;
    private final AtomicBoolean myRefreshing;
    private String myLibraryName;

    YarnPnpFile(@NotNull VirtualFile pnpJsFile, @NotNull Project project) {
        if (pnpJsFile == null) {
            YarnPnpFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            YarnPnpFile.$$$reportNull$$$0(1);
        }
        this.myRefreshing = new AtomicBoolean(false);
        this.myLibraryName = null;
        this.myPnpFile = pnpJsFile;
        this.myProject = project;
    }

    boolean refresh() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread(), (Object)"Shouldn't be invoked in EDT");
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Shouldn't be invoked under read action");
        if (this.myRefreshing.compareAndSet(false, true)) {
            YarnPnpDependencyTree newDependencyTree = this.loadDependencyTree();
            String oldLibraryName = this.myLibraryName;
            ReadAction.run(() -> {
                this.myLibraryName = this.calcLibraryName();
            });
            YarnPnpDependencyTree oldDependencyTree = this.myDependencyTree;
            if (!Objects.equals(oldDependencyTree, newDependencyTree)) {
                this.myDependencyTree = newDependencyTree;
            }
            this.myRefreshing.set(false);
            return !Objects.equals(oldLibraryName, this.myLibraryName) || !Objects.equals(oldDependencyTree, newDependencyTree);
        }
        return false;
    }

    @Nullable
    private YarnPnpDependencyTree loadDependencyTree() {
        try {
            return YarnPnpDependencyTreeLoader.load(this.myProject, this.myPnpFile);
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        return null;
    }

    @NotNull
    public VirtualFile getPnpFile() {
        VirtualFile virtualFile = this.myPnpFile;
        if (virtualFile == null) {
            YarnPnpFile.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Nullable
    YarnPnpDependencyTree getDependencyTree() {
        return this.myDependencyTree;
    }

    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    void setDependencyTree(@NotNull YarnPnpDependencyTree tree) {
        if (tree == null) {
            YarnPnpFile.$$$reportNull$$$0(3);
        }
        this.myDependencyTree = tree;
    }

    void setLibraryName(@Nullable String libraryName) {
        this.myLibraryName = libraryName;
    }

    @NotNull
    private String calcLibraryName() {
        String parentDirPath = PathUtil.getParentPath((String)JsbtUtil.getRelativePath(this.myProject, this.myPnpFile, false));
        if (!parentDirPath.isEmpty()) {
            parentDirPath = parentDirPath + "/";
        }
        String string = "Dependencies from " + parentDirPath + "package.json";
        if (string == null) {
            YarnPnpFile.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public YarnPnpSyntheticLibrary createLibrary() {
        YarnPnpDependencyTree tree = this.getDependencyTree();
        if (tree == null || this.myLibraryName == null) {
            return null;
        }
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>();
        for (YarnPnpResolvedDependencyTree.ResolvedDependency dependency : tree.getResolvedDependencyTree().getResolvedDependencies()) {
            ContainerUtil.addIfNotNull(roots2, (Object)dependency.getDependencyRoot());
        }
        return new YarnPnpSyntheticLibrary(this, roots2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpJsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDependencyTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

