/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependencyTree;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.webcore.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpDependencyTreeLoader {
    private static final Logger LOG = Logger.getInstance(YarnPnpDependencyTreeLoader.class);
    private static final int TIMEOUT_MILLIS = 30000;
    private static final String PREFIX = "intellij-yarn-pnp-deps-tree-start";
    private static final String SUFFIX = "intellij-yarn-pnp-deps-tree-end";
    private final Project myProject;
    private final String myPnpFileSystemIndependentPath;

    private YarnPnpDependencyTreeLoader(@NotNull Project project, @NotNull VirtualFile pnpFile) {
        if (project == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(0);
        }
        if (pnpFile == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPnpFileSystemIndependentPath = pnpFile.getPath();
    }

    @NotNull
    public static YarnPnpDependencyTree load(@NotNull Project project, @NotNull VirtualFile pnpFile) throws ExecutionException {
        if (project == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(2);
        }
        if (pnpFile == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(3);
        }
        return new YarnPnpDependencyTreeLoader(project, pnpFile).load();
    }

    @NotNull
    private YarnPnpDependencyTree load() throws ExecutionException {
        long startNano = System.nanoTime();
        GeneralCommandLine commandLine = this.createCommandLine();
        KillableProcessHandler processHandler = new KillableProcessHandler(commandLine);
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
        ProcessOutput output = runner.runProcess(30000, true);
        if (!processHandler.isProcessTerminated()) {
            assert (output.isTimeout());
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)1000L, null);
        }
        if (output.isTimeout()) {
            throw new ExecutionException("Timed out when fetching Yarn PnP dependency tree for " + this.getShortFilePath() + ", command: " + commandLine.getCommandLineString());
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Cannot fetch Yarn PnP dependency tree for " + this.getShortFilePath() + ", command: " + commandLine.getCommandLineString() + ", exit code: " + output.getExitCode() + ", stderr: " + output.getStderr() + ", stdout: " + output.getStdout());
        }
        YarnPnpDependencyTree tree = null;
        Exception cause = null;
        try {
            tree = YarnPnpDependencyTreeLoader.parseDependencyTree(output.getStdout());
        }
        catch (Exception e) {
            cause = e;
        }
        if (tree == null) {
            String errorMessage = "Cannot fetch Yarn PnP dependency tree for " + this.getShortFilePath() + ", command: " + commandLine.getCommandLineString() + ", stdout: " + output.getStdout() + ", stderr: " + output.getStderr();
            throw new ExecutionException(errorMessage, (Throwable)cause);
        }
        String message = "Yarn PnP dependency tree for " + this.getShortFilePath() + " has " + tree.getDeps().size() + " deps, loaded in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms, command: " + commandLine.getCommandLineString();
        if (LOG.isDebugEnabled()) {
            message = message + ", stdout: " + output.getStdout() + ", stderr: " + output.getStderr();
        }
        LOG.info(message);
        YarnPnpDependencyTree yarnPnpDependencyTree = tree;
        if (yarnPnpDependencyTree == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(4);
        }
        return yarnPnpDependencyTree;
    }

    @NotNull
    private String getShortFilePath() {
        if (LOG.isDebugEnabled()) {
            String string = this.myPnpFileSystemIndependentPath;
            if (string == null) {
                YarnPnpDependencyTreeLoader.$$$reportNull$$$0(5);
            }
            return string;
        }
        int ind = this.myPnpFileSystemIndependentPath.length();
        for (int i = 0; i < 3; ++i) {
            ind = this.myPnpFileSystemIndependentPath.lastIndexOf(47, ind - 1);
        }
        if (ind < 0 || ind == this.myPnpFileSystemIndependentPath.length()) {
            String string = this.myPnpFileSystemIndependentPath;
            if (string == null) {
                YarnPnpDependencyTreeLoader.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myPnpFileSystemIndependentPath.substring(ind + 1);
        if (string == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private GeneralCommandLine createCommandLine() throws ExecutionException {
        NodeJsInterpreterRef interpreterRef = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        String parentPath = PathUtil.getParentPath((String)this.myPnpFileSystemIndependentPath);
        if (parentPath.isEmpty()) {
            throw new ExecutionException("No parent for " + this.myPnpFileSystemIndependentPath);
        }
        commandLine.setWorkDirectory(parentPath);
        commandLine.addParameter("--require");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myPnpFileSystemIndependentPath));
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution("nodejs/library/yarn/intellij-yarn-pnp-deps-tree-loader.js"));
        NodeCommandLineConfigurator.find(interpreterRef, this.myProject).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    @Nullable
    private static YarnPnpDependencyTree parseDependencyTree(@NotNull String stdout) {
        if (stdout == null) {
            YarnPnpDependencyTreeLoader.$$$reportNull$$$0(9);
        }
        int prefixInd = stdout.indexOf(PREFIX);
        int suffixInd = stdout.lastIndexOf(SUFFIX);
        if (prefixInd < 0 || suffixInd < 0) {
            return null;
        }
        String jsonOutput = stdout.substring(prefixInd + PREFIX.length(), suffixInd).trim();
        JsonObject rootObject = JsonUtil.parseJsonObject((String)jsonOutput, (boolean)false);
        JsonObject environmentObject = Objects.requireNonNull(rootObject.getAsJsonObject("environment"));
        JsonArray dependenciesArray = Objects.requireNonNull(rootObject.getAsJsonArray("dependencies"));
        YarnPnpDependencyTree.Builder treeBuilder = new YarnPnpDependencyTree.Builder();
        treeBuilder.setVirtualResolved(JsonUtil.getChildAsBoolean((JsonObject)environmentObject, (String)"pnp.resolveVirtual", (boolean)false));
        for (JsonElement element : dependenciesArray) {
            JsonObject depObject = element.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)depObject, (String)"name");
            String requireableLocation = JsonUtil.getChildAsString((JsonObject)depObject, (String)"requireableLocation");
            String resolvedVirtualRequireableLocation = JsonUtil.getChildAsString((JsonObject)depObject, (String)"resolvedVirtualRequireableLocation");
            if (name == null || requireableLocation == null) continue;
            treeBuilder.addDependency(name, requireableLocation, resolvedVirtualRequireableLocation);
        }
        return treeBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpDependencyTreeLoader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpDependencyTreeLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseDependencyTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

