/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NodeModulesIndexableFileNamesProvider;
import com.intellij.lang.typescript.psi.TypeScriptExcludeUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeModulesLibraryDirectory {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryDirectory.class);
    private static final Set<String> EXCLUDED_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"test", "tests", "spec", "specs", "node_modules"});
    private static final Set<String> BUILD_DIR_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"dist", "build", "built"});
    private static final Set<String> DEV_DEPENDENCIES_TO_EXCLUDE = ContainerUtil.immutableSet((Object[])new String[]{"typescript", "@angular/language-service", "babel-cli", "prettier"});
    private static final String PNPM_WORKSPACE_YAML_FILENAME = "pnpm-workspace.yaml";
    public static final RegistryValue INDEX_DIRECT_DEPS_SYMLINKS = Registry.get((String)"node_modules.index.direct.dependency.symlink");
    private final Project myProject;
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private final AtomicInteger myLibraryCalcCount;
    private volatile SyntheticLibrary myLibrary;
    @Nullable
    private NodeModulesLibraryDirectory myWorkspaceRoot;
    private final List<VirtualFile> myChildWorkspaceRoots;
    private NodeModulesDirectoryManager myDirectoryManager;

    public NodeModulesLibraryDirectory(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (project == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(0);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(2);
        }
        this.myLibraryCalcCount = new AtomicInteger(0);
        this.myChildWorkspaceRoots = new ArrayList<VirtualFile>();
        this.myProject = project;
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean isForApplicationSourceCode() {
        return NodeModulesLibraryDirectory.isForApplicationSourceCode(this.myNodeModulesDir);
    }

    static boolean isForApplicationSourceCode(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(4);
        }
        return NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir) == null && NodeModulesLibraryDirectory.findChild(nodeModulesDir.getParent(), PNPM_WORKSPACE_YAML_FILENAME, false) == null;
    }

    @Nullable
    private static VirtualFile findChild(@Nullable VirtualFile parent, @NotNull String childName, boolean directory) {
        if (childName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(5);
        }
        VirtualFile child = parent != null ? parent.findChild(childName) : null;
        return child != null && child.isValid() && child.isDirectory() == directory ? child : null;
    }

    void setWorkspaceRoot(@Nullable NodeModulesLibraryDirectory workspaceRoot) {
        this.myWorkspaceRoot = workspaceRoot;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void invalidateRoots() {
        this.myLibrary = null;
        this.myLibraryCalcCount.set(0);
    }

    @NotNull
    public SyntheticLibrary getLibrary() {
        SyntheticLibrary library = this.myLibrary;
        if (library == null) {
            this.myLibrary = library = this.createLibrary();
        }
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(7);
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary createLibrary() {
        int calcCount = this.myLibraryCalcCount.incrementAndGet();
        if (calcCount > 1) {
            LOG.debug("Concurrent node_modules roots calculation: " + calcCount);
        }
        return this.doCreateLibrary();
    }

    @NotNull
    private SyntheticLibrary doCreateLibrary() {
        HashSet<VirtualFile> roots2;
        if (!this.myNodeModulesDir.isValid()) {
            LOG.warn("Invalid " + this.myNodeModulesDir.getPath());
            SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptyList());
            if (syntheticLibrary == null) {
                NodeModulesLibraryDirectory.$$$reportNull$$$0(8);
            }
            return syntheticLibrary;
        }
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(this.myNodeModulesDir);
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonFiles packageJsonFiles = new PackageJsonFiles(this.myProject, packageJson, this.myChildWorkspaceRoots);
            roots2 = this.getIndexableModuleRoots(packageJsonFiles);
            for (Pair pair : packageJsonFiles.myList) {
                this.getDirectoryManager().setProvidedPackageJsonRoots((VirtualFile)pair.first, (PackageJsonData)pair.second);
            }
        } else {
            roots2 = new HashSet();
            VirtualFile[] children = (VirtualFile[])ObjectUtils.notNull((Object)this.myNodeModulesDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
            for (VirtualFile child : children) {
                String name = child.getName();
                if (name.startsWith(".") || name.startsWith("_")) continue;
                roots2.add(child);
            }
        }
        HashSet<VirtualFile> directRoots = new HashSet<VirtualFile>(roots2);
        Set<VirtualFile> tsOnlyRoots = this.collectTsOnlyRoots(roots2);
        roots2.addAll(tsOnlyRoots);
        HashSet excludedRoots = new HashSet();
        roots2.forEach(root -> this.collectExcludedRoots((VirtualFile)root, excludedRoots));
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(new ArrayList<VirtualFile>(roots2), excludedRoots, NodeModulesLibraryDirectory.getExcludeConditionForNonTsSources(roots2, directRoots, tsOnlyRoots));
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(9);
        }
        return syntheticLibrary;
    }

    @NotNull
    private Set<VirtualFile> getIndexableModuleRoots(@NotNull PackageJsonFiles packageJsonFiles) {
        if (packageJsonFiles == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(10);
        }
        List indexableDependencies = ContainerUtil.filter(packageJsonFiles.getAllDependencies(), packageJsonFiles::isDependencyIndexed);
        VirtualFile types2 = NodeModulesLibraryDirectory.findChild(this.myNodeModulesDir, "@types", true);
        if (types2 == null) {
            return this.toRootFiles(indexableDependencies);
        }
        Set typesDependencies = ((StreamEx)StreamEx.of((Object[])types2.getChildren()).filter(VirtualFile::isValid)).map(module -> this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(module))).nonNull().flatMap(data -> data.getAllDependencies().stream()).toSet();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        result2.addAll(this.toRootFiles(indexableDependencies));
        result2.addAll(this.toRootFiles(typesDependencies));
        result2.add(types2);
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> toRootFiles(@NotNull Collection<String> dependencies) {
        if (dependencies == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(12);
        }
        Set set = ((StreamEx)StreamEx.of(dependencies).map(this::getRootForDependency).nonNull().filter(el -> el.isValid() && el.isDirectory())).toSet();
        if (set == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    private VirtualFile getRootForDependency(@NotNull String dependency) {
        VirtualFile dir;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(14);
        }
        if ((dir = NodeModulesLibraryDirectory.findDescendantFileByRelativePath(this.myNodeModulesDir, dependency)) != null && dir.isValid() && dir.isDirectory()) {
            return this.shouldIndexDependency(dir) ? dir : null;
        }
        if (this.myWorkspaceRoot != null) {
            return this.myWorkspaceRoot.getNodeModulesDir().findFileByRelativePath(dependency);
        }
        return null;
    }

    private boolean shouldIndexDependency(@NotNull VirtualFile dependencyRoot) {
        if (dependencyRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(15);
        }
        if (dependencyRoot.is(VFileProperty.SYMLINK)) {
            if (!this.shouldIndexLinkedDependency(dependencyRoot)) {
                return false;
            }
            FileBasedIndex.getInstance().setSymlinkIndexingStatus(dependencyRoot, Boolean.valueOf(true));
        }
        return true;
    }

    private boolean shouldIndexLinkedDependency(@NotNull VirtualFile linkedDependencyRoot) {
        if (linkedDependencyRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(16);
        }
        if (INDEX_DIRECT_DEPS_SYMLINKS.asBoolean()) {
            return true;
        }
        VirtualFile target = linkedDependencyRoot.getCanonicalFile();
        if (target == null) {
            return true;
        }
        if (NodeModuleSearchUtil.findAncestorNodeModulesDir(target) != null) {
            return true;
        }
        return !this.getDirectoryManager().isUnderContentRoots(target);
    }

    @Nullable
    private static VirtualFile findDescendantFileByRelativePath(@NotNull VirtualFile root, @NotNull String relPath) {
        String name;
        VirtualFile result2;
        if (root == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(17);
        }
        if (relPath == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(18);
        }
        int offset = 0;
        for (result2 = root; result2 != null && offset < relPath.length(); result2 = result2.findChild(name)) {
            int separatorInd = relPath.indexOf(47, offset + 1);
            if (separatorInd < 0) {
                separatorInd = relPath.length();
            }
            name = relPath.substring(offset, separatorInd);
            offset = separatorInd + 1;
        }
        return root.equals(result2) ? null : result2;
    }

    @NotNull
    private Set<VirtualFile> collectTsOnlyRoots(@NotNull Set<VirtualFile> roots2) {
        if (roots2 == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(19);
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        boolean isExcludingJSSourceEnabled = TypeScriptExcludeUtil.isExcludingJSSourcesEnabled();
        HashSet<String> directDependencies = new HashSet<String>();
        HashSet<String> queuedDependencies = new HashSet<String>();
        for (VirtualFile virtualFile : roots2) {
            PackageJsonData packageJsonData;
            if (NodeModuleUtil.isTypesDir(virtualFile) || (packageJsonData = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(virtualFile))) == null) continue;
            directDependencies.add(packageJsonData.getName());
            if (packageJsonData.hasTypings()) {
                queuedDependencies.addAll(packageJsonData.getAllDependencies());
            }
            if (!isExcludingJSSourceEnabled || !TypeScriptExcludeUtil.arePackageSourcesExcluded(this.myProject, packageJsonData)) continue;
            result2.add(virtualFile);
        }
        Stack stack = new Stack();
        for (String string : queuedDependencies) {
            if (directDependencies.contains(string) || DEV_DEPENDENCIES_TO_EXCLUDE.contains(string)) continue;
            stack.add((Object)string);
        }
        queuedDependencies.addAll(directDependencies);
        queuedDependencies.addAll(DEV_DEPENDENCIES_TO_EXCLUDE);
        while (!stack.isEmpty()) {
            PackageJsonData dependencyPackageJsonData;
            String string = (String)stack.pop();
            VirtualFile virtualFile = this.getRootForDependency(string);
            if (virtualFile == null || !virtualFile.isValid() || !virtualFile.isDirectory() || (dependencyPackageJsonData = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(virtualFile))) == null || !dependencyPackageJsonData.hasTypings() || dependencyPackageJsonData.getName() == null) continue;
            if (!dependencyPackageJsonData.getName().startsWith("@types/")) {
                result2.add(virtualFile);
            }
            for (String name : dependencyPackageJsonData.getAllDependencies()) {
                if (!queuedDependencies.add(name)) continue;
                stack.add((Object)name);
            }
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    private static Condition<VirtualFile> getExcludeConditionForNonTsSources(@NotNull Set<VirtualFile> allRoots, @NotNull Set<VirtualFile> directRoots, @NotNull Set<VirtualFile> typingRoots) {
        if (allRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(21);
        }
        if (directRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(22);
        }
        if (typingRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(23);
        }
        Condition condition = file2 -> {
            VirtualFile parent;
            if (file2.isDirectory()) {
                return NodeModulesDirectoryManager.isNodeModulesDir(file2);
            }
            for (parent = file2.getParent(); parent != null && !allRoots.contains(parent); parent = parent.getParent()) {
            }
            if (parent == null) {
                return false;
            }
            if (typingRoots.contains(parent)) {
                return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file2.getNameSequence(), directRoots.contains(parent) ? NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT_TYPINGS : NodeModulesIndexableFileNamesProvider.DependencyKind.INDIRECT_TYPINGS);
            }
            return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file2.getNameSequence(), NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT);
        };
        if (condition == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(24);
        }
        return condition;
    }

    void addChildWorkspace(@NotNull VirtualFile childWorkspaceRoot) {
        if (childWorkspaceRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(25);
        }
        this.myChildWorkspaceRoots.add(childWorkspaceRoot);
    }

    private void collectExcludedRoots(@NotNull VirtualFile dependency, @NotNull Set<? super VirtualFile> excludedRoots) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(26);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(27);
        }
        Object[] children = (VirtualFile[])ObjectUtils.notNull((Object)dependency.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
        PackageJsonData dependencyPackageJsonData = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(dependency));
        Map nameByFile = ContainerUtil.map2MapNotNull((Object[])children, file2 -> Pair.create((Object)file2.getName(), (Object)file2));
        for (Map.Entry entry : nameByFile.entrySet()) {
            boolean shouldIndexDist;
            String name = (String)entry.getKey();
            VirtualFile child = (VirtualFile)entry.getValue();
            if (EXCLUDED_NAMES.contains(name)) {
                excludedRoots.add((VirtualFile)child);
                continue;
            }
            if (!BUILD_DIR_NAMES.contains(name) || (shouldIndexDist = dependencyPackageJsonData != null && (NodeModulesLibraryDirectory.isMainResolvedInsideFolder(dependencyPackageJsonData, name) || dependencyPackageJsonData.hasTypings() || nameByFile.containsKey("index.d.ts")))) continue;
            excludedRoots.add((VirtualFile)child);
        }
        if (dependencyPackageJsonData != null) {
            NodeModulesLibraryDirectory.collectExcludedAdditionalMainFiles(dependency, dependencyPackageJsonData, excludedRoots);
        }
    }

    private static boolean isMainResolvedInsideFolder(@NotNull PackageJsonData packageJsonData, @NotNull String folderName) {
        String jsNextMain;
        if (packageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(28);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(29);
        }
        if ((jsNextMain = packageJsonData.getJsNextMain()) != null && NodeModulesLibraryDirectory.startsWithFolder(jsNextMain, folderName)) {
            return true;
        }
        String main = packageJsonData.getMain();
        return main != null && !main.equals(jsNextMain) && NodeModulesLibraryDirectory.startsWithFolder(main, folderName);
    }

    private static boolean startsWithFolder(@NotNull String path, @NotNull String folderName) {
        if (path == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(30);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(31);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        int startInd = 0;
        if (path.startsWith("./")) {
            startInd += 2;
        }
        if (StringUtil.startsWith((CharSequence)path, (int)startInd, (CharSequence)folderName)) {
            if (folderName.length() + startInd == path.length()) {
                return true;
            }
            return path.charAt(startInd + folderName.length()) == '/';
        }
        return false;
    }

    @Nullable
    private PackageJsonData getPackageJsonDataForDependency(@Nullable VirtualFile dependencyPackageJson) {
        if (dependencyPackageJson == null) {
            return null;
        }
        try (AccessToken ignored = ProjectLocator.runWithPreferredProject((VirtualFile)dependencyPackageJson, (Project)this.myProject);){
            PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(dependencyPackageJson);
            return packageJsonData;
        }
    }

    @Nullable
    private static VirtualFile findPackageJsonForDependency(@NotNull VirtualFile dependency) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(32);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dependency);
    }

    private static void collectExcludedAdditionalMainFiles(@NotNull VirtualFile dependency, @NotNull PackageJsonData dependencyPackageJsonData, @NotNull Set<? super VirtualFile> excludedRoots) {
        Collection<String> additionalMainPaths;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(33);
        }
        if (dependencyPackageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(34);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(35);
        }
        if ((additionalMainPaths = dependencyPackageJsonData.getAdditionalMains()).isEmpty()) {
            return;
        }
        String preferableMainFile = dependencyPackageJsonData.getJsNextMain();
        if (preferableMainFile == null) {
            preferableMainFile = dependencyPackageJsonData.getMain();
        }
        if (preferableMainFile == null) {
            return;
        }
        VirtualFile defaultFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, preferableMainFile);
        if (defaultFile == null) {
            return;
        }
        ArrayList<String> modules = new ArrayList<String>(additionalMainPaths.size() + 1);
        String main = dependencyPackageJsonData.getMain();
        if (main != null) {
            modules.add(main);
        }
        modules.addAll(additionalMainPaths);
        for (String mainToExclude : modules) {
            VirtualFile candidateFile;
            if (preferableMainFile.equals(mainToExclude) || StringUtil.isEmptyOrSpaces((String)mainToExclude) || (candidateFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, mainToExclude)) == null || defaultFile.equals(candidateFile) || candidateFile.isDirectory()) continue;
            excludedRoots.add((VirtualFile)candidateFile);
        }
    }

    @NotNull
    private NodeModulesDirectoryManager getDirectoryManager() {
        NodeModulesDirectoryManager directoryManager = this.myDirectoryManager;
        if (directoryManager == null) {
            this.myDirectoryManager = directoryManager = NodeModulesDirectoryManager.getInstance(this.myProject);
        }
        NodeModulesDirectoryManager nodeModulesDirectoryManager = directoryManager;
        if (nodeModulesDirectoryManager == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(36);
        }
        return nodeModulesDirectoryManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 24: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 24: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 14: 
            case 26: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedDependencyRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directRoots";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingRoots";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childWorkspaceRoot";
                break;
            }
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonData";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyPackageJsonData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableModuleRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toRootFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTsOnlyRoots";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeConditionForNonTsSources";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 24: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isForApplicationSourceCode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableModuleRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toRootFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRootForDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexDependency";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexLinkedDependency";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDescendantFileByRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectTsOnlyRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeConditionForNonTsSources";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addChildWorkspace";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedRoots";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMainResolvedInsideFolder";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithFolder";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJsonForDependency";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedAdditionalMainFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 24: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PackageJsonFiles {
        private final List<Pair<VirtualFile, PackageJsonData>> myList;

        private PackageJsonFiles(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull List<VirtualFile> childWorkspaceRoots) {
            if (project == null) {
                PackageJsonFiles.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                PackageJsonFiles.$$$reportNull$$$0(1);
            }
            if (childWorkspaceRoots == null) {
                PackageJsonFiles.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> packageJsonFiles = new ArrayList<VirtualFile>(1 + childWorkspaceRoots.size());
            packageJsonFiles.add(packageJson);
            for (VirtualFile workspaceRoot : childWorkspaceRoots) {
                if (!workspaceRoot.isValid()) continue;
                ContainerUtil.addIfNotNull(packageJsonFiles, (Object)PackageJsonUtil.findChildPackageJsonFile(workspaceRoot));
            }
            this.myList = ContainerUtil.map(packageJsonFiles, file2 -> {
                try (AccessToken ignored = ProjectLocator.runWithPreferredProject((VirtualFile)file2, (Project)project);){
                    Pair pair = Pair.create((Object)file2, (Object)PackageJsonUtil.getOrCreateData(file2));
                    return pair;
                }
            });
        }

        @NotNull
        public Set<String> getAllDependencies() {
            if (this.myList.size() == 1) {
                Set<String> set = ((PackageJsonData)this.myList.get((int)0).second).getAllDependencies();
                if (set == null) {
                    PackageJsonFiles.$$$reportNull$$$0(3);
                }
                return set;
            }
            HashSet<String> dependencies = new HashSet<String>();
            for (Pair<VirtualFile, PackageJsonData> pair : this.myList) {
                dependencies.addAll(((PackageJsonData)pair.second).getAllDependencies());
            }
            HashSet<String> hashSet = dependencies;
            if (hashSet == null) {
                PackageJsonFiles.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        public boolean isDependencyIndexed(@NotNull String dependencyName) {
            if (dependencyName == null) {
                PackageJsonFiles.$$$reportNull$$$0(5);
            }
            if (DEV_DEPENDENCIES_TO_EXCLUDE.contains(dependencyName)) {
                for (Pair<VirtualFile, PackageJsonData> pair : this.myList) {
                    if (!((PackageJsonData)pair.second).isDependencyOfAnyTypeExcludeDev(dependencyName)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childWorkspaceRoots";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isDependencyIndexed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

