/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeLocalCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NodeCommandLineConfigurator {
    public abstract void configure(@NotNull GeneralCommandLine var1) throws ExecutionException;

    public void configure(@NotNull GeneralCommandLine commandLine, @NotNull Options options) throws ExecutionException {
        NodePackage yarnPkg;
        NpmManager npmManager;
        if (commandLine == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        if (options == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        if (!YarnPnpNodePackage.isWithYarnRun(commandLine) && options.shouldWrapWithYarnNodeCommand() && NpmUtil.isYarnAlikePackageRef((npmManager = NpmManager.getInstance(options.myProject)).getPackageRef()) && (yarnPkg = npmManager.getPackage(this.getInterpreter())) != null) {
            commandLine.getParametersList().addAt(0, NpmUtil.getValidNpmCliJsFilePath(yarnPkg));
            commandLine.getParametersList().addAt(1, "node");
        }
        this.configure(commandLine);
    }

    public abstract String convertLocalPathToRemote(@NotNull String var1);

    @NotNull
    protected abstract NodeJsInterpreter getInterpreter();

    @NotNull
    public static NodeCommandLineConfigurator find(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull Project project) throws ExecutionException {
        NodeJsInterpreter interpreter;
        if (interpreterRef == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(3);
        }
        if ((interpreter = interpreterRef.resolve(project)) == null) {
            throw new ExecutionException("Unresolved interpreter \"" + interpreterRef.getReferenceName() + "\"");
        }
        return NodeCommandLineConfigurator.find(interpreter);
    }

    @NotNull
    public static NodeCommandLineConfigurator find(@NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        if (interpreter == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(4);
        }
        if (interpreter instanceof NodeJsLocalInterpreter) {
            NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)interpreter;
            if (!localInterpreter.isValid()) {
                throw new ExecutionException("Invalid \"" + localInterpreter.getInterpreterSystemDependentPath() + "\"");
            }
            return new NodeLocalCommandLineConfigurator(localInterpreter);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            return new WslCommandLineConfigurator((WslNodeInterpreter)interpreter);
        }
        throw new ExecutionException("No local Node.js interpreter");
    }

    @NotNull
    public static Options defaultOptions(@NotNull Project project) {
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(5);
        }
        return new Options(project);
    }

    @NotNull
    public static Options emptyOptions(@NotNull Project project) {
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(6);
        }
        return new Options(project){

            @Override
            protected boolean shouldWrapWithYarnNodeCommand() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "emptyOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        private final Project myProject;
        private final List<YarnPnpNodePackage> myRequiredNodePackages;

        private Options(@NotNull Project project) {
            if (project == null) {
                Options.$$$reportNull$$$0(0);
            }
            this.myRequiredNodePackages = new ArrayList<YarnPnpNodePackage>();
            this.myProject = project;
        }

        protected boolean shouldWrapWithYarnNodeCommand() throws ExecutionException {
            if (this.myRequiredNodePackages.isEmpty() && YarnPnpManager.getInstance(this.myProject).getPnpFiles().isEmpty()) {
                return false;
            }
            NodePackageRef projectNpmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
            boolean yarn = NpmUtil.isYarnAlikePackageRef(projectNpmPackageRef);
            YarnPnpNodePackage yarnPnpNodePackage = (YarnPnpNodePackage)ContainerUtil.getFirstItem(this.myRequiredNodePackages);
            if (yarnPnpNodePackage != null) {
                yarnPnpNodePackage.requireYarnPackageManager(this.myProject, yarn, false);
            }
            return yarn;
        }

        @NotNull
        public Options withRequiredNodePackage(@NotNull NodePackage requiredNodePackage) {
            if (requiredNodePackage == null) {
                Options.$$$reportNull$$$0(1);
            }
            if (requiredNodePackage instanceof YarnPnpNodePackage) {
                this.myRequiredNodePackages.add((YarnPnpNodePackage)requiredNodePackage);
            }
            Options options = this;
            if (options == null) {
                Options.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requiredNodePackage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRequiredNodePackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withRequiredNodePackage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

