/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunProfileState;
import com.intellij.javascript.jest.coverage.FileModificationsSettledDownTracker;
import com.intellij.javascript.jest.coverage.JestCoverageRunState;
import com.intellij.javascript.jest.coverage.JestCoverageRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class JestCoverageProgramRunner
implements ProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance(JestCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = JestCoverageProgramRunner.class.getSimpleName();

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return "Coverage".equals(executorId) && profile instanceof JestRunConfiguration;
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        return new CoverageRunnerData();
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, state -> {
            RunContentDescriptor descriptor2 = DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)environment, (ProgramRunner)this);
            if (descriptor2 != null) {
                JestCoverageProgramRunner.doExecute(descriptor2, (JestRunProfileState)state, environment);
            }
            return descriptor2;
        });
    }

    private static void doExecute(final @NotNull RunContentDescriptor descriptor2, final @NotNull JestRunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (descriptor2 == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        if (state == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        final JestCoverageRunState coverageRunState = Objects.requireNonNull(state.getCoverageRunState());
        final AtomicBoolean restarted = new AtomicBoolean(false);
        ((SMTRunnerConsoleView)descriptor2.getExecutionConsole()).getResultsViewer().addEventsListener(new TestResultsViewer.EventsListener(){

            public void onTestingStarted(@NotNull TestResultsViewer sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                restarted.set(true);
            }

            public void onTestingFinished(@NotNull TestResultsViewer sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(1);
                }
                restarted.set(false);
                File coverageDir = Objects.requireNonNull(coverageRunState.getCoverageDir());
                final File lcovFile = new File(coverageDir, "lcov.info");
                final AtomicBoolean processedWithLcovFile = new AtomicBoolean(false);
                final FileModificationsSettledDownTracker tracker = new FileModificationsSettledDownTracker(lcovFile.getAbsolutePath(), 10, 100, 5, 300, () -> !environment.getProject().isDisposed() && !Disposer.isDisposed((Disposable)environment) && !restarted.get(), () -> JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state));
                ProcessHandler processHandler = descriptor2.getProcessHandler();
                if (processHandler != null) {
                    if (Disposer.isDisposed((Disposable)environment)) {
                        LOG.warn("Already disposed " + environment);
                        return;
                    }
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state);
                            tracker.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$1$1", "processTerminated"));
                        }
                    }, (Disposable)environment);
                    if (processHandler.isProcessTerminated()) {
                        JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state);
                        tracker.stop();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sender";
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void processWithLcovFile(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull AtomicBoolean processed, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        if (processed == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        if (processed.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)env)) {
                    JestCoverageProgramRunner.updateCoverageView(env, lcovFile, jestState);
                }
            }, env.getProject().getDisposed());
        }
    }

    private static void updateCoverageView(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(12);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(13);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(14);
        }
        RunConfigurationBase runConfiguration = (RunConfigurationBase)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath == null) {
            return;
        }
        if (!lcovFile.isFile()) {
            LOG.warn("Cannot find " + lcovFile.getAbsolutePath());
            return;
        }
        try {
            FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            LOG.error("Cannot copy " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            JestCoverageRunner coverageRunner = JestCoverageRunner.getInstance();
            coverageRunner.setWorkingDirectory(jestState.getRunSettings().getWorkingDirSystemDependentPath());
            coverageRunner.setInterpreter(jestState.getRunSettings().getInterpreterRef().resolve(env.getProject()));
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processWithLcovFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateCoverageView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

