/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptReferenceContributor
extends PsiReferenceContributor {
    public static boolean isRawHtmlJQuery(String selectorText) {
        return selectorText.startsWith("<", 1) && selectorText.length() > 2 && Character.isJavaIdentifierStart(selectorText.charAt(2));
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JavaScriptReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(Holder.REQUIRE_ARG_PLACE, JavaScriptReferenceContributor.getModuleReferenceProvider(true));
        registrar.registerReferenceProvider(Holder.SYSTEM_IMPORT_PLACE, JavaScriptReferenceContributor.getModuleReferenceProvider(true));
        registrar.registerReferenceProvider(Holder.IMPORT_CALL_PLACE, JavaScriptReferenceContributor.getModuleReferenceProvider(false));
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JSExpression methodExpression;
                PsiElement grandParent;
                PsiElement parent = ((PsiElement)element).getParent();
                if (parent instanceof JSAssignmentExpression) {
                    JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
                    String text = lOperand == null ? null : lOperand.getText();
                    return text != null && lOperand instanceof JSDefinitionExpression && (text.endsWith("location.href") || text.equals("location") || text.equals("window.location") || text.endsWith("location.pathname"));
                }
                if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
                    String text = methodExpression.getText();
                    return text != null && (text.endsWith("location.assign") || text.endsWith("location.reload"));
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(JSStringUtil.unescapeStringLiteralValue(element.getText()), element, 1, this, false){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        return 1.getAbsoluteTopLevelDirLocations((PsiFile)element.getContainingFile());
                    }

                    protected boolean isSoft() {
                        return true;
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    private static PsiReferenceProvider getModuleReferenceProvider(final boolean commonjsReferencesOnly) {
        return new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element, JSLiteralExpression.class);
                PsiReference[] psiReferenceArray = JSModuleReferenceContributor.getReferencesForStringLiteral(literalExpression, this, commonjsReferencesOnly);
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean isSimpleCss(String text) {
        return JavaScriptReferenceContributor.skipChars(text, false, false) == text.length();
    }

    public static int skipChars(String text, boolean allowDotsOrSharps, boolean allowWhiteSpace) {
        int offset;
        boolean seenDotOrSharp = !allowDotsOrSharps;
        int length = text.length();
        for (offset = 0; offset < length; ++offset) {
            char c = text.charAt(offset);
            if (Character.isWhitespace(c)) {
                if (allowWhiteSpace || offset >= length - 1) continue;
                break;
            }
            if (c == '.' || c == '#') {
                if (seenDotOrSharp) break;
                seenDotOrSharp = true;
                continue;
            }
            if (!JavaScriptReferenceContributor.isSimpleCssSymbol(c)) break;
        }
        return offset;
    }

    private static boolean isSimpleCssSymbol(char c) {
        return c == '-' || Character.isJavaIdentifierPart(c);
    }

    public static boolean isLiteralInCssContext(PsiElement host, boolean allowClassSelectors) {
        PsiElement parent = host.getParent();
        JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall(parent);
        if (invokedMethod != null) {
            JSExpression invokedMethodQualifier;
            JSReferenceExpression chaining;
            String methodName = invokedMethod.getReferencedName();
            if (invokedMethod.getQualifier() == null && JavaScriptReferenceContributor.isJQuery(methodName) && parent.getNode().findChildByType(JSElementTypes.EXPRESSIONS, host.getNode().getTreeNext()) == null) {
                return true;
            }
            if (Holder.ourJQueryMethodsWithSelectors.contains(methodName) || allowClassSelectors && Holder.ourJQueryMethodsWithClassNames.contains(methodName) ? (chaining = JSUtils.findRefExprThatStartCallChaining(invokedMethod)) != null && chaining != invokedMethod && chaining.getQualifier() == null && JavaScriptReferenceContributor.isJQuery(chaining.getReferencedName()) : "query".equals(methodName) && (invokedMethodQualifier = invokedMethod.getQualifier()) instanceof JSReferenceExpression && "dojo".equals(((JSReferenceExpression)invokedMethodQualifier).getReferencedName()) && ((JSReferenceExpression)invokedMethodQualifier).getQualifier() == null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJQuery(String methodName) {
        return "$".equals(methodName) || "jQuery".equals(methodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/JavaScriptReferenceContributor", "registerReferenceProviders"));
    }

    public static class Holder {
        public static final ElementPattern<JSLiteralExpression> REQUIRE_ARG_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).with((PatternCondition)new PatternCondition<JSLiteralExpression>("CommonJS.require"){

            public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
                JSCallExpression callExpression;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (callExpression = JSUtils.findCallExprByArg((PsiElement)expression)) != null && callExpression.isRequireCall();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JavaScriptReferenceContributor$Holder$1", "accepts"));
            }
        });
        private static final ElementPattern<JSLiteralExpression> SYSTEM_IMPORT_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).with((PatternCondition)new PatternCondition<JSLiteralExpression>("SystemJS.import"){

            public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(expression.getParent());
                return JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "System", "import");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JavaScriptReferenceContributor$Holder$2", "accepts"));
            }
        });
        public static final PsiElementPattern.Capture<JSLiteralExpression> IMPORT_CALL_PLACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withParent(ES6ImportCall.class)).with((PatternCondition)new PatternCondition<JSLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                return expression.isQuotedLiteral();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JavaScriptReferenceContributor$Holder$3", "accepts"));
            }
        });
        private static final Set<String> ourJQueryMethodsWithSelectors = ContainerUtil.set((Object[])new String[]{"children", "find", "next", "nextAll", "nextUntil", "parent", "parents", "parentsUntil", "prev", "prevAll", "prevUntil", "siblings", "closest"});
        private static final Set<String> ourJQueryMethodsWithClassNames = ContainerUtil.set((Object[])new String[]{"addClass", "removeClass", "toggleClass", "hasClass"});
    }
}

