/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.javascript.JSQuoteHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSEnterInStringLiteralHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        if (file2 == null) {
            JSEnterInStringLiteralHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSEnterInStringLiteralHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            JSEnterInStringLiteralHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            JSEnterInStringLiteralHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            JSEnterInStringLiteralHandler.$$$reportNull$$$0(4);
        }
        if (!((language = EnterHandler.getLanguage((DataContext)dataContext)) instanceof JSLanguageDialect)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        PsiElement psiAtOffset = file2.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            JSQuoteHandler quoteHandler;
            Document document2 = editor.getDocument();
            String text = document2.getText();
            ASTNode token = psiAtOffset.getNode();
            QuoteHandler fileTypeQuoteHandler = TypedHandler.getQuoteHandler((PsiFile)psiAtOffset.getContainingFile(), (Editor)editor);
            JSQuoteHandler jSQuoteHandler = quoteHandler = fileTypeQuoteHandler instanceof JSQuoteHandler ? (JSQuoteHandler)fileTypeQuoteHandler : null;
            if (quoteHandler != null && JSTokenTypes.LITERALS.contains(token.getElementType())) {
                char c;
                boolean enterAfterSlashAndBeforeQuote;
                TextRange range = token.getTextRange();
                String tokenText = token.getText();
                boolean bl = enterAfterSlashAndBeforeQuote = caretOffset >= 1 && caretOffset < text.length() && text.charAt(caretOffset - 1) == '\\' && ((c = text.charAt(caretOffset)) == '\"' || c == '\'');
                if (enterAfterSlashAndBeforeQuote) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                if (tokenText.indexOf(10) == -1) {
                    return new EnterInStringLiteralHandler(){

                        protected JavaLikeQuoteHandler getJavaLikeQuoteHandler(@NotNull Editor editor, @NotNull PsiElement psiAtOffset) {
                            if (editor == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (psiAtOffset == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return new JSQuoteHandler(){

                                @Override
                                @NotNull
                                public TokenSet getConcatenatableStringTokenTypes() {
                                    TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
                                    if (tokenSet == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return tokenSet;
                                }

                                @Override
                                public String getStringConcatenationOperatorRepresentation() {
                                    return "+";
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSEnterInStringLiteralHandler$1$1", "getConcatenatableStringTokenTypes"));
                                }
                            };
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "editor";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "psiAtOffset";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/javascript/JSEnterInStringLiteralHandler$1";
                            objectArray[2] = "getJavaLikeQuoteHandler";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }.preprocessEnter(file2, editor, caretOffsetRef, caretAdvanceRef, dataContext, originalHandler);
                }
                char literalStart = tokenText.charAt(0);
                StringLiteralLexer lexer = new StringLiteralLexer(literalStart, token.getElementType());
                lexer.start((CharSequence)text, range.getStartOffset(), range.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset < lexer.getTokenEnd()) {
                        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) break;
                        caretOffset = lexer.getTokenEnd();
                        break;
                    }
                    lexer.advance();
                }
                boolean atNewLine = document2.getCharsSequence().charAt(caretOffset) == '\n';
                document2.insertString(caretOffset, (CharSequence)"\\");
                if (atNewLine) {
                    caretAdvance = 1;
                } else {
                    ++caretOffset;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/JSEnterInStringLiteralHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

