/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HelperFilesLocator {
    private static final String HELPERS_DIR = "helpers";

    @NotNull
    public static File getBundledHelpersDir() {
        String srcDir;
        String jarPath = PathUtil.getJarPathForClass(HelperFilesLocator.class);
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("Not a file (" + jarFile.getAbsolutePath() + ")");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, HELPERS_DIR);
        }
        if (ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isInternal() && new File(srcDir = jarPath.replace('\\', '/').replace("/out/classes/production/intellij.javascript.impl", "/plugins/JavaScriptLanguage/src")).isDirectory()) {
            jarPath = srcDir;
        }
        return new File(jarPath, HELPERS_DIR);
    }

    @NotNull
    public static File getFileRelativeToHelpersDir(@NotNull String relativePath) throws IOException {
        String systemDependentRelativePath;
        File jsDir;
        File file2;
        if (relativePath == null) {
            HelperFilesLocator.$$$reportNull$$$0(0);
        }
        if (!(file2 = new File(jsDir = HelperFilesLocator.getBundledHelpersDir(), systemDependentRelativePath = FileUtil.toSystemDependentName((String)relativePath))).isFile()) {
            throw new IOException("Cannot find " + relativePath + ", not a file " + file2.getAbsolutePath());
        }
        File file3 = file2;
        if (file3 == null) {
            HelperFilesLocator.$$$reportNull$$$0(1);
        }
        return file3;
    }

    @NotNull
    public static String resolvePathForExecution(@NotNull String relativePath) throws ExecutionException {
        String string;
        if (relativePath == null) {
            HelperFilesLocator.$$$reportNull$$$0(2);
        }
        try {
            File file2 = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath);
            string = file2.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot locate " + relativePath, (Throwable)e);
        }
        if (string == null) {
            HelperFilesLocator.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/HelperFilesLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/HelperFilesLocator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileRelativeToHelpersDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePathForExecution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileRelativeToHelpersDir";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathForExecution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

