/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0006\u0010\u0013\u001a\u00020\u0000J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0015J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001cJR\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\u001e\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u001f0\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H 0\"J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec;", "", "rawText", "", "localSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "containerSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "(Ljava/lang/String;Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;)V", "getContainerSpec", "()Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "getLocalSpec", "()Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "getRawText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "ensureMatched", "equals", "", "other", "hashCode", "", "isRangesMatched", "localPortFor", "containerPort", "(I)Ljava/lang/Integer;", "toNativeMap", "", "CONTAINER", "LOCAL", "containerFactory", "Ljava/util/function/BiFunction;", "localFactory", "toString", "Companion", "ContainerPortsSpec", "LocalPortsSpec", "intellij.clouds.docker.agent.rt"})
public final class DockerPortSpec {
    @NotNull
    private final String rawText;
    @NotNull
    private final LocalPortsSpec localSpec;
    @NotNull
    private final ContainerPortsSpec containerSpec;
    public static final Companion Companion = new Companion(null);

    public final boolean isRangesMatched() {
        return this.localSpec.matches(this.containerSpec);
    }

    @NotNull
    public final DockerPortSpec ensureMatched() {
        if (!this.isRangesMatched()) {
            throw (Throwable)new IllegalStateException();
        }
        return this;
    }

    @NotNull
    public final <CONTAINER, LOCAL> Map<CONTAINER, LOCAL> toNativeMap(@NotNull BiFunction<String, Integer, CONTAINER> containerFactory, @NotNull BiFunction<String, String, LOCAL> localFactory) {
        Intrinsics.checkParameterIsNotNull(containerFactory, (String)"containerFactory");
        Intrinsics.checkParameterIsNotNull(localFactory, (String)"localFactory");
        this.ensureMatched();
        HashMap<CONTAINER, LOCAL> result = new HashMap<CONTAINER, LOCAL>();
        if (DockerPortSpec.Companion.size(this.containerSpec.getPortsRange()) == 1) {
            CONTAINER containerOne = this.containerSpec.toNativeList(containerFactory).get(0);
            LOCAL localOne = localFactory.apply(this.localSpec.getHostIP(), this.localSpec.toNativePortRange());
            result.put(containerOne, localOne);
        } else {
            Iterable $this$forEach$iv = (Iterable)this.containerSpec.getPortsRange();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                LOCAL nextLocal = localFactory.apply(this.localSpec.getHostIP(), String.valueOf(this.localPortFor(it)));
                CONTAINER nextContainer = containerFactory.apply(this.containerSpec.getProtocol(), it);
                result.put(nextContainer, nextLocal);
            }
        }
        return result;
    }

    @Nullable
    public final Integer localPortFor(int containerPort) {
        this.ensureMatched();
        IntRange intRange = this.localSpec.getPortRange();
        if (intRange != null) {
            IntRange intRange2 = intRange;
            boolean bl = false;
            boolean bl2 = false;
            IntRange it = intRange2;
            boolean bl3 = false;
            return it.getStart() + containerPort - this.containerSpec.getPortsRange().getFirst();
        }
        return null;
    }

    @NotNull
    public final String getRawText() {
        return this.rawText;
    }

    @NotNull
    public final LocalPortsSpec getLocalSpec() {
        return this.localSpec;
    }

    @NotNull
    public final ContainerPortsSpec getContainerSpec() {
        return this.containerSpec;
    }

    public DockerPortSpec(@NotNull String rawText, @NotNull LocalPortsSpec localSpec, @NotNull ContainerPortsSpec containerSpec) {
        Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
        Intrinsics.checkParameterIsNotNull((Object)localSpec, (String)"localSpec");
        Intrinsics.checkParameterIsNotNull((Object)containerSpec, (String)"containerSpec");
        this.rawText = rawText;
        this.localSpec = localSpec;
        this.containerSpec = containerSpec;
    }

    @NotNull
    public final String component1() {
        return this.rawText;
    }

    @NotNull
    public final LocalPortsSpec component2() {
        return this.localSpec;
    }

    @NotNull
    public final ContainerPortsSpec component3() {
        return this.containerSpec;
    }

    @NotNull
    public final DockerPortSpec copy(@NotNull String rawText, @NotNull LocalPortsSpec localSpec, @NotNull ContainerPortsSpec containerSpec) {
        Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
        Intrinsics.checkParameterIsNotNull((Object)localSpec, (String)"localSpec");
        Intrinsics.checkParameterIsNotNull((Object)containerSpec, (String)"containerSpec");
        return new DockerPortSpec(rawText, localSpec, containerSpec);
    }

    public static /* synthetic */ DockerPortSpec copy$default(DockerPortSpec dockerPortSpec, String string, LocalPortsSpec localPortsSpec, ContainerPortsSpec containerPortsSpec, int n, Object object) {
        if ((n & 1) != 0) {
            string = dockerPortSpec.rawText;
        }
        if ((n & 2) != 0) {
            localPortsSpec = dockerPortSpec.localSpec;
        }
        if ((n & 4) != 0) {
            containerPortsSpec = dockerPortSpec.containerSpec;
        }
        return dockerPortSpec.copy(string, localPortsSpec, containerPortsSpec);
    }

    @NotNull
    public String toString() {
        return "DockerPortSpec(rawText=" + this.rawText + ", localSpec=" + this.localSpec + ", containerSpec=" + this.containerSpec + ")";
    }

    public int hashCode() {
        String string = this.rawText;
        LocalPortsSpec localPortsSpec = this.localSpec;
        ContainerPortsSpec containerPortsSpec = this.containerSpec;
        return ((string != null ? string.hashCode() : 0) * 31 + (localPortsSpec != null ? ((Object)localPortsSpec).hashCode() : 0)) * 31 + (containerPortsSpec != null ? ((Object)containerPortsSpec).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DockerPortSpec)) break block3;
                DockerPortSpec dockerPortSpec = (DockerPortSpec)object;
                if (!Intrinsics.areEqual((Object)this.rawText, (Object)dockerPortSpec.rawText) || !Intrinsics.areEqual((Object)this.localSpec, (Object)dockerPortSpec.localSpec) || !Intrinsics.areEqual((Object)this.containerSpec, (Object)dockerPortSpec.containerSpec)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final DockerPortSpec fromRawString(@NotNull String raw) {
        return Companion.fromRawString(raw);
    }

    @JvmStatic
    private static final IntRange rangeFromString(String range) {
        return DockerPortSpec.Companion.rangeFromString(range);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "", "hostIP", "", "portRange", "Lkotlin/ranges/IntRange;", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getHostIP", "()Ljava/lang/String;", "getPortRange", "()Lkotlin/ranges/IntRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "matches", "containerSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "toNativePortRange", "toString", "Companion", "intellij.clouds.docker.agent.rt"})
    public static final class LocalPortsSpec {
        @NotNull
        private final String hostIP;
        @Nullable
        private final IntRange portRange;
        public static final Companion Companion = new Companion(null);

        public final boolean matches(@NotNull ContainerPortsSpec containerSpec) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)containerSpec, (String)"containerSpec");
            int thatSize = Companion.size(containerSpec.getPortsRange());
            if (thatSize == 0) {
                bl = false;
            } else if (thatSize == 1) {
                bl = true;
            } else {
                IntRange intRange = this.portRange;
                bl = (intRange != null ? Companion.size(intRange) : 0) == thatSize;
            }
            return bl;
        }

        @NotNull
        public final String toNativePortRange() {
            String string;
            IntRange intRange = this.portRange;
            if (intRange == null) {
                intRange = IntRange.Companion.getEMPTY();
            }
            IntRange safeRange = intRange;
            switch (Companion.size(safeRange)) {
                case 0: {
                    string = "";
                    break;
                }
                case 1: {
                    string = String.valueOf(safeRange.getFirst());
                    break;
                }
                default: {
                    string = "" + safeRange.getFirst() + '-' + safeRange.getLast();
                }
            }
            return string;
        }

        @NotNull
        public final String getHostIP() {
            return this.hostIP;
        }

        @Nullable
        public final IntRange getPortRange() {
            return this.portRange;
        }

        public LocalPortsSpec(@NotNull String hostIP, @Nullable IntRange portRange) {
            Intrinsics.checkParameterIsNotNull((Object)hostIP, (String)"hostIP");
            this.hostIP = hostIP;
            this.portRange = portRange;
        }

        @NotNull
        public final String component1() {
            return this.hostIP;
        }

        @Nullable
        public final IntRange component2() {
            return this.portRange;
        }

        @NotNull
        public final LocalPortsSpec copy(@NotNull String hostIP, @Nullable IntRange portRange) {
            Intrinsics.checkParameterIsNotNull((Object)hostIP, (String)"hostIP");
            return new LocalPortsSpec(hostIP, portRange);
        }

        public static /* synthetic */ LocalPortsSpec copy$default(LocalPortsSpec localPortsSpec, String string, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                string = localPortsSpec.hostIP;
            }
            if ((n & 2) != 0) {
                intRange = localPortsSpec.portRange;
            }
            return localPortsSpec.copy(string, intRange);
        }

        @NotNull
        public String toString() {
            return "LocalPortsSpec(hostIP=" + this.hostIP + ", portRange=" + this.portRange + ")";
        }

        public int hashCode() {
            String string = this.hostIP;
            IntRange intRange = this.portRange;
            return (string != null ? string.hashCode() : 0) * 31 + (intRange != null ? intRange.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LocalPortsSpec)) break block3;
                    LocalPortsSpec localPortsSpec = (LocalPortsSpec)object;
                    if (!Intrinsics.areEqual((Object)this.hostIP, (Object)localPortsSpec.hostIP) || !Intrinsics.areEqual((Object)this.portRange, (Object)localPortsSpec.portRange)) break block3;
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public static final LocalPortsSpec fromString(@NotNull String serialized) {
            return Companion.fromString(serialized);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec$Companion;", "", "()V", "fromString", "Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "serialized", "", "intellij.clouds.docker.agent.rt"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final LocalPortsSpec fromString(@NotNull String serialized) {
                LocalPortsSpec localPortsSpec;
                Intrinsics.checkParameterIsNotNull((Object)serialized, (String)"serialized");
                List parts = StringsKt.split$default((CharSequence)serialized, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                switch (parts.size()) {
                    case 2: {
                        localPortsSpec = new LocalPortsSpec((String)parts.get(0), DockerPortSpec.Companion.rangeFromString((String)parts.get(1)));
                        break;
                    }
                    case 1: {
                        if (StringsKt.contains$default((CharSequence)serialized, (char)'.', (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)serialized)) {
                            localPortsSpec = new LocalPortsSpec(serialized, null);
                            break;
                        }
                        localPortsSpec = new LocalPortsSpec("", DockerPortSpec.Companion.rangeFromString(serialized));
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException();
                    }
                }
                return localPortsSpec;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J,\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00150\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "", "protocol", "", "portsRange", "Lkotlin/ranges/IntRange;", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getPortsRange", "()Lkotlin/ranges/IntRange;", "getProtocol", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toNativeList", "", "PORT", "nativeFactory", "Ljava/util/function/BiFunction;", "toString", "Companion", "intellij.clouds.docker.agent.rt"})
    public static final class ContainerPortsSpec {
        @NotNull
        private final String protocol;
        @NotNull
        private final IntRange portsRange;
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <PORT> List<PORT> toNativeList(@NotNull BiFunction<String, Integer, PORT> nativeFactory) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(nativeFactory, (String)"nativeFactory");
            Iterable $this$map$iv = (Iterable)this.portsRange;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PORT PORT = nativeFactory.apply(this.protocol, (int)it);
                collection.add(PORT);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @NotNull
        public final IntRange getPortsRange() {
            return this.portsRange;
        }

        public ContainerPortsSpec(@NotNull String protocol, @NotNull IntRange portsRange) {
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            Intrinsics.checkParameterIsNotNull((Object)portsRange, (String)"portsRange");
            this.protocol = protocol;
            this.portsRange = portsRange;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @NotNull
        public final IntRange component2() {
            return this.portsRange;
        }

        @NotNull
        public final ContainerPortsSpec copy(@NotNull String protocol, @NotNull IntRange portsRange) {
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            Intrinsics.checkParameterIsNotNull((Object)portsRange, (String)"portsRange");
            return new ContainerPortsSpec(protocol, portsRange);
        }

        public static /* synthetic */ ContainerPortsSpec copy$default(ContainerPortsSpec containerPortsSpec, String string, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                string = containerPortsSpec.protocol;
            }
            if ((n & 2) != 0) {
                intRange = containerPortsSpec.portsRange;
            }
            return containerPortsSpec.copy(string, intRange);
        }

        @NotNull
        public String toString() {
            return "ContainerPortsSpec(protocol=" + this.protocol + ", portsRange=" + this.portsRange + ")";
        }

        public int hashCode() {
            String string = this.protocol;
            IntRange intRange = this.portsRange;
            return (string != null ? string.hashCode() : 0) * 31 + (intRange != null ? intRange.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ContainerPortsSpec)) break block3;
                    ContainerPortsSpec containerPortsSpec = (ContainerPortsSpec)object;
                    if (!Intrinsics.areEqual((Object)this.protocol, (Object)containerPortsSpec.protocol) || !Intrinsics.areEqual((Object)this.portsRange, (Object)containerPortsSpec.portsRange)) break block3;
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public static final ContainerPortsSpec fromString(@NotNull String text) {
            return Companion.fromString(text);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec$Companion;", "", "()V", "fromString", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "text", "", "intellij.clouds.docker.agent.rt"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public final ContainerPortsSpec fromString(@NotNull String text) {
                void ports;
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                List portsAndProtocol = StringsKt.split$default((CharSequence)text, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
                int size = portsAndProtocol.size();
                Pair pair = size == 1 ? new Pair(portsAndProtocol.get(0), (Object)"tcp") : new Pair(portsAndProtocol.get(size - 2), portsAndProtocol.get(size - 1));
                String string = (String)pair.component1();
                String protocol = (String)pair.component2();
                return new ContainerPortsSpec(protocol, DockerPortSpec.Companion.rangeFromString((String)ports));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0003J\f\u0010\n\u001a\u00020\u000b*\u00020\bH\u0002J\f\u0010\f\u001a\u00020\u000b*\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$Companion;", "", "()V", "fromRawString", "Lcom/intellij/docker/agent/settings/DockerPortSpec;", "raw", "", "rangeFromString", "Lkotlin/ranges/IntRange;", "range", "size", "", "toIntOrIAE", "intellij.clouds.docker.agent.rt"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DockerPortSpec fromRawString(@NotNull String raw) {
            DockerPortSpec dockerPortSpec;
            Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
            CharSequence charSequence = raw;
            Regex regex = new Regex(":+");
            int n = 0;
            boolean bl = false;
            List parts = regex.split(charSequence, n);
            switch (parts.size()) {
                case 3: {
                    dockerPortSpec = new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString((String)parts.get(0) + ":" + (String)parts.get(1)), ContainerPortsSpec.Companion.fromString((String)parts.get(2)));
                    break;
                }
                case 2: {
                    dockerPortSpec = new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString((String)parts.get(0)), ContainerPortsSpec.Companion.fromString((String)parts.get(1)));
                    break;
                }
                case 1: {
                    dockerPortSpec = new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString(""), ContainerPortsSpec.Companion.fromString((String)parts.get(0)));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
            return dockerPortSpec;
        }

        @JvmStatic
        private final IntRange rangeFromString(String range) {
            IntRange intRange;
            List parts = StringsKt.split$default((CharSequence)range, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            switch (parts.size()) {
                case 1: {
                    intRange = new IntRange(this.toIntOrIAE(range), this.toIntOrIAE(range));
                    break;
                }
                case 2: {
                    intRange = new IntRange(this.toIntOrIAE((String)parts.get(0)), this.toIntOrIAE((String)parts.get(1)));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
            return intRange;
        }

        private final int toIntOrIAE(@NotNull String $this$toIntOrIAE) {
            try {
                String string = $this$toIntOrIAE;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                bl = false;
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw (Throwable)new IllegalArgumentException(e);
            }
        }

        private final int size(@NotNull IntRange $this$size) {
            return $this$size.isEmpty() ? 0 : $this$size.getLast() - $this$size.getFirst() + 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

