/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.AgentLogSettings;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.remoteServer.agent.annotation.ChildCall;
import com.intellij.remoteServer.agent.annotation.FinalCall;
import com.intellij.remoteServer.agent.annotation.ImmediateCall;
import com.intellij.remoteServer.agent.util.CloudAgent;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public interface DockerAgent
extends CloudAgent {
    public void setLogSettings(AgentLogSettings var1);

    public void connect(DockerAgentConfig var1, CloudAgentLogger var2, CloudAgentErrorHandler var3);

    @FinalCall
    public void disconnect();

    public boolean isConnected();

    @ChildCall
    public DockerAgentDeployment createDeployment(@NotNull DockerAgentDeploymentConfig var1, @NotNull CloudAgentLoggingHandler var2, @NotNull DockerAgentPathMapper var3);

    @ChildCall
    public DockerAgentApplication[] getApplications();

    @ChildCall
    public DockerAgentApplication[] getContainers();

    @ChildCall
    public DockerAgentApplication findContainer(String var1);

    @ChildCall
    public DockerAgentApplication[] getImages(String var1);

    public OngoingProcess pullImage(DockerAgentRepositoryConfig var1, DockerAgentProgressCallback var2);

    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerAgentRepositoryConfig var1);

    @ImmediateCall
    @NotNull
    public DockerImageBuilder createImageBuilder();

    public void imageRegistryAuth(DockerAuthConfig var1);

    public void removeVolume(String var1);

    public void attachEventListener(@NotNull DockerEvent.Listener var1);

    public static interface DockerImageBuilder {
        @ImmediateCall
        public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig var1);
    }
}

