/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.xml.XmlBundle;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "chooseUrl", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/util/Url;", "urls", "", "createRequest", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "isForceFileUrlIfNoUrlProvider", "", "openInBrowser", "", "request", "preferLocalUrl", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.xml.impl"})
public final class BaseOpenInBrowserActionKt {
    private static final Logger LOG;

    public static final void openInBrowser(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl, @Nullable WebBrowser browser2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"WebBrowserService.getIns\u2026(request, preferLocalUrl)");
            Collection urls = collection;
            if (!urls.isEmpty()) {
                BaseOpenInBrowserActionKt.chooseUrl(urls).onSuccess((java.util.function.Consumer)new java.util.function.Consumer<Url>(browser2, request){
                    final /* synthetic */ WebBrowser $browser;
                    final /* synthetic */ OpenInBrowserRequest $request;

                    public final void accept(Url url) {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
                        String string = url.toExternalForm();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toExternalForm()");
                        browserLauncher.browse(string, this.$browser, this.$request.getProject());
                    }
                    {
                        this.$browser = webBrowser;
                        this.$request = openInBrowserRequest;
                    }
                });
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)XmlBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static /* synthetic */ void openInBrowser$default(OpenInBrowserRequest openInBrowserRequest, boolean bl, WebBrowser webBrowser, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        BaseOpenInBrowserActionKt.openInBrowser(openInBrowserRequest, bl, webBrowser);
    }

    public static final void openInBrowser(@NotNull AnActionEvent event, @Nullable WebBrowser browser2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
            OpenInBrowserRequest openInBrowserRequest = BaseOpenInBrowserActionKt.createRequest(dataContext, true);
            if (openInBrowserRequest == null) break block0;
            OpenInBrowserRequest openInBrowserRequest2 = openInBrowserRequest;
            boolean bl = false;
            boolean bl2 = false;
            OpenInBrowserRequest it = openInBrowserRequest2;
            boolean bl3 = false;
            BaseOpenInBrowserActionKt.openInBrowser(it, BitUtil.isSet((int)event.getModifiers(), (int)1), browser2);
        }
    }

    private static final OpenInBrowserRequest createRequest(DataContext context, boolean isForceFileUrlIfNoUrlProvider) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (virtualFile != null && !virtualFile.isDirectory() && virtualFile.isValid() && project != null && project.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
            if (psiFile != null) {
                return OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)psiFile), (boolean)isForceFileUrlIfNoUrlProvider);
            }
        } else {
            Project project = editor.getProject();
            if (project != null && project.isInitialized()) {
                PsiFile psiFile;
                PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile2 == null) {
                    psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                }
                if (psiFile != null) {
                    return new OpenInBrowserRequest(editor, psiFile, isForceFileUrlIfNoUrlProvider, psiFile, isForceFileUrlIfNoUrlProvider){
                        private final Lazy lazyElement$delegate;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ PsiFile $psiFile;
                        final /* synthetic */ boolean $isForceFileUrlIfNoUrlProvider;

                        private final PsiElement getLazyElement() {
                            Lazy lazy = this.lazyElement$delegate;
                            createRequest.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (PsiElement)lazy.getValue();
                        }

                        @NotNull
                        public PsiElement getElement() {
                            PsiElement psiElement = this.getLazyElement();
                            if (psiElement == null) {
                                psiElement = (PsiElement)this.getFile();
                            }
                            return psiElement;
                        }
                        {
                            this.$editor = $captured_local_variable$0;
                            this.$psiFile = $captured_local_variable$1;
                            this.$isForceFileUrlIfNoUrlProvider = $captured_local_variable$2;
                            super($super_call_param$3, $super_call_param$4);
                            this.lazyElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(this){
                                final /* synthetic */ createRequest.1 this$0;

                                @Nullable
                                public final PsiElement invoke() {
                                    PsiFile psiFile = this.this$0.getFile();
                                    CaretModel caretModel = this.this$0.$editor.getCaretModel();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                                    return psiFile.findElementAt(caretModel.getOffset());
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    };
                }
            }
        }
        return null;
    }

    private static final Promise<Url> chooseUrl(Collection<? extends Url> urls) {
        if (urls.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)urls));
        }
        AsyncPromise result = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.toMutableList(urls)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((SimpleListCellRenderer.Customizer)chooseUrl.1.INSTANCE)).setTitle(XmlBundle.message((String)"browser.url.popup", (Object[])new Object[0])).setItemChosenCallback((Consumer)new Consumer<Url>(result){
            final /* synthetic */ AsyncPromise $result;

            public final void consume(Url value) {
                this.$result.setResult((Object)value);
            }
            {
                this.$result = asyncPromise;
            }
        }).createPopup().showInFocusCenter();
        return (Promise)result;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BaseOpenInBrowserAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ OpenInBrowserRequest access$createRequest(DataContext context, boolean isForceFileUrlIfNoUrlProvider) {
        return BaseOpenInBrowserActionKt.createRequest(context, isForceFileUrlIfNoUrlProvider);
    }
}

