/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.settings.configurable;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.lang.puppet.settings.configurable.PuppetConfigurableForm;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetConfigurable
implements SearchableConfigurable {
    @NotNull
    private final PuppetProjectConfiguration myProjectConfiguration;
    @Nullable
    private PuppetConfigurableForm myConfigurableForm;
    @NotNull
    private final Project myProject;

    public PuppetConfigurable(@NotNull Project project) {
        if (project == null) {
            PuppetConfigurable.$$$reportNull$$$0(0);
        }
        this.myConfigurableForm = null;
        this.myProject = project;
        this.myProjectConfiguration = PuppetProjectConfiguration.getInstance(project);
    }

    @NotNull
    private PuppetConfigurableForm getForm() {
        if (this.myConfigurableForm == null) {
            this.myConfigurableForm = new PuppetConfigurableForm();
        }
        PuppetConfigurableForm puppetConfigurableForm = this.myConfigurableForm;
        if (puppetConfigurableForm == null) {
            PuppetConfigurable.$$$reportNull$$$0(1);
        }
        return puppetConfigurableForm;
    }

    @NotNull
    public String getId() {
        return "Settings.Puppet";
    }

    @Nls
    public String getDisplayName() {
        return PuppetBundle.message("settings.puppet.configurable.display.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        return this.getForm().getPanel();
    }

    public boolean isModified() {
        if (this.myConfigurableForm == null) {
            return false;
        }
        return this.myConfigurableForm.getLanguageVersionModel().getSelectedItem() != this.myProjectConfiguration.getLanguageVersion() || !StringUtil.equals((CharSequence)this.myConfigurableForm.getPathToLibrarian().getText(), (CharSequence)this.myProjectConfiguration.getLibrarianPath());
    }

    public void apply() throws ConfigurationException {
        if (this.myConfigurableForm == null) {
            return;
        }
        if (this.myConfigurableForm.getLanguageVersionModel().getSelectedItem() != this.myProjectConfiguration.getLanguageVersion()) {
            this.myProjectConfiguration.setLanguageVersion(this.myConfigurableForm.getLanguageVersionModel().getSelectedItem());
            PuppetConfigurationUtil.reparsePuppetFiles(this.myProject);
        }
        this.myProjectConfiguration.setLibrarianPath(this.myConfigurableForm.getPathToLibrarian().getText());
    }

    public void reset() {
        if (this.myConfigurableForm == null) {
            return;
        }
        this.myConfigurableForm.getLanguageVersionModel().setSelectedItem((Object)this.myProjectConfiguration.getLanguageVersion());
        this.myConfigurableForm.getPathToLibrarian().setText(this.myProjectConfiguration.getLibrarianPath());
    }

    public void disposeUIResources() {
        this.myConfigurableForm = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/settings/configurable/PuppetConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/settings/configurable/PuppetConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

