/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectListener;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetScopeManager {
    private static final Logger LOG = Logger.getInstance(PuppetScopeManager.class);
    private final Map<PuppetEntity, GlobalSearchScope> myCache;

    public PuppetScopeManager(@NotNull Project project) {
        if (project == null) {
            PuppetScopeManager.$$$reportNull$$$0(0);
        }
        this.myCache = ConcurrentFactoryMap.createMap(PuppetEntity::calcResolveScope);
        project.getMessageBus().connect().subscribe(PuppetProjectManager.PUPPET_PROJECT_TOPIC, (Object)new PuppetProjectListener(){

            @Override
            public void projectUpdated() {
                PuppetScopeManager.this.clearCache();
            }
        });
    }

    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull PuppetEntity entity) {
        if (entity == null) {
            PuppetScopeManager.$$$reportNull$$$0(1);
        }
        return this.myCache.get(entity);
    }

    public void clearCache() {
        LOG.debug("Dropping scopes caches");
        this.myCache.clear();
    }

    public static PuppetScopeManager getInstance(@NotNull Project project) {
        if (project == null) {
            PuppetScopeManager.$$$reportNull$$$0(2);
        }
        return (PuppetScopeManager)ServiceManager.getService((Project)project, PuppetScopeManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/project/PuppetScopeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getResolveScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

