/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.puppet.ide.navigation.PuppetItemPresentation;
import com.intellij.lang.puppet.ide.structure.PuppetStructureViewModel;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightNamedElement;
import com.intellij.lang.puppet.psi.PuppetPolyNamedPsiElement;
import com.intellij.lang.puppet.psi.PuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.lang.puppet.psi.stubs.PuppetStubBasedPsiElement;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PuppetStructureViewElement
implements StructureViewTreeElement,
SortableTreeElement {
    @NotNull
    private final NavigatablePsiElement myElement;
    private final String myName;

    public PuppetStructureViewElement(@NotNull NavigatablePsiElement element, @NotNull String name) {
        if (element == null) {
            PuppetStructureViewElement.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PuppetStructureViewElement.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myName = name;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String location = "";
        if (this.myElement instanceof PuppetResourceInstanceDeclaration) {
            location = "[" + PuppetQualifiedNamesUtil.capitalizePuppetName(((PuppetResourceInstanceDeclaration)this.myElement).getEffectiveTypeName()) + "]";
        }
        PuppetItemPresentation puppetItemPresentation = PuppetItemPresentation.create(this.myName, location, this.myElement);
        if (puppetItemPresentation == null) {
            PuppetStructureViewElement.$$$reportNull$$$0(2);
        }
        return puppetItemPresentation;
    }

    public TreeElement @NotNull [] getChildren() {
        if (!this.myElement.isValid()) {
            if (TreeElement.EMPTY_ARRAY == null) {
                PuppetStructureViewElement.$$$reportNull$$$0(3);
            }
            return TreeElement.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        PuppetResolveUtil.processStubBasedChildrenWithSmartStop((PsiElement)this.myElement, PuppetStructureViewModel.NODE_ELEMENTS, (Processor<? super PuppetStubBasedPsiElement>)((Processor)element -> {
            if (element instanceof PuppetPolyNamedPsiElement) {
                for (PuppetDelegatingLightNamedElement lightNamedElement : ((PuppetPolyNamedPsiElement)((Object)element)).getLightElementsList()) {
                    String name = lightNamedElement.getName();
                    if (!StringUtil.isNotEmpty((String)name)) continue;
                    result.add(new PuppetStructureViewElement(lightNamedElement, name));
                }
            } else {
                String elementName = element.getName();
                if (StringUtil.isNotEmpty((String)elementName)) {
                    result.add(new PuppetStructureViewElement((NavigatablePsiElement)element, elementName));
                }
            }
            return true;
        }));
        TreeElement[] treeElementArray = result.toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            PuppetStructureViewElement.$$$reportNull$$$0(4);
        }
        return treeElementArray;
    }

    @NotNull
    public String getAlphaSortKey() {
        String string = this.myName;
        if (string == null) {
            PuppetStructureViewElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public Object getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/structure/PuppetStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/structure/PuppetStructureViewElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlphaSortKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

