/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRepository
extends TaskRepository {
    private static final Pattern PATTERN = Pattern.compile("[A-Z]+\\-\\d+");
    protected String myUsername = "";
    protected String myPassword = "";
    protected boolean myUseProxy;
    protected boolean myUseHttpAuthentication;
    protected boolean myLoginAnonymously;
    protected CustomTaskState myPreferredOpenTaskState;
    protected CustomTaskState myPreferredCloseTaskState;

    public BaseRepository(TaskRepositoryType type) {
        super(type);
    }

    public BaseRepository(BaseRepository other) {
        super((TaskRepository)other);
        this.myPassword = other.getPassword();
        this.myUsername = other.getUsername();
        this.myUseProxy = other.myUseProxy;
        this.myUseHttpAuthentication = other.myUseHttpAuthentication;
        this.myLoginAnonymously = other.myLoginAnonymously;
    }

    public BaseRepository() {
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    @Tag(value="username")
    public String getUsername() {
        return this.myUsername;
    }

    @Transient
    public String getPassword() {
        return this.myPassword;
    }

    @Tag(value="password")
    public String getEncodedPassword() {
        return null;
    }

    public void setEncodedPassword(String password) {
        try {
            this.setPassword(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void initializeRepository() {
        if (StringUtil.isEmpty((String)this.getPassword())) {
            CredentialAttributes attributes = this.getAttributes();
            Credentials credentials = PasswordSafe.getInstance().get(attributes);
            if (credentials != null) {
                this.setPassword(credentials.getPasswordAsString());
            }
        } else {
            this.storeCredentials();
        }
    }

    public void storeCredentials() {
        CredentialAttributes attributes = this.getAttributes();
        PasswordSafe.getInstance().set(attributes, new Credentials(this.getUsername(), this.getPassword()));
    }

    @NotNull
    protected CredentialAttributes getAttributes() {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"Tasks", (String)(this.getRepositoryType().getName() + " " + this.getUrl()));
        return new CredentialAttributes(serviceName, this.getUsername());
    }

    @NotNull
    public abstract BaseRepository clone();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRepository)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseRepository that = (BaseRepository)((Object)o);
        if (!Comparing.equal((String)this.getUrl(), (String)that.getUrl())) {
            return false;
        }
        if (!Comparing.equal((String)this.getPassword(), (String)that.getPassword())) {
            return false;
        }
        if (!Comparing.equal((String)this.getUsername(), (String)that.getUsername())) {
            return false;
        }
        if (!Comparing.equal((Object)this.isLoginAnonymously(), (Object)that.isLoginAnonymously())) {
            return false;
        }
        if (!Comparing.equal((Object)this.isUseProxy(), (Object)that.isUseProxy())) {
            return false;
        }
        return Comparing.equal((Object)this.isUseHttpAuthentication(), (Object)that.isUseHttpAuthentication());
    }

    public boolean isUseProxy() {
        return this.myUseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.myUseProxy = useProxy;
    }

    public boolean isUseHttpAuthentication() {
        return this.myUseHttpAuthentication;
    }

    public void setUseHttpAuthentication(boolean useHttpAuthentication) {
        this.myUseHttpAuthentication = useHttpAuthentication;
    }

    public boolean isLoginAnonymously() {
        return this.myLoginAnonymously;
    }

    public void setLoginAnonymously(boolean loginAnonymously) {
        this.myLoginAnonymously = loginAnonymously;
    }

    public void setPreferredOpenTaskState(@Nullable CustomTaskState state) {
        this.myPreferredOpenTaskState = state;
    }

    @Nullable
    public CustomTaskState getPreferredOpenTaskState() {
        return this.myPreferredOpenTaskState;
    }

    public void setPreferredCloseTaskState(@Nullable CustomTaskState state) {
        this.myPreferredCloseTaskState = state;
    }

    @Nullable
    public CustomTaskState getPreferredCloseTaskState() {
        return this.myPreferredCloseTaskState;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            BaseRepository.$$$reportNull$$$0(0);
        }
        return (matcher = PATTERN.matcher(taskName)).find() ? matcher.group() : null;
    }

    public void setUrl(String url) {
        super.setUrl(this.addSchemeIfNoneSpecified(url));
    }

    @NotNull
    protected String getDefaultScheme() {
        return "http";
    }

    @Nullable
    private String addSchemeIfNoneSpecified(@Nullable String url) {
        if (StringUtil.isNotEmpty((String)url)) {
            try {
                String scheme = new URI(url).getScheme();
                if (scheme == null) {
                    url = this.getDefaultScheme() + "://" + url;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/tasks/impl/BaseRepository", "extractId"));
    }
}

