/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.ws.rest.client.RESTClient;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RestClientFileUtil {
    private static final Logger LOG = Logger.getInstance(RESTClient.class);
    private static final String REST_CLIENT_ROOT = "dummy://restClient";
    private static int ourRequestCounter = 0;

    public static FileType findFileType(String mimeType) {
        Collection languages;
        PlainTextFileType fileType = PlainTextFileType.INSTANCE;
        if (mimeType != null && mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        if (RestClientFileUtil.isJson(languages = Language.findInstancesByMimeType((String)mimeType))) {
            return JsonFileType.INSTANCE;
        }
        for (Language language : languages) {
            LanguageFileType langFileType = language.getAssociatedFileType();
            if (langFileType == null) continue;
            fileType = langFileType;
            break;
        }
        return fileType;
    }

    private static boolean isJson(@NotNull Collection<Language> languages) {
        if (languages == null) {
            RestClientFileUtil.$$$reportNull$$$0(0);
        }
        for (Language language : languages) {
            if (language != JsonLanguage.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public static VirtualFile createFile(String response, FileType fileType) {
        return (VirtualFile)WriteAction.compute(() -> {
            VirtualFile result = null;
            VirtualFile dummyRoot = RestClientFileUtil.getOrCreateDummyRoot();
            try {
                result = DummyFileSystem.getInstance().createChildFile(null, dummyRoot, RestClientFileUtil.generateFilename(fileType));
                VfsUtil.saveText((VirtualFile)result, (String)response);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            return result;
        });
    }

    static void deleteFile(VirtualFile file) {
        if (file == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                DummyFileSystem.getInstance().deleteFile(null, file);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static String generateFilename(FileType fileType) {
        return "response" + ourRequestCounter++ + "." + fileType.getDefaultExtension();
    }

    private static VirtualFile getOrCreateDummyRoot() {
        VirtualFile dummyRoot = VirtualFileManager.getInstance().refreshAndFindFileByUrl(REST_CLIENT_ROOT);
        if (dummyRoot == null) {
            dummyRoot = DummyFileSystem.getInstance().createRoot("restClient");
        }
        return dummyRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languages", "com/intellij/ws/rest/client/RestClientFileUtil", "isJson"));
    }
}

