/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfigurationType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<HttpRequestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = HttpRequestRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfigurationWithDefaultEnv(@NotNull ConfigurationContext context) {
        if (context == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        RunManager runManager = RunManager.getInstance((Project)context.getProject());
        List configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            if (!this.checkExistingConfiguration(configurationSettings.getConfiguration(), context)) continue;
            return configurationSettings;
        }
        return null;
    }

    protected abstract boolean checkExistingConfiguration(@Nullable RunConfiguration var1, @NotNull ConfigurationContext var2);

    protected static int getRequestIndex(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks(request.getContainingFile());
        for (int i = 0; i < blocks.length; ++i) {
            HttpRequestBlock block = blocks[i];
            if (block.getRequest() != request) continue;
            return i + 1;
        }
        return -1;
    }

    @Nullable
    protected static HttpRequest findHttpRequestElement(@Nullable PsiElement element) {
        if (element == null || DumbService.getInstance((Project)element.getProject()).isDumb()) {
            return null;
        }
        if (element instanceof PsiDirectory || !(element.getContainingFile() instanceof HttpRequestPsiFile)) {
            return null;
        }
        if (element instanceof PsiFile) {
            HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)element);
            return blocks.length == 1 ? blocks[0].getRequest() : null;
        }
        PsiElement psi = element instanceof PsiWhiteSpace ? element.getPrevSibling() : element;
        HttpRequestBlock block = (HttpRequestBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{HttpRequestBlock.class});
        return block != null ? block.getRequest() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConfigurationWithDefaultEnv";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequestIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

