/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpClientExecutionController;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpRequestFileUpdater;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpRunRequestInfo;
import com.intellij.ws.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.ws.http.request.run.test.HttpMultiResponseConsole;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunHttpRequestProfileState
implements RunProfileState {
    private final Project myProject;
    private final HttpRequestExecutionConfig myConfig;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableSubstitutor mySubstitutor;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (config == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myProperties = properties;
        this.mySubstitutor = substitutor;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        HashMap copiedFiles = new HashMap();
        List requests = ContainerUtil.map(this.myConfig.getRequests(), request -> new RequestWithCopy((HttpRequest)request, copiedFiles));
        boolean hasResponseHandler = requests.stream().anyMatch(request -> ((RequestWithCopy)request).getOriginal().getResponseHandler() != null);
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler(hasResponseHandler);
        ArrayList<HttpRunRequestInfo> infos = new ArrayList<HttpRunRequestInfo>();
        for (RequestWithCopy request2 : requests) {
            infos.add(HttpRunRequestInfo.create(request2.getCopy(), (SmartPsiElementPointer<HttpRequest>)SmartPointerManager.createPointer((PsiElement)request2.getOriginal()), this.mySubstitutor));
        }
        final HttpResponseConsole console = this.createConsole(processHandler, infos);
        HttpRequestFileUpdater.prepareHttpRequestFiles(ContainerUtil.map((Collection)requests, rec$ -> ((RequestWithCopy)rec$).getCopy()));
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event2) {
                int exitCode;
                if (event2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event2.getExitCode()) != 0) {
                    String message = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    console.setErrorResponse(null, HttpResponsePresentation.createErrorResponse(message));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1", "processTerminated"));
            }
        });
        this.executeHttpRequest(this.myProject, infos.iterator(), processHandler, console, infos.size() == 1);
        return new DefaultExecutionResult((ExecutionConsole)console.getConsole(), (ProcessHandler)processHandler);
    }

    @NotNull
    private HttpResponseConsole createConsole(@NotNull HttpClientRequestProcessHandler processHandler, @NotNull List<HttpRunRequestInfo> requests) throws ExecutionException {
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (requests.isEmpty()) {
            throw new ExecutionException("No Requests to Execute");
        }
        if (requests.size() == 1) {
            HttpRunRequestInfo info = requests.get(0);
            RestClientRequest request = info.getRequest();
            String target = request.httpMethod + " " + request.toString() + "\n\n";
            boolean withPostProcessor = info.getResponseHandler() != null;
            return new HttpSingleResponseConsole(this.myProject, target, this.myProperties, processHandler, withPostProcessor);
        }
        return new HttpMultiResponseConsole(this.myProject, this.myProperties, processHandler);
    }

    private void executeHttpRequest(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(7);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(10);
        }
        if (!requests.hasNext()) {
            return;
        }
        try {
            this.createExecutionController(project, requests, processHandler, console, showResponseInplace).execute();
        }
        catch (ExecutionException e) {
            HttpRequestNotifications.showErrorBalloon(project, RestClientBundle.message("rest.client.request.execute.notification", new Object[0]), e.getMessage());
            processHandler.onRunFinished();
        }
    }

    @NotNull
    protected HttpClientExecutionController createExecutionController(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, boolean showResponseInplace) throws ExecutionException {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(11);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(12);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(13);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(14);
        }
        Runnable onRequestFinished = this.createOnFinished(project, console, processHandler, requests, showResponseInplace);
        HttpClientExecutionController httpClientExecutionController = HttpClientExecutionController.create(project, requests.next(), processHandler, console, onRequestFinished, showResponseInplace);
        if (httpClientExecutionController == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(15);
        }
        return httpClientExecutionController;
    }

    @NotNull
    private Runnable createOnFinished(@NotNull Project project, @NotNull HttpResponseConsole console, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull Iterator<HttpRunRequestInfo> requests, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(16);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(17);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(18);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(19);
        }
        Runnable runnable = () -> {
            if (requests.hasNext()) {
                this.executeHttpRequest(project, requests, processHandler, console, showResponseInplace);
            } else {
                processHandler.onRunFinished();
            }
        };
        if (runnable == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(20);
        }
        return runnable;
    }

    @NotNull
    private static HttpRequest createCopy(@NotNull HttpRequest psiRequest, Map<PsiFile, HttpRequestPsiFile> copiedFiles) {
        if (psiRequest == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(21);
        }
        PsiFile file = psiRequest.getContainingFile();
        HttpRequestPsiFile copiedFile = copiedFiles.computeIfAbsent(file, originalFile -> {
            PsiElement copiedElement = originalFile.copy();
            assert (copiedElement instanceof HttpRequestPsiFile);
            return (HttpRequestPsiFile)copiedElement;
        });
        PsiElement copiedElement = copiedFile.findElementAt(psiRequest.getTextOffset());
        HttpRequest parent = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)copiedElement, HttpRequest.class);
        assert (parent != null);
        HttpRequest httpRequest = parent;
        if (httpRequest == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(22);
        }
        return httpRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionController";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnFinished";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeHttpRequest";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionController";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOnFinished";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestWithCopy {
        private final HttpRequest myRequest;
        private final HttpRequest myCopy;

        RequestWithCopy(@NotNull HttpRequest request, @NotNull Map<PsiFile, HttpRequestPsiFile> copiedFiles) {
            if (request == null) {
                RequestWithCopy.$$$reportNull$$$0(0);
            }
            if (copiedFiles == null) {
                RequestWithCopy.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.myCopy = RunHttpRequestProfileState.createCopy(request, copiedFiles);
        }

        @NotNull
        private HttpRequest getOriginal() {
            HttpRequest httpRequest = this.myRequest;
            if (httpRequest == null) {
                RequestWithCopy.$$$reportNull$$$0(2);
            }
            return httpRequest;
        }

        @NotNull
        private HttpRequest getCopy() {
            HttpRequest httpRequest = this.myCopy;
            if (httpRequest == null) {
                RequestWithCopy.$$$reportNull$$$0(3);
            }
            return httpRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiedFiles";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$RequestWithCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$RequestWithCopy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

