/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpDifferenceFile;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.ws.http.request.run.HttpRequestPostProcessor;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestHistoryManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.HttpRequestHistoryManager");
    private static final String DEFAULT_HTTP_REQUESTS_ROOT = "/httpRequests";
    private static final String DEFAULT_LOG_FILE_NAME = PathUtil.makeFileName((String)"http-requests-log", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("hhmmss");
    private static final int CAPACITY = 50;
    @NotNull
    private final Project myProject;
    @Nullable
    private SmartPsiElementPointer<HttpRequestPsiFile> myLogFilePointer;

    public HttpRequestHistoryManager(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static HttpRequestHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(1);
        }
        return (HttpRequestHistoryManager)ServiceManager.getService((Project)project, HttpRequestHistoryManager.class);
    }

    @NotNull
    public synchronized String getLogDirectoryPath() {
        if (this.myLogFilePointer != null) {
            String directory;
            HttpRequestPsiFile file = (HttpRequestPsiFile)this.myLogFilePointer.getElement();
            String string = directory = file != null ? PathUtil.getParentPath((String)file.getVirtualFile().getPath()) : null;
            if (StringUtil.isNotEmpty((String)directory)) {
                String string2 = directory;
                if (string2 == null) {
                    HttpRequestHistoryManager.$$$reportNull$$$0(2);
                }
                return string2;
            }
        }
        return HttpRequestHistoryManager.getDefaultDirectoryPath(this.myProject);
    }

    @NotNull
    public static String getDefaultDirectoryPath(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(3);
        }
        String configRoot = ProjectKt.getStateStore((Project)project).getDirectoryStorePath(true);
        String string = configRoot + DEFAULT_HTTP_REQUESTS_ROOT;
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static VirtualFile findFile(@NotNull Project project, @NotNull String fileName) throws IOException {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String rootPath = HttpRequestHistoryManager.getDefaultDirectoryPath(project);
        String fullPath = rootPath + "/" + fileName;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fullPath);
        if (file != null && !file.isDirectory()) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> {
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            return dir.findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileName);
        });
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public void addToHistory(@NotNull RestClientRequest request, @Nullable RestClientResponse response) {
        if (request == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(9);
        }
        this.addToHistory(request, response, HttpRequestPostProcessor.EMPTY_PROCESSOR);
    }

    public void addToHistory(@NotNull RestClientRequest request, @Nullable RestClientResponse response, @NotNull HttpRequestPostProcessor processor) {
        if (request == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(11);
        }
        long time = System.currentTimeMillis();
        Runnable runnable = () -> {
            PsiDocumentManager manager;
            Document document;
            String fileName;
            VirtualFile logDirectory;
            HttpRequestPsiFile logFile;
            if (!request.config.isLogResponse()) {
                processor.onResponseExecuted(RestClientBundle.message("rest.client.cannot.execute.response.processor.log.disabled", new Object[0]));
                return;
            }
            try {
                logFile = this.getLogFile();
            }
            catch (HttpRequestInvalidLogFileException e) {
                LOG.warn("Cannot save HTTP request because log file doesn't exists");
                processor.onResponseExecuted(null);
                return;
            }
            VirtualFile virtualFile = logDirectory = logFile.getParent() != null ? logFile.getParent().getVirtualFile() : null;
            if (logDirectory == null) {
                LOG.warn("Cannot save response output because log directory is invalid");
            }
            String string = fileName = response != null && logDirectory != null ? this.createResponseFile(response, logDirectory, time) : null;
            if (LOG.isDebugEnabled() && StringUtil.isNotEmpty((String)fileName)) {
                LOG.debug("Saved response output in '" + fileName + "'");
            }
            processor.onResponseExecuted(fileName);
            String text = HttpRequestPsiConverter.toPsiHttpRequest(request, fileName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving: '" + text + "'");
            }
            if ((document = (manager = PsiDocumentManager.getInstance((Project)logFile.getProject())).getDocument((PsiFile)logFile)) != null) {
                HttpRequestBlock[] requests = HttpRequestPsiUtils.getRequestBlocks((PsiFile)logFile);
                if (requests.length >= this.getMaxHistorySize()) {
                    if (logDirectory != null) {
                        this.deleteHistoryFiles(logDirectory, requests[this.getMaxHistorySize() - 1]);
                    }
                    TextRange range = HttpRequestPsiUtils.getRequestsRange(requests[this.getMaxHistorySize() - 1], requests[requests.length - 1]);
                    boolean hasNextElement = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace((PsiElement)requests[requests.length - 1], true) != null;
                    int endOffset = hasNextElement ? range.getEndOffset() : document.getTextLength();
                    document.deleteString(range.getStartOffset(), endOffset);
                }
                document.insertString(0, (CharSequence)text);
                manager.commitDocument(document);
            }
        };
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, runnable, HttpRequestHistoryManager.getActionTitle(), null, UndoConfirmationPolicy.DEFAULT, false));
    }

    private void deleteHistoryFiles(@NotNull VirtualFile directory, @Nullable HttpRequestBlock request) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(12);
        }
        List<String> toDelete = HttpRequestHistoryManager.collectFilesToDelete(directory, request);
        for (String path : toDelete) {
            try {
                VirtualFile response = directory.getFileSystem().findFileByPath(path);
                if (response == null) {
                    LOG.debug("File with response output doesn't exists ('" + path + "')");
                    continue;
                }
                response.delete((Object)this);
                LOG.debug("Deleted " + path);
            }
            catch (Exception e) {
                LOG.warn("Cannot delete response output file ('" + path + "')", (Throwable)e);
            }
        }
    }

    @NotNull
    private static List<String> collectFilesToDelete(@NotNull VirtualFile directory, @Nullable HttpRequestBlock request) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(13);
        }
        SmartList paths = new SmartList();
        while (request != null) {
            List<HttpDifferenceFile> diffFiles = request.getRequest().getDifferenceFileList();
            for (HttpDifferenceFile diffFile : diffFiles) {
                HttpFilePath filePath = diffFile.getFilePath();
                if (filePath == null || FileUtil.isAbsolutePlatformIndependent((String)filePath.getPresentablePath())) continue;
                String presentablePath = PathUtil.toSystemIndependentName((String)filePath.getPresentablePath());
                String absolutePath = FileUtil.toCanonicalPath((String)(directory.getPath() + "/" + presentablePath), (char)'/');
                if (!FileUtil.isAncestor((String)directory.getPath(), (String)absolutePath, (boolean)false)) continue;
                paths.add(absolutePath);
            }
            request = (HttpRequestBlock)PsiTreeUtil.getNextSiblingOfType((PsiElement)request, HttpRequestBlock.class);
        }
        SmartList smartList = paths;
        if (smartList == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @Nullable
    private String createResponseFile(@NotNull RestClientResponse response, @NotNull VirtualFile logDirectory, long startTimeMs) {
        if (response == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(15);
        }
        if (logDirectory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(16);
        }
        if (response.getContentLength() == 0) {
            return null;
        }
        int code = response.getStatusLine().getStatusCode();
        FileType fileType = RestClientFileUtil.findFileType(response.getContentType().getMimeType());
        try {
            PsiFile file;
            String timestamp = this.timeToFileName(startTimeMs);
            String fileName = HttpRequestHistoryManager.unique(logDirectory, code, fileType, timestamp);
            VirtualFile responseFile = logDirectory.findOrCreateChildData((Object)this, fileName);
            VfsUtil.saveText((VirtualFile)responseFile, (String)response.getContent());
            if (fileType != PlainTextFileType.INSTANCE && !SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)responseFile) && (file = PsiManager.getInstance((Project)this.myProject).findFile(responseFile)) != null) {
                PsiFile[] files = new PsiFile[]{file};
                new ReformatCodeProcessor(this.myProject, files, HttpRequestHistoryManager.getReformatResponseCommand(), null, false).run();
            }
            return fileName;
        }
        catch (IOException e) {
            LOG.warn("Cannot create file with response output", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static String unique(@NotNull VirtualFile root, int code, @NotNull FileType fileType, @NotNull String timestamp) {
        String fileName;
        if (root == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(17);
        }
        if (fileType == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(18);
        }
        if (timestamp == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(19);
        }
        if (root.findChild(fileName = PathUtil.makeFileName((String)(timestamp + "." + code), (String)fileType.getDefaultExtension())) == null) {
            String string = fileName;
            if (string == null) {
                HttpRequestHistoryManager.$$$reportNull$$$0(20);
            }
            return string;
        }
        int counter = 1;
        while (root.findChild(fileName) != null) {
            fileName = PathUtil.makeFileName((String)(timestamp + "-" + counter + "." + code), (String)fileType.getDefaultExtension());
            ++counter;
        }
        String string = fileName;
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    protected String timeToFileName(long startTimeMs) {
        Date date = new Date(startTimeMs);
        String string = DATE_FORMAT.format(date) + "T" + TIME_FORMAT.format(date);
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    protected int getMaxHistorySize() {
        return 50;
    }

    @NotNull
    public synchronized HttpRequestPsiFile getLogFile() throws HttpRequestInvalidLogFileException {
        HttpRequestPsiFile file2;
        if (this.myLogFilePointer == null || this.myLogFilePointer.getElement() == null) {
            try {
                VirtualFile log = HttpRequestHistoryManager.findFile(this.myProject, DEFAULT_LOG_FILE_NAME);
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(log);
                if (psiFile instanceof HttpRequestPsiFile) {
                    this.myLogFilePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)((HttpRequestPsiFile)psiFile));
                } else {
                    if (FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(log)) {
                        VirtualFile parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(file)));
                        throw HttpRequestInvalidLogFileException.createIgnoredLogException(this.myProject, parent.getPath());
                    }
                    if (Registry.is((String)"ide.hide.excluded.files") && FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(log)) {
                        VirtualFile parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(file)));
                        throw HttpRequestInvalidLogFileException.createExcludedLogException(parent.getPath());
                    }
                    if (psiFile != null && log.isValid() && !log.isDirectory() && !this.myProject.isDefault()) {
                        throw HttpRequestInvalidLogFileException.createInvalidTypeException(this.myProject, psiFile.getFileType());
                    }
                    LOG.error("HTTP Requests Log file is invalid: " + psiFile + ". Path: '" + log.getPresentableUrl() + "', valid: " + log.isValid() + ", dir: " + log.isDirectory() + ", default project: " + this.myProject.isDefault());
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        HttpRequestPsiFile httpRequestPsiFile = file2 = this.myLogFilePointer != null ? (HttpRequestPsiFile)this.myLogFilePointer.getElement() : null;
        if (file2 == null) {
            throw new HttpRequestInvalidLogFileException();
        }
        HttpRequestPsiFile httpRequestPsiFile2 = file2;
        if (httpRequestPsiFile2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(23);
        }
        return httpRequestPsiFile2;
    }

    @NotNull
    private static VirtualFile getParentByCondition(@NotNull VirtualFile file, @NotNull Condition<VirtualFile> condition) {
        if (file == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(24);
        }
        if (condition == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(25);
        }
        VirtualFile target = file;
        while (file != null && condition.value((Object)file)) {
            target = file;
            file = file.getParent();
        }
        VirtualFile virtualFile = target;
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(26);
        }
        return virtualFile;
    }

    public synchronized void setLogFile(@NotNull HttpRequestPsiFile logfile) {
        if (logfile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(27);
        }
        this.myLogFilePointer = SmartPointerManager.getInstance((Project)logfile.getProject()).createSmartPsiElementPointer((PsiElement)logfile);
    }

    private static String getActionTitle() {
        return RestClientBundle.message("http.request.save.log.file.action.title", new Object[0]);
    }

    private static String getReformatResponseCommand() {
        return RestClientBundle.message("http.request.reformat.response.action.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDirectoryPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDirectoryPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesToDelete";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "timeToFileName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentByCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDirectoryPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteHistoryFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesToDelete";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createResponseFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getParentByCondition";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setLogFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

