/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.json.JsonUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientDynamicVariablesStubController
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.HttpClientDynamicVariablesStubController");
    private static final AtomicNullableLazyValue<VirtualFile> DYNAMIC_VARIABLES_STUB = new AtomicNullableLazyValue<VirtualFile>(){

        @Nullable
        protected VirtualFile compute() {
            URL stubFileUrl = HttpClientDynamicVariablesStubController.class.getResource("/com/intellij/ws/rest/client/stubs/http-dynamic-variables.json");
            if (stubFileUrl == null) {
                LOG.warn("Can not find URL for 'http-dynamic-variables.json', the installation is possibly broken.");
                return null;
            }
            VirtualFile file = VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.convertFromUrl((URL)stubFileUrl));
            if (file == null) {
                LOG.warn("Can not find 'http-dynamic-variables.json' by url " + stubFileUrl.toExternalForm());
                return null;
            }
            return file;
        }
    };

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        VirtualFile stubFile = HttpClientDynamicVariablesStubController.getStubVirtualFile();
        if (stubFile != null) {
            HashSet hashSet = ContainerUtil.newHashSet((Object[])new VirtualFile[]{stubFile});
            if (hashSet == null) {
                HttpClientDynamicVariablesStubController.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            HttpClientDynamicVariablesStubController.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static VirtualFile getStubVirtualFile() {
        return (VirtualFile)DYNAMIC_VARIABLES_STUB.getValue();
    }

    @NotNull
    static Map<String, String> loadDescriptions() {
        Document document;
        HashMap<String, String> result = new HashMap<String, String>();
        VirtualFile virtualFile = (VirtualFile)DYNAMIC_VARIABLES_STUB.getValue();
        if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
            String text = document.getText();
            try {
                JsonObject dynamicVariables;
                JsonObject root = (JsonObject)JsonUtil.as((Object)new JsonParser().parse(text), JsonObject.class);
                JsonObject jsonObject = dynamicVariables = root != null ? (JsonObject)JsonUtil.as((Object)root.get("dynamicVariables"), JsonObject.class) : null;
                if (dynamicVariables != null) {
                    for (Map.Entry entry : dynamicVariables.entrySet()) {
                        JsonPrimitive sampleValue;
                        String variableName = (String)entry.getKey();
                        JsonObject variableProperties = (JsonObject)JsonUtil.as(entry.getValue(), JsonObject.class);
                        JsonPrimitive description = variableProperties != null ? (JsonPrimitive)JsonUtil.as((Object)variableProperties.get("description"), JsonPrimitive.class) : null;
                        JsonPrimitive jsonPrimitive = sampleValue = variableProperties != null ? (JsonPrimitive)JsonUtil.as((Object)variableProperties.get("sample-value"), JsonPrimitive.class) : null;
                        if (variableName == null || description == null || sampleValue == null) continue;
                        result.put(variableName, description.getAsString() + "<br/>Sample value: " + sampleValue.getAsString());
                    }
                }
            }
            catch (JsonParseException ex) {
                LOG.warn("Cannot read 'http-dynamic-variables.json' as JSON file, the installation is possibly broken.", (Throwable)ex);
            }
        }
        Map<String, String> map = Collections.unmodifiableMap(result);
        if (map == null) {
            HttpClientDynamicVariablesStubController.$$$reportNull$$$0(2);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ws/http/request/run/HttpClientDynamicVariablesStubController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRootsToIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

