/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.refactoring;

import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFactory;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpInputFile;
import com.intellij.ws.http.request.psi.HttpMultipartMessage;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.ws.http.request.refactoring.HttpMoveRequestSettings;
import com.intellij.ws.http.request.refactoring.HttpRequestRefactoringException;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.rest.client.RestClientBundle;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpMoveRequestProcessor
extends BaseRefactoringProcessor {
    private static final int PREFERRED_LINE_BREAKS_COUNT = 2;
    private final HttpMoveRequestSettings mySettings;

    protected HttpMoveRequestProcessor(@NotNull Project project, @NotNull HttpMoveRequestSettings settings) {
        if (project == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project);
        this.mySettings = settings;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(2);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = HttpMoveRequestProcessor.this.mySettings.getRequestBlocks().toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return HttpMoveRequestProcessor.getRefactoringName();
            }

            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return HttpMoveRequestProcessor.getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/http/request/refactoring/HttpMoveRequestProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(3);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        List<HttpRequestBlock> oldBlocks;
        PsiFile oldFile;
        HttpRequestBlock[] requests;
        if (usages == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(4);
        }
        if ((requests = HttpRequestPsiUtils.getRequestBlocks(oldFile = (oldBlocks = this.mySettings.getRequestBlocks()).get(0).getContainingFile())).length == 0) {
            HttpMoveRequestProcessor.showErrorHint(this.myProject, RestClientBundle.message("rest.client.refactoring.no.requests", new Object[0]));
            return;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = manager.getDocument(oldFile);
        if (document == null) {
            HttpMoveRequestProcessor.showErrorHint(this.myProject, RestClientBundle.message("rest.client.refactoring.file.is.invalid", new Object[0]));
            return;
        }
        int additionalLineBreaks = 0;
        StringBuilder requestsBuilder = new StringBuilder();
        for (HttpRequestBlock oldBlock : oldBlocks) {
            TextRange range = HttpMoveRequestProcessor.getRequestRange(oldBlock, requests);
            int end = range.getEndOffset();
            boolean endsWithLineSeparator = range.getStartOffset() <= end - 1 && end < document.getTextLength() && document.getLineNumber(end - 1) != document.getLineNumber(end);
            HttpRequestPsiFile fileWithRequest = HttpRequestPsiFactory.createDummyFile(this.myProject, document.getText(range) + (endsWithLineSeparator ? "" : "\n"));
            HttpRequestBlock newRequestBlock = (HttpRequestBlock)ArrayUtil.getFirstElement((Object[])HttpRequestPsiUtils.getRequestBlocks((PsiFile)fileWithRequest));
            if (newRequestBlock == null) {
                HttpMoveRequestProcessor.showErrorHint(this.myProject, RestClientBundle.message("rest.client.refactoring.request.is.invalid", new Object[0]));
                return;
            }
            HttpRequest newRequest = newRequestBlock.getRequest();
            HttpRequest request = oldBlock.getRequest();
            String newRootDirectory = PathUtil.getParentPath((String)this.mySettings.getTargetPath());
            HttpMoveRequestProcessor.updateReferences(this.myProject, newRootDirectory, HttpMoveRequestProcessor.toInputFiles(request), HttpMoveRequestProcessor.toInputFiles(newRequest));
            HttpMoveRequestProcessor.updateReferences(this.myProject, newRootDirectory, HttpMoveRequestProcessor.toDiffFiles(request), HttpMoveRequestProcessor.toDiffFiles(newRequest));
            String requestText = fileWithRequest.getText();
            requestsBuilder.append(requestText);
            int lineBreaksAtEnd = HttpMoveRequestProcessor.countLineBreaksAtEnd(requestText);
            if (lineBreaksAtEnd >= 2) continue;
            additionalLineBreaks = 2 - lineBreaksAtEnd;
            requestsBuilder.append(StringUtil.repeat((String)"\n", (int)additionalLineBreaks));
        }
        if (additionalLineBreaks > 0) {
            requestsBuilder.deleteCharAt(requestsBuilder.length() - 1);
        }
        HttpRequestPsiFile toMove = HttpRequestPsiFactory.createDummyFile(this.myProject, requestsBuilder.toString());
        try {
            VirtualFile targetFile = this.moveRequest(this.mySettings.getTargetPath(), toMove);
            if (requests.length > oldBlocks.size()) {
                for (HttpRequestBlock oldBlock : oldBlocks) {
                    int line;
                    TextRange range = HttpMoveRequestProcessor.getRequestRange(oldBlock, requests);
                    int end = range.getEndOffset();
                    int n = line = end < document.getTextLength() ? document.getLineNumber(range.getEndOffset()) : -1;
                    if (line > 0 && document.getLineCount() > line + 1 && document.getLineStartOffset(line + 1) - 1 == range.getEndOffset()) {
                        ++end;
                    }
                    document.deleteString(range.getStartOffset(), end);
                    manager.commitDocument(document);
                }
            } else {
                oldFile.delete();
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                OpenFileAction.openFile((VirtualFile)targetFile, (Project)this.myProject);
                Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
                assert (editor != null);
                editor.getCaretModel().moveToOffset(0);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
        catch (IncorrectOperationException | HttpRequestRefactoringException | IOException e) {
            HttpMoveRequestProcessor.showErrorHint(this.myProject, e.getMessage());
        }
    }

    private static void updateReferences(@NotNull Project project, @NotNull String newRootDirectory, @NotNull List<HttpFilePath> oldFileReferences, @NotNull List<HttpFilePath> newFileReferences) {
        if (project == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(5);
        }
        if (newRootDirectory == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(6);
        }
        if (oldFileReferences == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(7);
        }
        if (newFileReferences == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(8);
        }
        assert (oldFileReferences.size() == newFileReferences.size());
        for (int i = 0; i < newFileReferences.size(); ++i) {
            String newReference = HttpMoveRequestProcessor.toNewFileReference(oldFileReferences.get(i), newRootDirectory);
            if (!StringUtil.isNotEmpty((String)newReference)) continue;
            HttpFilePath newFile = newFileReferences.get(i);
            newFile.replace((PsiElement)HttpRequestPsiFactory.createFilePath(project, newReference));
        }
    }

    @Nullable
    private static String toNewFileReference(@Nullable HttpFilePath oldFileReference, @NotNull String newRootDirectory) {
        PsiFile resolved;
        if (newRootDirectory == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(9);
        }
        if ((resolved = FileReferenceUtil.findFile((PsiElement)oldFileReference)) == null) {
            return null;
        }
        String logDirectory = HttpRequestHistoryManager.getInstance(oldFileReference.getProject()).getLogDirectoryPath();
        if (!FileUtil.isAncestor((String)logDirectory, (String)resolved.getVirtualFile().getPath(), (boolean)false)) {
            return FileUtil.getRelativePath((String)newRootDirectory, (String)resolved.getVirtualFile().getPath(), (char)'/');
        }
        return null;
    }

    @NotNull
    private static List<HttpFilePath> toInputFiles(@NotNull HttpRequest request) {
        HttpRequestBody body;
        if (request == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(10);
        }
        if ((body = request.getRequestBody()) instanceof HttpRequestMessagesGroup) {
            List<HttpFilePath> list = HttpMoveRequestProcessor.toInputFiles(((HttpRequestMessagesGroup)body).getRequestMessageList()).collect(Collectors.toList());
            if (list == null) {
                HttpMoveRequestProcessor.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (body instanceof HttpMultipartMessage) {
            List<HttpFilePath> list = ((HttpMultipartMessage)body).getMultipartFieldList().stream().flatMap(field -> HttpMoveRequestProcessor.toInputFiles(field.getRequestMessages())).collect(Collectors.toList());
            if (list == null) {
                HttpMoveRequestProcessor.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static Stream<HttpFilePath> toInputFiles(@NotNull List<HttpRequestMessage> messages) {
        if (messages == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(14);
        }
        Stream<HttpFilePath> stream = messages.stream().filter(message -> message instanceof HttpInputFile).map(file -> ((HttpInputFile)file).getFilePath());
        if (stream == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @NotNull
    private static List<HttpFilePath> toDiffFiles(@NotNull HttpRequest request) {
        if (request == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(16);
        }
        List list = ContainerUtil.map(request.getDifferenceFileList(), file -> file.getFilePath());
        if (list == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private VirtualFile moveRequest(@NotNull String path, @NotNull HttpRequestPsiFile toMove) throws IOException, HttpRequestRefactoringException {
        String extension;
        if (path == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(18);
        }
        if (toMove == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(19);
        }
        boolean noExtension = StringUtil.isEmpty((String)(extension = PathUtil.getFileExtension((String)PathUtil.getFileName((String)path)))) || StreamEx.of((Object[])HttpRequestFileType.INSTANCE.getExtensions()).noneMatch(ext -> StringUtil.equalsIgnoreCase((CharSequence)ext, (CharSequence)extension));
        String fullPath = noExtension ? PathUtil.makeFileName((String)path, (String)HttpRequestFileType.INSTANCE.getDefaultExtension()) : path;
        VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(fullPath);
        if (targetFile == null) {
            String requestText = toMove.getText();
            String additionalLineBreak = "";
            if (HttpMoveRequestProcessor.countLineBreaksAtEnd(requestText) < 2) {
                additionalLineBreak = "\n";
            }
            targetFile = this.moveToNewFile(requestText + additionalLineBreak + HttpRequestPsiConverter.getSeparator(), fullPath);
        } else {
            this.moveToExistingFile(toMove.getText(), targetFile);
        }
        VirtualFile virtualFile = targetFile;
        if (virtualFile == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @NotNull
    private static TextRange getRequestRange(HttpRequestBlock request, HttpRequestBlock[] requests) {
        TextRange range = HttpRequestPsiUtils.getRequestsRange(request, request);
        TextRange textRange = (requests.length == 1 || requests.length > 1 && requests[0].equals(request)) && range.getStartOffset() > 0 ? new TextRange(0, range.getEndOffset()) : range;
        if (textRange == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    @NotNull
    private VirtualFile moveToNewFile(@NotNull String request, @NotNull String path) throws IOException, IncorrectOperationException {
        String directoryPath;
        PsiDirectory directory;
        if (request == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(22);
        }
        if (path == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(23);
        }
        if ((directory = HttpMoveRequestProcessor.createDirectoryIfMissing(this.myProject, directoryPath = PathUtil.getParentPath((String)path))) != null) {
            String fileName = PathUtil.getFileName((String)path);
            PsiFile newRequestFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, (FileType)HttpRequestFileType.INSTANCE, (CharSequence)request);
            PsiElement result = directory.add((PsiElement)newRequestFile);
            VirtualFile file = result.getContainingFile().getVirtualFile();
            if (file != null) {
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    HttpMoveRequestProcessor.$$$reportNull$$$0(24);
                }
                return virtualFile;
            }
        }
        throw new IOException(RestClientBundle.message("rest.client.refactoring.cannot.create.file", new Object[0]));
    }

    private void moveToExistingFile(@NotNull String request, @NotNull VirtualFile file) throws HttpRequestRefactoringException {
        PsiFile psiFile;
        if (request == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(25);
        }
        if (file == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(26);
        }
        if (!((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) instanceof HttpRequestPsiFile)) {
            throw new HttpRequestRefactoringException(RestClientBundle.message("rest.client.refactoring.target.file.is.invalid", new Object[0]));
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = manager.getDocument(psiFile);
        if (document == null) {
            throw new HttpRequestRefactoringException(RestClientBundle.message("rest.client.refactoring.target.file.is.invalid", new Object[0]));
        }
        int indexOfFirstNotSeparator = HttpMoveRequestProcessor.indexOfFirstNotSeparator(psiFile);
        if (indexOfFirstNotSeparator >= 0) {
            document.insertString(indexOfFirstNotSeparator, (CharSequence)(HttpRequestPsiConverter.getSeparator() + "\n"));
        }
        if (!HttpMoveRequestProcessor.hasFirstLineBreak(document) && HttpMoveRequestProcessor.countLineBreaksAtEnd(request) < 2) {
            document.insertString(0, (CharSequence)"\n");
        }
        document.insertString(0, (CharSequence)request);
        manager.commitDocument(document);
    }

    private static int indexOfFirstNotSeparator(@NotNull PsiFile psiFile) {
        PsiElement firstChild;
        if (psiFile == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(27);
        }
        if ((firstChild = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(psiFile.getFirstChild(), false)) instanceof HttpRequestBlock) {
            firstChild = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(firstChild.getFirstChild(), false);
        }
        if (firstChild != null) {
            if (!HttpRequestPsiUtils.isOfType(firstChild, HttpRequestElementTypes.REQUEST_SEPARATOR)) {
                return firstChild.getTextOffset();
            }
            return -1;
        }
        return 0;
    }

    private static boolean hasFirstLineBreak(@NotNull Document document) {
        if (document == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(28);
        }
        CharSequence text = document.getCharsSequence();
        for (int index = 0; index < text.length() && StringUtil.isWhiteSpace((char)text.charAt(index)); ++index) {
            if (!StringUtil.isLineBreak((char)text.charAt(index))) continue;
            return true;
        }
        return false;
    }

    private static int countLineBreaksAtEnd(@NotNull String text) {
        if (text == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(29);
        }
        int res = 0;
        for (int index = text.length() - 1; index >= 0 && StringUtil.isWhiteSpace((char)text.charAt(index)); --index) {
            if (!StringUtil.isLineBreak((char)text.charAt(index))) continue;
            ++res;
        }
        return res;
    }

    @Nullable
    private static PsiDirectory createDirectoryIfMissing(@NotNull Project project, @NotNull String path) throws IOException {
        VirtualFile directory;
        if (project == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(30);
        }
        if (path == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(31);
        }
        return (directory = VfsUtil.createDirectoryIfMissing((String)path)) != null ? PsiManager.getInstance((Project)project).findDirectory(directory) : null;
    }

    private static void showErrorHint(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(32);
        }
        if (message == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(33);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
    }

    @NotNull
    protected String getCommandName() {
        String string = HttpMoveRequestProcessor.getRefactoringName();
        if (string == null) {
            HttpMoveRequestProcessor.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static String getRefactoringName() {
        return RestClientBundle.message("rest.client.refactoring.move.request.name", new Object[0]);
    }

    private static String getDescription() {
        return RestClientBundle.message("rest.client.refactoring.move.request.description", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestProcessor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRootDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileReferences";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileReferences";
                break;
            }
            case 10: 
            case 16: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 18: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toInputFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toDiffFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "moveRequest";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestRange";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "moveToNewFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toNewFileReference";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toInputFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toDiffFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveRequest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveToNewFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "moveToExistingFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "indexOfFirstNotSeparator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasFirstLineBreak";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaksAtEnd";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryIfMissing";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

