/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.refactoring;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.refactoring.HttpMoveRequestProcessor;
import com.intellij.ws.http.request.refactoring.HttpMoveRequestSettings;
import com.intellij.ws.rest.client.RestClientBundle;
import icons.RestClientIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpMoveRequestDelegate
extends MoveHandlerDelegate {
    private static final String DEFAULT_NAME = "http-request.http";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (HttpMoveRequestDelegate.findHttpRequest(element) != null) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Nullable
    private static HttpRequestBlock findHttpRequest(@NotNull PsiElement element) {
        if (element == null) {
            HttpMoveRequestDelegate.$$$reportNull$$$0(0);
        }
        if (element.getContainingFile() instanceof HttpRequestPsiFile) {
            return (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequestBlock.class);
        }
        return null;
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        HttpRequestBlock toMove = HttpMoveRequestDelegate.findHttpRequest(element);
        if (toMove != null) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)HttpMoveRequestDelegate.getRefactoringName(), null);
                return true;
            }
            this.doMove(project, new PsiElement[]{toMove}, null, null);
            return true;
        }
        return false;
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        HttpRequestBlock request;
        ExtractHttpRequestFileDialog dialog;
        if (elements.length == 1 && elements[0] instanceof HttpRequestBlock && (dialog = new ExtractHttpRequestFileDialog(project, request = (HttpRequestBlock)elements[0])).showAndGet()) {
            new HttpMoveRequestProcessor(project, new HttpMoveRequestSettings(dialog.getSelectedRequests(), dialog.getTargetPath())).run();
        }
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            HttpMoveRequestDelegate.$$$reportNull$$$0(1);
        }
        return language == HttpRequestLanguage.INSTANCE;
    }

    private static String getRefactoringName() {
        return RestClientBundle.message("rest.client.refactoring.move.request.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findHttpRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HttpRequestMemberPanel
    extends MemberSelectionPanelBase<HttpRequestBlock, HttpRequestMemberInfo, HttpRequestMemberTable> {
        private final JComponent mySelectDeselectToolbar;

        HttpRequestMemberPanel(String title, HttpRequestBlock selectedRequest) {
            super(title, (AbstractMemberSelectionTable)new HttpRequestMemberTable(HttpRequestMemberPanel.getMemberInfoFromSelected(selectedRequest)));
            AnAction selectAllAction = new AnAction(RefactoringBundle.message((String)"select.all.button")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ((HttpRequestMemberTable)this.getTable()).selectAllMembers(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$HttpRequestMemberPanel$1", "actionPerformed"));
                }
            };
            AnAction unselectAllAction = new AnAction(RefactoringBundle.message((String)"unselect.all.button")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ((HttpRequestMemberTable)this.getTable()).selectAllMembers(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$HttpRequestMemberPanel$2", "actionPerformed"));
                }
            };
            this.mySelectDeselectToolbar = ActionManager.getInstance().createButtonToolbar("unknown", (ActionGroup)new DefaultActionGroup(new AnAction[]{selectAllAction, unselectAllAction}));
        }

        private static Collection<HttpRequestMemberInfo> getMemberInfoFromSelected(HttpRequestBlock selectedRequest) {
            return Arrays.stream(HttpRequestPsiUtils.getRequestBlocks(selectedRequest.getContainingFile())).map(block -> new HttpRequestMemberInfo((HttpRequestBlock)block)).peek(info -> {
                if (((HttpRequestBlock)info.getMember()).equals(selectedRequest)) {
                    info.setChecked(true);
                }
            }).collect(Collectors.toList());
        }

        @NotNull
        JComponent getSelectDeselectButtons() {
            JComponent jComponent = this.mySelectDeselectToolbar;
            if (jComponent == null) {
                HttpRequestMemberPanel.$$$reportNull$$$0(0);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$HttpRequestMemberPanel", "getSelectDeselectButtons"));
        }
    }

    private static class HttpRequestMemberTable
    extends AbstractMemberSelectionTable<HttpRequestBlock, HttpRequestMemberInfo> {
        HttpRequestMemberTable(Collection<HttpRequestMemberInfo> memberInfos) {
            super(memberInfos, null, null);
        }

        @Nullable
        protected Object getAbstractColumnValue(HttpRequestMemberInfo memberInfo) {
            return null;
        }

        protected boolean isAbstractColumnEditable(int rowIndex) {
            return false;
        }

        protected Icon getOverrideIcon(HttpRequestMemberInfo memberInfo) {
            return null;
        }

        protected void setVisibilityIcon(HttpRequestMemberInfo memberInfo, com.intellij.ui.RowIcon icon) {
        }

        protected void setVisibilityIcon(HttpRequestMemberInfo memberInfo, RowIcon icon) {
        }

        protected Icon getMemberIcon(HttpRequestMemberInfo memberInfo, int flags) {
            return RestClientIcons.Request;
        }

        void selectAllMembers(boolean selected) {
            for (HttpRequestMemberInfo memberInfo : this.myMemberInfos) {
                memberInfo.setChecked(selected);
            }
            this.redraw();
        }
    }

    private static class HttpRequestMemberInfo
    extends MemberInfoBase<HttpRequestBlock> {
        HttpRequestMemberInfo(HttpRequestBlock member) {
            super((PsiElement)member);
        }

        public boolean isStatic() {
            return false;
        }

        public String getDisplayName() {
            String result = ((HttpRequestBlock)this.getMember()).getRequest().getHttpMethod();
            if (((HttpRequestBlock)this.getMember()).getRequest().getRequestTarget() != null) {
                result = result + " " + ((HttpRequestBlock)this.getMember()).getRequest().getRequestTarget().getText();
            }
            return result;
        }
    }

    private static class HttpFileInfo {
        private final String myFileUrl;
        private final boolean myIsScratch;

        private HttpFileInfo(String fileUrl, boolean isScratch) {
            this.myFileUrl = fileUrl;
            this.myIsScratch = isScratch;
        }

        private String getFileUrl() {
            return this.myFileUrl;
        }

        private boolean isScratch() {
            return this.myIsScratch;
        }
    }

    private static class ExtractHttpRequestFileDialog
    extends DialogWrapper {
        private final TextFieldWithHistoryWithBrowseButton myPathTextField;
        private final HttpRequestMemberPanel myHttpRequestMemberPanel;
        private final Project myProject;
        private final HttpRequestBlock myRequest;

        protected ExtractHttpRequestFileDialog(@NotNull Project project, @NotNull HttpRequestBlock request) {
            if (project == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(1);
            }
            super(project, false);
            this.myProject = project;
            this.myRequest = request;
            List<HttpFileInfo> history = this.getTargetFileVariants();
            this.myPathTextField = new TextFieldWithHistoryWithBrowseButton();
            ((TextFieldWithHistory)this.myPathTextField.getChildComponent()).setHistory(ContainerUtil.map(history, rec$ -> ((HttpFileInfo)rec$).getFileUrl()));
            ((TextFieldWithHistory)this.myPathTextField.getChildComponent()).setHistorySize(history.size());
            Set scratches = history.stream().filter(rec$ -> ((HttpFileInfo)rec$).isScratch()).map(rec$ -> ((HttpFileInfo)rec$).getFileUrl()).collect(Collectors.toSet());
            Icon scratchIcon = ExtractHttpRequestFileDialog.getScratchIcon();
            ((TextFieldWithHistory)this.myPathTextField.getChildComponent()).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                label.setText(value);
                if (scratches.contains(value)) {
                    label.setIcon(scratchIcon);
                } else {
                    label.setIcon(RestClientIcons.Http_requests_filetype);
                }
            }));
            this.myHttpRequestMemberPanel = new HttpRequestMemberPanel("Requests", this.myRequest);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false).withFileFilter(file -> file.isDirectory() || Arrays.stream(HttpRequestFileType.INSTANCE.getExtensions()).anyMatch(ext -> ext.equals(file.getExtension())));
            String title = RestClientBundle.message("rest.client.refactoring.ui.browse.select.path", new Object[0]);
            String description = RestClientBundle.message("rest.client.refactoring.ui.browse.select.path.description", new Object[0]);
            this.myPathTextField.addBrowseFolderListener(title, description, project, descriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
            VirtualFile directory = ExtractHttpRequestFileDialog.getDefaultDirectory(project, request);
            if (directory != null) {
                this.myPathTextField.setText(directory.getPresentableUrl() + File.separator + HttpMoveRequestDelegate.DEFAULT_NAME);
            }
            this.setTitle(HttpMoveRequestDelegate.getRefactoringName());
            this.init();
        }

        @NotNull
        private static @NotNull Stream<@NotNull VirtualFile> getAllHttpClientFilesInProject(@NotNull Project project) {
            if (project == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(2);
            }
            GlobalSearchScope searchScope = ProjectScope.getContentScope((Project)project).uniteWith(ScratchesSearchScope.getScratchesScope((Project)project));
            Stream<VirtualFile> stream = Arrays.stream(HttpRequestFileType.INSTANCE.getExtensions()).flatMap(ext -> FilenameIndex.getAllFilesByExt((Project)project, (String)ext, (GlobalSearchScope)searchScope).stream());
            if (stream == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(3);
            }
            return stream;
        }

        @NotNull
        private List<HttpFileInfo> getTargetFileVariants() {
            List<HttpFileInfo> list = ExtractHttpRequestFileDialog.getAllHttpClientFilesInProject(this.myProject).filter(file -> !file.equals(this.getCurrentVirtualFile())).map(file -> Pair.create((Object)file, (Object)ScratchRootType.getInstance().containsFile(file))).map(fileInfo -> new HttpFileInfo(((VirtualFile)fileInfo.getFirst()).getPresentableUrl(), (Boolean)fileInfo.getSecond())).collect(Collectors.toList());
            if (list == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        private VirtualFile getCurrentVirtualFile() {
            PsiFile file = this.myRequest.getContainingFile();
            return file != null ? file.getVirtualFile() : null;
        }

        @NotNull
        private static Icon getScratchIcon() {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(RestClientIcons.Http_requests_filetype, 0);
            icon.setIcon(AllIcons.Actions.Scratch, 1);
            LayeredIcon layeredIcon = icon;
            if (layeredIcon == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(5);
            }
            return layeredIcon;
        }

        @Nullable
        private static VirtualFile getDefaultDirectory(@NotNull Project project, @NotNull HttpRequestBlock request) {
            PsiDirectory parentDirectory;
            PsiFile file;
            if (project == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(6);
            }
            if (request == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(7);
            }
            if ((file = request.getContainingFile()) != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file.getVirtualFile()) && (parentDirectory = file.getParent()) != null) {
                return parentDirectory.getVirtualFile();
            }
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                ContentEntry[] contentEntries = ModuleRootManager.getInstance((Module)modules[0]).getContentEntries();
                return contentEntries.length > 0 ? contentEntries[0].getFile() : null;
            }
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(RestClientBundle.message("rest.client.refactoring.ui.path.label", new Object[0]));
            GridBag bag = new GridBag().anchor(17).fillCell().coverLine(1).coverColumn(1).weightx(0.0).weighty(0.0).setColumn(0).setLine(1);
            panel.add((Component)label, bag);
            panel.add((Component)this.myPathTextField, bag.weightx(1.0).setColumn(1));
            JPanel resultPanel = new JPanel(new BorderLayout());
            resultPanel.add((Component)panel, "North");
            resultPanel.add((Component)((Object)this.myHttpRequestMemberPanel), "Center");
            return resultPanel;
        }

        protected JComponent createSouthPanel() {
            JComponent superPanel = super.createSouthPanel();
            JPanel result = new JPanel(new BorderLayout());
            result.add((Component)superPanel, "East");
            JComponent buttonsPanel = this.myHttpRequestMemberPanel.getSelectDeselectButtons();
            result.add((Component)buttonsPanel, "West");
            return result;
        }

        @NotNull
        protected String getHelpId() {
            return "http.request.move.dialog";
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPathTextField;
        }

        @NotNull
        public String getTargetPath() {
            String string = this.myPathTextField.getText();
            if (string == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public List<HttpRequestBlock> getSelectedRequests() {
            List list = ContainerUtil.map((Collection)((HttpRequestMemberTable)this.myHttpRequestMemberPanel.getTable()).getSelectedMemberInfos(), MemberInfoBase::getMember);
            if (list == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String path = PathUtil.toSystemIndependentName((String)this.getTargetPath());
            if (StringUtil.isEmpty((String)path)) {
                return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.file.is.empty", new Object[0]), (JComponent)this.myPathTextField);
            }
            VirtualFile target = LocalFileSystem.getInstance().findFileByPath(path);
            if (target == null) {
                Optional<String> invalidSegment;
                VirtualFile parent = ExtractHttpRequestFileDialog.getExistingParent(path);
                if (parent == null || !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(parent) && !ScratchRootType.getInstance().containsFile(parent)) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.not.inside.project", new Object[0]), (JComponent)this.myPathTextField);
                }
                String relativePath = FileUtil.getRelativePath((String)parent.getPath(), (String)path, (char)'/');
                if (StringUtil.isNotEmpty((String)relativePath) && (invalidSegment = StringUtil.split((String)relativePath, (String)"/").stream().filter(segment -> !PathUtil.isValidFileName((String)segment)).findFirst()).isPresent()) {
                    String message = RestClientBundle.message("rest.client.refactoring.file.not.valid.name", invalidSegment.get());
                    return new ValidationInfo(message, (JComponent)this.myPathTextField);
                }
            } else {
                if (target.isDirectory()) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.is.a.directory", new Object[0]), (JComponent)this.myPathTextField);
                }
                if (!ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(target) && !ScratchRootType.getInstance().containsFile(target)) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.not.inside.project", new Object[0]), (JComponent)this.myPathTextField);
                }
                PsiFile original = this.myRequest.getContainingFile();
                if (original != null && FileUtil.pathsEqual((String)original.getVirtualFile().getPath(), (String)target.getPath())) {
                    return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.target.file.same.as.original", new Object[0]), (JComponent)this.myPathTextField);
                }
            }
            if (((HttpRequestMemberTable)this.myHttpRequestMemberPanel.getTable()).getSelectedMemberInfos().isEmpty()) {
                return new ValidationInfo(RestClientBundle.message("rest.client.refactoring.empty.selection", new Object[0]), (JComponent)((Object)this.myHttpRequestMemberPanel));
            }
            return super.doValidate();
        }

        @Nullable
        private static VirtualFile getExistingParent(@NotNull String path) {
            if (path == null) {
                ExtractHttpRequestFileDialog.$$$reportNull$$$0(10);
            }
            VirtualFile parent = null;
            while (path.length() > 0 && parent == null) {
                path = PathUtil.getParentPath((String)path);
                parent = LocalFileSystem.getInstance().findFileByPath(path);
            }
            return parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$ExtractHttpRequestFileDialog";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/refactoring/HttpMoveRequestDelegate$ExtractHttpRequestFileDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllHttpClientFilesInProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFileVariants";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScratchIcon";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedRequests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllHttpClientFilesInProject";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultDirectory";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getExistingParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

