/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ws.http.request.HttpRequestLanguage;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.highlighting.HttpRequestSyntaxHighlighter;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.rest.client.RestClientBundle;
import org.jetbrains.annotations.NotNull;

public class HttpRequestTemplateContextType
extends TemplateContextType {
    protected HttpRequestTemplateContextType() {
        super("REQUEST", RestClientBundle.message("http.request.element.name", new Object[0]));
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            HttpRequestTemplateContextType.$$$reportNull$$$0(0);
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)HttpRequestLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace && offset > 0) {
                element = file.findElementAt(offset - 1);
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected boolean isInContext(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestTemplateContextType.$$$reportNull$$$0(1);
        }
        if (!HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.HOST_VALUE)) {
            return false;
        }
        HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class);
        return request != null && request.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
    }

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new HttpRequestSyntaxHighlighter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/ws/http/request/liveTemplates/HttpRequestTemplateContextType";
        objectArray[2] = "isInContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

