/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.environment;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentInputFilter;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HttpRequestEnvironmentIndex
extends FileBasedIndexExtension<String, Set<String>> {
    @NonNls
    public static final ID<String, Set<String>> KEY = ID.create((String)"http.request.execution.environment");
    private static final FileBasedIndex.InputFilter HTTP_ENVIRONMENT_INPUT_FILTER = new HttpRequestEnvironmentInputFilter();

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = KEY;
        if (iD == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        return new DataIndexer<String, Set<String>, FileContent>(){

            @NotNull
            public Map<String, Set<String>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiFile file = inputData.getPsiFile();
                assert (file instanceof JsonFile);
                JsonValue root = ((JsonFile)file).getTopLevelValue();
                if (!(root instanceof JsonObject)) {
                    Map<String, Set<String>> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                THashMap result = new THashMap();
                for (JsonProperty property : ((JsonObject)root).getPropertyList()) {
                    JsonValue value = property.getValue();
                    if (!(value instanceof JsonObject)) continue;
                    result.put(property.getName(), HttpRequestEnvironmentIndex.readEnvVariables((JsonObject)value));
                }
                THashMap tHashMap = result;
                if (tHashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static Set<String> readEnvVariables(@NotNull JsonObject obj) {
        List properties;
        if (obj == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(1);
        }
        if ((properties = obj.getPropertyList()).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HttpRequestEnvironmentIndex.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<String> set = properties.stream().map(property -> StringUtil.nullize((String)property.getName())).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        return new HttpRequestEnvironmentExternalizer();
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = HTTP_ENVIRONMENT_INPUT_FILTER;
        if (inputFilter == null) {
            HttpRequestEnvironmentIndex.$$$reportNull$$$0(5);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readEnvVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpRequestEnvironmentExternalizer
    implements DataExternalizer<Set<String>> {
        private HttpRequestEnvironmentExternalizer() {
        }

        public synchronized void save(@NotNull DataOutput out, Set<String> value) throws IOException {
            if (out == null) {
                HttpRequestEnvironmentExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (String s : value) {
                EnumeratorStringDescriptor.INSTANCE.save(out, s);
            }
        }

        public synchronized Set<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                HttpRequestEnvironmentExternalizer.$$$reportNull$$$0(1);
            }
            THashSet set = new THashSet();
            for (int r = in.readInt(); r > 0; --r) {
                set.add((Object)EnumeratorStringDescriptor.INSTANCE.read(in));
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentIndex$HttpRequestEnvironmentExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

