/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.documentation.comments;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.http.request.HttpRequestPsiFactory;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.documentation.comments.HttpDocComment;
import com.intellij.ws.http.request.documentation.comments.HttpDocCommentTagDescriptor;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoCookieJarTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoRedirectTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocUseOsCredentialsTag;
import com.intellij.ws.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpDocTagsDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof HttpDocNoRedirectTag) {
            return RestClientBundle.message("http.request.doc.comment.documentation.no.redirect", new Object[0]);
        }
        if (element instanceof HttpDocNoLogResponseTag) {
            return RestClientBundle.message("http.request.doc.comment.documentation.no.log", new Object[0]);
        }
        if (element instanceof HttpDocNoCookieJarTag) {
            return RestClientBundle.message("http.request.doc.comment.documentation.no.cookie", new Object[0]);
        }
        if (element instanceof HttpDocUseOsCredentialsTag) {
            return RestClientBundle.message("http.request.doc.comment.documentation.use.os.credentials", new Object[0]);
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof HttpDocCommentTagDescriptor) {
            Project project;
            String text = ((HttpDocCommentTagDescriptor)object).getText();
            if (HttpRequestPsiUtils.isOfTypes(element, HttpRequestTokenTypeSets.DOC_TAGS) && StringUtil.equals((CharSequence)text, (CharSequence)element.getText())) {
                return element;
            }
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (StringUtil.isNotEmpty((String)text) && project != null) {
                List<Object> tags;
                HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, "#" + text);
                HttpDocComment docComment = (HttpDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, HttpDocComment.class);
                List<Object> list = tags = docComment != null ? docComment.getTags() : Collections.emptyList();
                if (tags.size() == 1) {
                    return (PsiElement)tags.get(0);
                }
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            HttpDocTagsDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HttpDocTagsDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof HttpRequestPsiFile) {
            if (contextElement == null || contextElement instanceof PsiWhiteSpace) {
                contextElement = file.findElementAt(targetOffset - 1);
            }
            if (contextElement != null && HttpRequestPsiUtils.isOfTypes(contextElement, HttpRequestTokenTypeSets.DOC_TAGS)) {
                return contextElement.getParent();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/ws/http/request/documentation/comments/HttpDocTagsDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

