/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.environment;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpClientDataKeys;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestNewEnvironmentFileAction
extends AnAction
implements DumbAware {
    protected HttpRequestNewEnvironmentFileAction(@Nullable String actionName, @NotNull String description) {
        if (description == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(0);
        }
        super(actionName, description, JsonFileType.INSTANCE.getIcon());
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean isFileExistsInCurrentDirectory(@NotNull AnActionEvent e, @NotNull String filename) {
        Project project;
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(1);
        }
        if (filename == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) != null) {
            VirtualFile virtualDir;
            PsiDirectory psiDir = HttpRequestNewEnvironmentFileAction.getPsiDirectory(e);
            VirtualFile virtualFile = virtualDir = psiDir != null ? psiDir.getVirtualFile() : null;
            if (virtualDir != null) {
                return virtualDir.isDirectory() && virtualDir.findChild(filename) != null;
            }
        }
        return false;
    }

    protected void createHttpClientEnvFile(@NotNull AnActionEvent e, @Nullable String filename, @NotNull String templateName) {
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(3);
        }
        if (templateName == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(4);
        }
        PsiDirectory psiDirectory = HttpRequestNewEnvironmentFileAction.getPsiDirectory(e);
        String defaultVariableName = (String)e.getData(HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME);
        WriteCommandAction.writeCommandAction((Project)e.getProject()).withName(RestClientBundle.message("http.request.create.new.environment.file.command.name", new Object[0])).run(() -> {
            VirtualFile virtualFile;
            Map variables;
            FileTemplate template;
            PsiFile file;
            if (psiDirectory != null && (file = CreateFileFromTemplateAction.createFileFromTemplate((String)filename, (FileTemplate)(template = FileTemplateManager.getInstance((Project)psiDirectory.getProject()).getInternalTemplate(templateName)), (PsiDirectory)psiDirectory, null, (boolean)true, (Map)(variables = defaultVariableName != null ? ContainerUtil.immutableMapBuilder().put((Object)"name", (Object)defaultVariableName).build() : Collections.emptyMap()))) != null && (virtualFile = file.getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true);
            }
        });
    }

    @Nls
    @NotNull
    public abstract String getDetailedDescription();

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiFile currentPsiFile;
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        VirtualFile currentFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (currentFile != null && e.getProject() != null && (currentPsiFile = PsiManager.getInstance((Project)e.getProject()).findFile(currentFile)) != null && currentPsiFile.getContainingDirectory() != null) {
            return currentPsiFile.getContainingDirectory();
        }
        return null;
    }

    @Nullable
    public static String getEnvFilename(@NotNull EnvironmentType environmentType) {
        if (environmentType == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(5);
        }
        switch (environmentType) {
            case PRIVATE: {
                return HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES[0];
            }
            case PUBLIC: {
                return HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES[0];
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/actions/environment/HttpRequestNewEnvironmentFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileExistsInCurrentDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createHttpClientEnvFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvFilename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum EnvironmentType {
        PUBLIC,
        PRIVATE;

    }
}

