/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.include;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSFileType;

public class SassScssFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    private static final String SASS_EXT = "sass";
    private static final String SCSS_EXT = "scss";

    @NotNull
    public String getId() {
        return "SASS/SCSS";
    }

    public boolean acceptFile(VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SASSFileType.SASS) || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SCSSFileType.SCSS);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(0);
        }
        fileTypeSink.consume((Object)SASSFileType.SASS);
        fileTypeSink.consume((Object)SCSSFileType.SCSS);
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(1);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(2);
        }
        if (hostFileExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(3);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (importUriExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(5);
        }
        if (SASS_EXT.equalsIgnoreCase(importUriExt) || SCSS_EXT.equalsIgnoreCase(importUriExt)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri);
        } else if (!SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SCSS_EXT)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SASS_EXT);
        }
    }

    @NotNull
    protected Language getLanguage() {
        SASSLanguage sASSLanguage = SASSLanguage.INSTANCE;
        if (sASSLanguage == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(6);
        }
        return sASSLanguage;
    }

    private static boolean tryAddImport(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String importUri) {
        String path;
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(7);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(8);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(9);
        }
        VirtualFile file = SassScssFileIncludeProvider.resolveImport(hostFile, importUri);
        VirtualFile hostFileDir = hostFile.getParent();
        if (file != null && hostFileDir != null && (path = SassScssFileIncludeProvider.getRelativePath(hostFileDir, file)) != null) {
            result.add(new FileIncludeInfo(path));
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile hostFileDir, @NotNull VirtualFile importedFile) {
        VirtualFile commonAncestor;
        if (hostFileDir == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(10);
        }
        if (importedFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(11);
        }
        if ((commonAncestor = VfsUtilCore.getCommonAncestor((VirtualFile)hostFileDir, (VirtualFile)importedFile)) == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        VirtualFile dir = hostFileDir;
        while (!commonAncestor.equals(dir)) {
            buffer.append("../");
            if ((dir = dir.getParent()) != null) continue;
            return null;
        }
        buffer.append(VfsUtilCore.getRelativePath((VirtualFile)importedFile, (VirtualFile)commonAncestor, (char)'/'));
        return buffer.toString();
    }

    @Nullable
    private static VirtualFile resolveImport(@NotNull VirtualFile hostFile, @NotNull String importUri) {
        String systemIndependentImportUri;
        VirtualFile importedFile;
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(12);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(13);
        }
        if ((importedFile = SassScssFileIncludeProvider.findFile(hostFile, systemIndependentImportUri = FileUtil.toSystemIndependentName((String)importUri))) != null && importedFile.isValid()) {
            return importedFile;
        }
        String partialImportUri = SassScssFileIncludeProvider.createPartialImportUri(systemIndependentImportUri);
        VirtualFile partialImportedFile = SassScssFileIncludeProvider.findFile(hostFile, partialImportUri);
        if (partialImportedFile != null && partialImportedFile.isValid()) {
            return partialImportedFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull VirtualFile hostFile, @NotNull String systemIndependentImportUri) {
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(14);
        }
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(15);
        }
        if (FileUtil.isAbsolutePlatformIndependent((String)systemIndependentImportUri)) {
            return hostFile.getFileSystem().findFileByPath(systemIndependentImportUri);
        }
        VirtualFile hostFileDir = hostFile.getParent();
        if (hostFileDir == null) {
            return null;
        }
        return hostFileDir.findFileByRelativePath(systemIndependentImportUri);
    }

    private static String createPartialImportUri(@NotNull String systemIndependentImportUri) {
        int pos;
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(16);
        }
        if ((pos = systemIndependentImportUri.lastIndexOf(47)) == -1) {
            return "_" + systemIndependentImportUri;
        }
        String baseName = systemIndependentImportUri.substring(pos + 1);
        String dirName = systemIndependentImportUri.substring(0, pos);
        return dirName + "/_" + baseName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileExt";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUri";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUriExt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIndependentImportUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryAddImport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPartialImportUri";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

